/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster.server.metrics;

import com.codahale.metrics.MetricRegistry;
import com.tinkerpop.rexster.server.metrics.AbstractReporterConfig;
import com.tinkerpop.rexster.server.metrics.HostPort;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.log4j.Logger;

public abstract class AbstractHostPortReporterConfig
extends AbstractReporterConfig {
    private static final Logger logger = Logger.getLogger(AbstractHostPortReporterConfig.class);
    private List<HostPort> hosts;
    protected String hostsString;

    public AbstractHostPortReporterConfig(HierarchicalConfiguration config, MetricRegistry metricRegistry) {
        super(config, metricRegistry);
    }

    public List<HostPort> getHosts() {
        return this.hosts;
    }

    public List<HostPort> parseHostString() {
        ArrayList<HostPort> hosts = new ArrayList<HostPort>();
        String[] hostPairs = this.hostsString.split(",");
        for (int i = 0; i < hostPairs.length; ++i) {
            String[] pair = hostPairs[i].split(":");
            hosts.add(new HostPort(pair[0], Integer.valueOf(pair[1])));
        }
        return hosts;
    }

    public List<HostPort> getHostListAndStringList() {
        if (this.getHosts() == null && this.hostsString == null) {
            logger.warn((Object)"No hosts specified as a list or delimited string");
            return null;
        }
        if (this.getHosts() != null && this.hostsString != null) {
            logger.warn((Object)"There are reporter hosts configured as a list and delimited string?");
        }
        ArrayList<HostPort> combinedHosts = new ArrayList<HostPort>();
        if (this.getHosts() != null) {
            combinedHosts.addAll(this.getHosts());
        }
        if (this.hostsString != null) {
            combinedHosts.addAll(this.parseHostString());
        }
        return combinedHosts;
    }

    public abstract List<HostPort> getFullHostList();
}

