/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.jboss.modules.StreamUtil;

class MavenArtifactUtil {
    private static final Object artifactLock = new Object();

    MavenArtifactUtil() {
    }

    public static String[] getLocalRepositoryPaths() {
        String localRepositoryPath = System.getProperty("local.maven.repo.path");
        if (localRepositoryPath == null) {
            File m2 = new File(System.getProperty("user.home"), ".m2");
            File repository = new File(m2, "repository");
            String path = repository.getAbsolutePath();
            String[] rtn = new String[]{path};
            return rtn;
        }
        return localRepositoryPath.split(File.pathSeparator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File resolveJarArtifact(String qualifier) throws IOException {
        String[] split = qualifier.split(":");
        if (split.length < 3) {
            throw new IllegalArgumentException("Illegal artifact");
        }
        String groupId = split[0];
        String artifactId = split[1];
        String version = split[2];
        String classifier = "";
        if (split.length >= 4) {
            classifier = "-" + split[3];
        }
        String artifactRelativePath = MavenArtifactUtil.relativeArtifactPath(groupId, artifactId, version);
        String[] localRepositoryPaths = MavenArtifactUtil.getLocalRepositoryPaths();
        Object object = artifactLock;
        synchronized (object) {
            String jarPath = artifactRelativePath + classifier + ".jar";
            for (String localRepository : localRepositoryPaths) {
                File fp = new File(localRepository, jarPath);
                if (!fp.exists()) continue;
                return fp;
            }
            String remoteRepository = System.getProperty("remote.maven.repo");
            if (remoteRepository == null) {
                return null;
            }
            if (!remoteRepository.endsWith("/")) {
                remoteRepository = remoteRepository + "/";
            }
            File jarFile = new File(localRepositoryPaths[0], jarPath);
            File pomFile = new File(localRepositoryPaths[0], artifactRelativePath + ".pom");
            String remotePomPath = remoteRepository + MavenArtifactUtil.relativeArtifactHttpPath(groupId, artifactId, version) + ".pom";
            String remoteJarPath = remoteRepository + MavenArtifactUtil.relativeArtifactHttpPath(groupId, artifactId, version) + classifier + ".jar";
            MavenArtifactUtil.downloadFile(qualifier + ":pom", remotePomPath, pomFile);
            MavenArtifactUtil.downloadFile(qualifier + ":jar", remoteJarPath, jarFile);
            return jarFile;
        }
    }

    public static String relativeArtifactPath(String groupId, String artifactId, String version) {
        return MavenArtifactUtil.relativeArtifactPath(File.separatorChar, groupId, artifactId, version);
    }

    public static String relativeArtifactHttpPath(String groupId, String artifactId, String version) {
        return MavenArtifactUtil.relativeArtifactPath('/', groupId, artifactId, version);
    }

    private static String relativeArtifactPath(char separator, String groupId, String artifactId, String version) {
        StringBuilder builder = new StringBuilder(groupId.replace('.', separator));
        builder.append(separator).append(artifactId).append(separator).append(version).append(separator).append(artifactId).append('-').append(version);
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadFile(String artifact, String src, File dest) throws IOException {
        URL url = new URL(src);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        boolean message = Boolean.parseBoolean(System.getProperty("maven.download.message", "true"));
        InputStream bis = connection.getInputStream();
        try {
            dest.getParentFile().mkdirs();
            FileOutputStream fos = new FileOutputStream(dest);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            try {
                if (message) {
                    System.out.println("Downloading " + artifact);
                }
                StreamUtil.copy(bis, bos);
            }
            finally {
                StreamUtil.safeClose(fos);
            }
        }
        finally {
            StreamUtil.safeClose(bis);
        }
    }
}

