/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster.client;

import com.tinkerpop.rexster.client.RemoteRexsterSession;
import com.tinkerpop.rexster.protocol.msg.ScriptRequestMessage;
import com.tinkerpop.rexster.protocol.msg.ScriptResponseMessage;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import org.msgpack.MessagePack;

public class TryRexProSessioned {
    public static void main(String[] args) {
        TryRexProSessioned.lotsOfCalls(false);
    }

    private static void bigCalls() {
        RemoteRexsterSession session = new RemoteRexsterSession("localhost", 8184, 100, "", "");
        session.open();
        long start = System.currentTimeMillis();
        long checkpoint = System.currentTimeMillis();
        try {
            ScriptResponseMessage resultMessage = (ScriptResponseMessage)session.sendRequest(TryRexProSessioned.createScriptRequestMessage(session, "g=rexster.getGraph('gratefulgraph');g.V;"), 100);
            resultMessage = (ScriptResponseMessage)session.sendRequest(TryRexProSessioned.createScriptRequestMessage(session, "g.E;"), 100);
            System.out.println(checkpoint - start + ":" + (System.currentTimeMillis() - checkpoint));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void lotsOfCalls(boolean doJson) {
        RemoteRexsterSession session = new RemoteRexsterSession("localhost", 8184, 100, "", "");
        session.open();
        MessagePack msgpack = new MessagePack();
        long start = System.currentTimeMillis();
        long checkpoint = System.currentTimeMillis();
        try {
            ScriptResponseMessage resultMessage = (ScriptResponseMessage)session.sendRequest(TryRexProSessioned.createScriptRequestMessage(session, "g=rexster.getGraph('gratefulgraph');g.V;"), 100);
            int counter = 1;
            for (Map map : (Iterable)((Object)resultMessage.Results)) {
                String vId = (String)map.get("_id");
                ScriptResponseMessage vertexResultMessage = (ScriptResponseMessage)session.sendRequest(TryRexProSessioned.createScriptRequestMessage(session, "g.v(" + vId + ")"), 100);
                System.out.println(vertexResultMessage.Results);
                ++counter;
            }
            long end = System.currentTimeMillis() - checkpoint;
            System.out.println(checkpoint - start + ":" + end);
            System.out.println((long)counter / (end / 1000L));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static ScriptRequestMessage createScriptRequestMessage(RemoteRexsterSession session, String script) throws IOException {
        ScriptRequestMessage scriptMessage = new ScriptRequestMessage();
        scriptMessage.setSessionAsUUID(session.getSessionKey());
        scriptMessage.Script = script;
        scriptMessage.LanguageName = "groovy";
        scriptMessage.metaSetInSession(true);
        scriptMessage.setRequestAsUUID(UUID.randomUUID());
        return scriptMessage;
    }
}

