/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster.protocol.session;

import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.rexster.client.RexProException;
import com.tinkerpop.rexster.protocol.EngineController;
import com.tinkerpop.rexster.protocol.RexsterApplicationHolder;
import com.tinkerpop.rexster.protocol.server.RexProRequest;
import com.tinkerpop.rexster.protocol.server.ScriptServer;
import com.tinkerpop.rexster.server.RexsterApplication;
import java.util.concurrent.Callable;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.script.SimpleBindings;

public abstract class AbstractRexProSession {
    protected final Bindings bindings = new SimpleBindings();
    protected final EngineController controller = EngineController.getInstance();
    protected final RexsterApplication rexsterApplication;
    protected Graph graphObj = null;
    protected String graphObjName = null;

    public AbstractRexProSession(RexsterApplication rexsterApplication) {
        this.bindings.put("rexster", (Object)new RexsterApplicationHolder(rexsterApplication));
        this.rexsterApplication = rexsterApplication;
    }

    public void setGraphObj(String graphName, String graphObjName) throws RexProException {
        this.graphObj = this.rexsterApplication.getGraph(graphName);
        if (this.graphObj == null) {
            throw new RexProException("the graph '" + graphName + "' was not found by Rexster");
        }
        this.graphObjName = graphObjName;
        this.bindings.put(this.graphObjName, (Object)this.graphObj);
    }

    public Graph getGraphObj() {
        return this.graphObj;
    }

    public Boolean hasGraphObj() {
        return this.graphObj != null;
    }

    public Bindings getBindings() {
        return this.bindings;
    }

    public void evaluate(String script, String languageName, Bindings requestBindings, Boolean isolate, Boolean inTransaction, Graph graph, RexProRequest request) throws ScriptException {
        Bindings executorBindings;
        ScriptEngine engine = this.controller.getEngineByLanguageName(languageName).getEngine();
        if (isolate.booleanValue()) {
            executorBindings = new SimpleBindings();
            executorBindings.putAll(this.bindings);
        } else {
            executorBindings = this.bindings;
        }
        if (requestBindings != null) {
            executorBindings.putAll(requestBindings);
        }
        this.execute(new Evaluator(engine, script, executorBindings, inTransaction, graph, request));
    }

    protected abstract void execute(Evaluator var1) throws ScriptException;

    protected class Evaluator
    implements Callable {
        private ScriptEngine engine;
        private final Bindings bindings;
        private final String script;
        private Boolean inTransaction;
        private Graph graph;
        private RexProRequest request;

        public Evaluator(ScriptEngine engine, String script, Bindings bindings, Boolean inTransaction, Graph graph, RexProRequest request) {
            this.script = script;
            this.engine = engine;
            this.bindings = bindings;
            this.inTransaction = inTransaction;
            this.graph = graph;
            this.request = request;
        }

        public Object call() throws Exception {
            if (this.inTransaction.booleanValue()) {
                ScriptServer.tryRollbackTransaction(this.graph);
            }
            Object result = this.engine.eval(this.script, this.bindings);
            this.request.writeScriptResults(result);
            if (this.inTransaction.booleanValue()) {
                ScriptServer.tryCommitTransaction(this.graph);
            }
            return null;
        }
    }
}

