/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.relations;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.thinkaurelius.titan.core.EdgeLabel;
import com.thinkaurelius.titan.core.InvalidElementException;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.RelationType;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.graphdb.internal.AbstractElement;
import com.thinkaurelius.titan.graphdb.internal.InternalRelation;
import com.thinkaurelius.titan.graphdb.internal.InternalRelationType;
import com.thinkaurelius.titan.graphdb.internal.InternalVertex;
import com.thinkaurelius.titan.graphdb.relations.EdgeDirection;
import com.thinkaurelius.titan.graphdb.relations.RelationIdentifier;
import com.thinkaurelius.titan.graphdb.transaction.StandardTitanTx;
import com.thinkaurelius.titan.graphdb.types.system.ImplicitKey;
import com.tinkerpop.blueprints.Direction;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractTypedRelation
extends AbstractElement
implements InternalRelation {
    protected final InternalRelationType type;

    public AbstractTypedRelation(long id, RelationType type) {
        super(id);
        assert (type != null && type instanceof InternalRelationType);
        this.type = (InternalRelationType)type;
    }

    @Override
    public InternalRelation it() {
        InternalVertex v = this.getVertex(0);
        if (v == v.it()) {
            return this;
        }
        InternalRelation next = (InternalRelation)RelationIdentifier.get(this).findRelation(this.tx());
        if (next == null) {
            throw new InvalidElementException("Relation has been removed", this);
        }
        return next;
    }

    @Override
    public final StandardTitanTx tx() {
        return this.getVertex(0).tx();
    }

    @Override
    public Direction getDirection(TitanVertex vertex) {
        for (int i = 0; i < this.getArity(); ++i) {
            if (!this.it().getVertex(i).equals(vertex)) continue;
            return EdgeDirection.fromPosition(i);
        }
        throw new IllegalArgumentException("Relation is not incident on vertex");
    }

    @Override
    public boolean isIncidentOn(TitanVertex vertex) {
        for (int i = 0; i < this.getArity(); ++i) {
            if (!this.it().getVertex(i).equals(vertex)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isHidden() {
        return this.type.isHiddenType();
    }

    @Override
    public boolean isLoop() {
        return this.getArity() == 2 && this.getVertex(0).equals(this.getVertex(1));
    }

    @Override
    public RelationType getType() {
        return this.type;
    }

    @Override
    public RelationIdentifier getId() {
        return RelationIdentifier.get(this);
    }

    @Override
    public <O> O removeProperty(String key) {
        if (!this.tx().containsRelationType(key)) {
            return null;
        }
        return this.removeProperty(this.tx().getRelationType(key));
    }

    @Override
    public <O> O removeProperty(RelationType type) {
        Preconditions.checkArgument((!this.it().isRemoved() ? 1 : 0) != 0, (Object)"Cannot modified removed relation");
        return this.it().removePropertyDirect(type);
    }

    @Override
    public void setProperty(EdgeLabel label, TitanVertex vertex) {
        Preconditions.checkArgument((!this.it().isRemoved() ? 1 : 0) != 0, (Object)"Cannot modified removed relation");
        Preconditions.checkArgument((boolean)label.isUnidirected(), (Object)"Label must be unidirected");
        Preconditions.checkArgument((vertex != null ? 1 : 0) != 0, (Object)"Vertex cannot be null");
        this.it().setPropertyDirect(label, vertex);
    }

    @Override
    public void setProperty(PropertyKey key, Object value) {
        Preconditions.checkArgument((!this.it().isRemoved() ? 1 : 0) != 0, (Object)"Cannot modified removed relation");
        this.it().setPropertyDirect(key, this.tx().verifyAttribute(key, value));
    }

    @Override
    public void setProperty(String key, Object value) {
        RelationType type = this.tx().getRelationType(key);
        if (type instanceof PropertyKey) {
            this.setProperty((PropertyKey)type, value);
        } else if (type instanceof EdgeLabel) {
            Preconditions.checkArgument((boolean)(value instanceof TitanVertex), (Object)"Value must be a vertex");
            this.setProperty((EdgeLabel)type, (InternalVertex)value);
        } else if (type == null) {
            if (value instanceof TitanVertex) {
                this.setProperty(this.tx().getEdgeLabel(key), (TitanVertex)value);
            }
            this.setProperty(this.tx().getPropertyKey(key), value);
        } else {
            throw new IllegalArgumentException("Invalid key argument: " + key);
        }
    }

    @Override
    public <O> O getProperty(PropertyKey key) {
        if (key instanceof ImplicitKey) {
            return ((ImplicitKey)key).computeProperty(this);
        }
        return this.it().getPropertyDirect(key);
    }

    @Override
    public <O> O getProperty(String key) {
        RelationType type = this.tx().getRelationType(key);
        if (type == null) {
            return null;
        }
        if (type.isPropertyKey()) {
            return this.getProperty((PropertyKey)type);
        }
        return (O)this.getProperty((EdgeLabel)type);
    }

    @Override
    public TitanVertex getProperty(EdgeLabel label) {
        Object val = this.it().getPropertyDirect(label);
        if (val == null) {
            return null;
        }
        if (val instanceof Number) {
            return this.tx().getInternalVertex(((Number)val).longValue());
        }
        if (val instanceof TitanVertex) {
            return (TitanVertex)val;
        }
        throw new IllegalStateException("Invalid object found instead of vertex: " + val);
    }

    @Override
    public <O> O getProperty(RelationType type) {
        if (type.isEdgeLabel()) {
            return (O)this.getProperty((EdgeLabel)type);
        }
        return this.getProperty((PropertyKey)type);
    }

    public Set<String> getPropertyKeys() {
        HashSet result = Sets.newHashSet();
        for (RelationType type : this.it().getPropertyKeysDirect()) {
            result.add(type.getName());
        }
        return result;
    }
}

