/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.util.xml;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang.StringUtils;
import org.jboss.windup.util.exception.MarshallingException;
import org.jboss.windup.util.exception.XPathException;
import org.jboss.windup.util.xml.LocationAwareXmlReader;
import org.jboss.windup.util.xml.NamespaceMapContext;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlUtil {
    protected static final Map<String, String> objs = new HashMap<String, String>();

    public static Map<String, String> getSchemaLocations(Document doc) {
        String schemaLocation;
        HashSet<String> namespaces = new HashSet<String>();
        namespaces.addAll(LocationAwareXmlReader.getNamespaces(doc));
        try {
            schemaLocation = XmlUtil.xpathExtract(doc, "//@xsi:schemaLocation", objs);
        }
        catch (MarshallingException e) {
            throw new RuntimeException("Exception extracting xpath.", e);
        }
        HashMap<String, String> result = new HashMap<String, String>();
        if (StringUtils.isNotBlank((String)schemaLocation)) {
            schemaLocation = StringUtils.trim((String)schemaLocation);
            String[] locations = schemaLocation.split("\\s+");
            int j = locations.length - 1;
            for (int i = 0; i < j; ++i) {
                if (!namespaces.contains(locations[i])) continue;
                result.put(locations[i], locations[i + 1]);
            }
        }
        for (String r : result.keySet()) {
            namespaces.remove(r);
        }
        if (namespaces.size() > 0) {
            for (String namespace : namespaces) {
                result.put(namespace, null);
            }
        }
        return result;
    }

    public static boolean xpathExists(Node document, String xpathExpression, Map<String, String> namespaceMapping) throws XPathException, MarshallingException {
        Boolean result = (Boolean)XmlUtil.executeXPath(document, xpathExpression, namespaceMapping, XPathConstants.BOOLEAN);
        return result != null && result != false;
    }

    public static String xpathExtract(Node document, String xpathExpression, Map<String, String> namespaceMapping) throws XPathException, MarshallingException {
        return (String)XmlUtil.executeXPath(document, xpathExpression, namespaceMapping, XPathConstants.STRING);
    }

    public static NodeList xpathNodeList(Node document, String xpathExpression, Map<String, String> namespaceMapping) throws XPathException, MarshallingException {
        return (NodeList)XmlUtil.executeXPath(document, xpathExpression, namespaceMapping, XPathConstants.NODESET);
    }

    public static Object executeXPath(Node document, String xpathExpression, Map<String, String> namespaceMapping, QName result) throws XPathException, MarshallingException {
        NamespaceMapContext mapContext = new NamespaceMapContext(namespaceMapping);
        try {
            XPathFactory xPathfactory = XPathFactory.newInstance();
            XPath xpath = xPathfactory.newXPath();
            xpath.setNamespaceContext(mapContext);
            XPathExpression expr = xpath.compile(xpathExpression);
            return expr.evaluate(document, result);
        }
        catch (XPathExpressionException e) {
            throw new XPathException("Xpath(" + xpathExpression + ") cannot be compiled", e);
        }
        catch (Exception e) {
            throw new MarshallingException("Exception unmarshalling XML.", e);
        }
    }

    static {
        objs.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
    }
}

