/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.scan.operation;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.operation.ruleelement.AbstractIterationOperation;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ArchiveModel;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.FileModelService;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.graph.service.WindupConfigurationService;
import org.jboss.windup.reporting.service.ClassificationService;
import org.jboss.windup.rules.apps.java.model.IgnoredFileModel;
import org.jboss.windup.rules.apps.java.service.WindupJavaConfigurationService;
import org.jboss.windup.util.Logging;
import org.jboss.windup.util.ZipUtil;
import org.jboss.windup.util.exception.WindupException;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class UnzipArchiveToOutputFolder
extends AbstractIterationOperation<ArchiveModel> {
    private static final String ARCHIVES = "archives";
    private static final Logger LOG = Logging.get(UnzipArchiveToOutputFolder.class);

    public UnzipArchiveToOutputFolder(String variableName) {
        super(variableName);
    }

    public UnzipArchiveToOutputFolder() {
    }

    public static UnzipArchiveToOutputFolder unzip(String variableName) {
        return new UnzipArchiveToOutputFolder(variableName);
    }

    public static UnzipArchiveToOutputFolder unzip() {
        return new UnzipArchiveToOutputFolder();
    }

    public void perform(GraphRewrite event, EvaluationContext context, ArchiveModel payload) {
        LOG.info("Unzipping archive: " + payload.toPrettyString());
        File zipFile = payload.asFile();
        if (!zipFile.isFile()) {
            String msg = "Input path doesn't point to a file: " + zipFile.getAbsolutePath();
            throw new WindupException(msg);
        }
        WindupConfigurationModel cfg = WindupConfigurationService.getConfigurationModel((GraphContext)event.getGraphContext());
        String windupOutputFolder = cfg.getOutputPath().getFilePath();
        Path windupTempUnzippedArchiveFolder = Paths.get(windupOutputFolder, ARCHIVES);
        if (!Files.isDirectory(windupTempUnzippedArchiveFolder, new LinkOption[0])) {
            try {
                Files.createDirectories(windupTempUnzippedArchiveFolder, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new WindupException("Failed to create temporary folder: " + windupTempUnzippedArchiveFolder + " due to: " + e.getMessage(), (Throwable)e);
            }
        }
        this.unzipToTempDirectory(event.getGraphContext(), windupTempUnzippedArchiveFolder, zipFile, payload);
    }

    private Path getAppArchiveFolder(Path tempFolder, String appArchiveName) {
        Path appArchiveFolder = Paths.get(tempFolder.toString(), appArchiveName);
        int fileIdx = 1;
        while (Files.exists(appArchiveFolder, new LinkOption[0])) {
            appArchiveFolder = Paths.get(tempFolder.toString(), appArchiveName + "." + fileIdx);
            ++fileIdx;
        }
        return appArchiveFolder;
    }

    private void unzipToTempDirectory(GraphContext context, Path tempFolder, File inputZipFile, ArchiveModel archiveModel) {
        FileModelService fileService = new FileModelService(context);
        String appArchiveName = archiveModel.getArchiveName();
        if (null == appArchiveName) {
            throw new IllegalStateException("Archive model doesn't have an archiveName: " + archiveModel.getFilePath());
        }
        Path appArchiveFolder = this.getAppArchiveFolder(tempFolder, appArchiveName);
        try {
            Files.createDirectories(appArchiveFolder, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new WindupException("Could not create a temporary directory for application \"" + appArchiveName + "\" at \"" + appArchiveFolder.toString() + "\" due to: " + e.getMessage(), (Throwable)e);
        }
        LOG.info("Unzipping " + inputZipFile.getPath() + " to " + appArchiveFolder.toString());
        try {
            ZipUtil.unzipToFolder((File)inputZipFile, (File)appArchiveFolder.toFile());
        }
        catch (Throwable e) {
            ClassificationService classificationService = new ClassificationService(context);
            classificationService.attachClassification((FileModel)archiveModel, "Malformed archive", "Cannot unzip the file");
            LOG.warning("Cannot unzip the file " + inputZipFile.getPath() + " to " + appArchiveFolder.toString() + ". The ArchiveModel was classified as malformed.");
            return;
        }
        FileModel newFileModel = fileService.createByFilePath(appArchiveFolder.toString());
        archiveModel.setUnzippedDirectory(newFileModel);
        newFileModel.setParentArchive(archiveModel);
        this.recurseAndAddFiles(context, tempFolder, fileService, archiveModel, newFileModel);
    }

    private void recurseAndAddFiles(GraphContext context, Path tempFolder, FileModelService fileService, ArchiveModel archiveModel, FileModel parentFileModel) {
        File[] subFiles;
        File fileReference = parentFileModel.asFile();
        WindupJavaConfigurationService windupJavaConfigurationService = new WindupJavaConfigurationService(context);
        if (fileReference.isDirectory() && (subFiles = fileReference.listFiles()) != null) {
            for (File subFile : subFiles) {
                FileModel subFileModel = fileService.createByFilePath(parentFileModel, subFile.getAbsolutePath());
                subFileModel.setParentArchive(archiveModel);
                if (this.checkIfIgnored(subFile.getName(), windupJavaConfigurationService.getIgnoredFileRegexes())) {
                    GraphService.addTypeToModel((GraphContext)context, (WindupVertexFrame)subFileModel, IgnoredFileModel.class);
                    LOG.info("File/Directory placed in " + subFile.getAbsolutePath() + " was ignored, because matched some of the ignore regex.");
                    continue;
                }
                if (subFile.isFile() && ZipUtil.endsWithZipExtension((String)subFileModel.getFilePath())) {
                    File newZipFile = subFileModel.asFile();
                    ArchiveModel newArchiveModel = (ArchiveModel)GraphService.addTypeToModel((GraphContext)context, (WindupVertexFrame)subFileModel, ArchiveModel.class);
                    newArchiveModel.setParentArchive(archiveModel);
                    newArchiveModel.setArchiveName(newZipFile.getName());
                    archiveModel.addChildArchive(newArchiveModel);
                    this.unzipToTempDirectory(context, tempFolder, newZipFile, newArchiveModel);
                }
                if (!subFile.isDirectory()) continue;
                this.recurseAndAddFiles(context, tempFolder, fileService, archiveModel, subFileModel);
            }
        }
    }

    private boolean checkIfIgnored(String fileName, List<String> regexes) {
        boolean ignored = false;
        if (regexes != null && regexes.size() != 0) {
            for (String r : regexes) {
                if (!Pattern.matches(r, fileName)) continue;
                ignored = true;
            }
        }
        return ignored;
    }

    public String toString() {
        return "UnzipArchivesToOutputFolder";
    }
}

