/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster.protocol;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.configuration.HierarchicalConfiguration;

public class EngineConfiguration {
    private final int resetCount;
    private final Set<String> initScriptFiles;
    private final String scriptEngineName;
    private final Set<String> imports;
    private final Set<String> staticImports;

    public EngineConfiguration(HierarchicalConfiguration configuration) {
        this.scriptEngineName = configuration.getString("name", "gremlin-groovy");
        this.initScriptFiles = new HashSet<String>(configuration.getList("init-scripts", new ArrayList()));
        this.resetCount = configuration.getInt("reset-threshold", -1);
        this.imports = new HashSet<String>(configuration.getList("imports", new ArrayList()));
        this.staticImports = new HashSet<String>(configuration.getList("static-imports", new ArrayList()));
    }

    public EngineConfiguration(String scriptEngineName, int resetCount, String initScriptFile, Set<String> imports, Set<String> staticImports) {
        this.resetCount = resetCount;
        this.initScriptFiles = new HashSet<String>();
        this.initScriptFiles.add(initScriptFile);
        this.scriptEngineName = scriptEngineName;
        this.imports = imports;
        this.staticImports = staticImports;
    }

    public int getResetCount() {
        return this.resetCount;
    }

    public Set<String> getInitScriptFiles() {
        return this.initScriptFiles;
    }

    public String getScriptEngineName() {
        return this.scriptEngineName;
    }

    public Set<String> getImports() {
        return this.imports;
    }

    public Set<String> getStaticImports() {
        return this.staticImports;
    }
}

