/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster.protocol.server;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.TransactionalGraph;
import com.tinkerpop.rexster.protocol.EngineController;
import com.tinkerpop.rexster.protocol.msg.ErrorResponseMessage;
import com.tinkerpop.rexster.protocol.msg.MessageUtil;
import com.tinkerpop.rexster.protocol.msg.RexProMessage;
import com.tinkerpop.rexster.protocol.msg.ScriptRequestMessage;
import com.tinkerpop.rexster.protocol.server.RexProRequest;
import com.tinkerpop.rexster.protocol.session.AbstractRexProSession;
import com.tinkerpop.rexster.protocol.session.RexProSessions;
import com.tinkerpop.rexster.server.RexsterApplication;
import java.io.IOException;
import javax.script.Bindings;
import javax.script.ScriptException;
import org.apache.log4j.Logger;

public class ScriptServer {
    private static final Logger logger = Logger.getLogger(ScriptServer.class);
    private static final EngineController engineController = EngineController.getInstance();
    private final RexsterApplication rexsterApplication;
    private final Timer scriptTimer;
    private final Counter successfulExecutions;
    private final Counter failedExecutions;

    public ScriptServer(RexsterApplication rexsterApplication) {
        this.rexsterApplication = rexsterApplication;
        MetricRegistry metricRegistry = this.rexsterApplication.getMetricRegistry();
        this.scriptTimer = metricRegistry.timer(MetricRegistry.name((String)"rexpro", (String[])new String[]{"script-engine"}));
        this.successfulExecutions = metricRegistry.counter(MetricRegistry.name((String)"rexpro", (String[])new String[]{"script-engine", "success"}));
        this.failedExecutions = metricRegistry.counter(MetricRegistry.name((String)"rexpro", (String[])new String[]{"script-engine", "fail"}));
    }

    public void handleRequest(ScriptRequestMessage message, RexProRequest request) throws IOException {
        try {
            AbstractRexProSession session;
            Graph graph = null;
            message.validateMetaData();
            if (message.metaGetInSession().booleanValue()) {
                if (message.Session == null) {
                    logger.error((Object)"no session key on message");
                    request.writeResponseMessage(MessageUtil.createErrorResponse(message.Request, RexProMessage.EMPTY_SESSION_AS_BYTES, ErrorResponseMessage.INVALID_SESSION_ERROR, "There was no session key on the message, set the meta field 'inSession' to false if you want to execute sessionless requests"));
                }
                if (ScriptServer.sessionDoesNotExist(request, message, session = RexProSessions.getSession(message.sessionAsUUID().toString()))) {
                    return;
                }
                graph = session.getGraphObj();
                if (ScriptServer.graphIsRedefined(request, message, message, graph)) {
                    return;
                }
            } else {
                session = new EmptySession(this.rexsterApplication);
            }
            Bindings bindings = message.getBindings();
            if (message.metaGetGraphName() != null) {
                graph = this.rexsterApplication.getGraph(message.metaGetGraphName());
                bindings.put(message.metaGetGraphObjName(), (Object)graph);
                if (graph == null) {
                    request.writeResponseMessage(MessageUtil.createErrorResponse(message.Request, RexProMessage.EMPTY_SESSION_AS_BYTES, ErrorResponseMessage.GRAPH_CONFIG_ERROR, "the graph '" + message.metaGetGraphName() + "' was not found by Rexster"));
                    return;
                }
            }
            Timer.Context timer = this.scriptTimer.time();
            try {
                session.evaluate(message.Script, message.LanguageName, bindings, message.metaGetIsolate(), message.metaGetTransaction(), graph, request);
                this.successfulExecutions.inc();
            }
            catch (Exception ex) {
                if (message.metaGetTransaction().booleanValue()) {
                    ScriptServer.tryRollbackTransaction(graph);
                }
                this.failedExecutions.inc();
                throw ex;
            }
            finally {
                timer.stop();
            }
        }
        catch (ScriptException se) {
            logger.warn((Object)("Could not process script [" + message.Script + "] for language [" + message.LanguageName + "] on session [" + message.Session + "] and request [" + message.Request + "]"));
            request.writeResponseMessage(MessageUtil.createErrorResponse(message.Request, RexProMessage.EMPTY_SESSION_AS_BYTES, ErrorResponseMessage.SCRIPT_FAILURE_ERROR, String.format("An error occurred while processing the script for language [%s]. All transactions across all graphs in the session have been concluded with failure: %s", message.LanguageName, se.getMessage())));
        }
        catch (Exception e) {
            logger.error((Object)e);
            request.writeResponseMessage(MessageUtil.createErrorResponse(message.Request, RexProMessage.EMPTY_SESSION_AS_BYTES, ErrorResponseMessage.SCRIPT_FAILURE_ERROR, String.format("An error occurred while processing the script for language [%s]. All transactions across all graphs in the session have been concluded with failure: %s", message.LanguageName, e.toString())));
        }
    }

    public static void tryRollbackTransaction(Graph graph) {
        if (graph == null) {
            return;
        }
        if (graph.getFeatures().supportsTransactions.booleanValue() && graph instanceof TransactionalGraph) {
            ((TransactionalGraph)graph).stopTransaction(TransactionalGraph.Conclusion.FAILURE);
        }
    }

    public static void tryCommitTransaction(Graph graph) {
        if (graph == null) {
            return;
        }
        if (graph.getFeatures().supportsTransactions.booleanValue() && graph instanceof TransactionalGraph) {
            ((TransactionalGraph)graph).stopTransaction(TransactionalGraph.Conclusion.SUCCESS);
        }
    }

    private static boolean graphIsRedefined(RexProRequest request, RexProMessage message, ScriptRequestMessage specificMessage, Graph graph) throws IOException {
        if (specificMessage.metaGetGraphName() != null && graph != null) {
            request.writeResponseMessage(MessageUtil.createErrorResponse(message.Request, RexProMessage.EMPTY_SESSION_AS_BYTES, ErrorResponseMessage.GRAPH_CONFIG_ERROR, "A graph name has already been defined on this session"));
            return true;
        }
        return false;
    }

    private static boolean sessionDoesNotExist(RexProRequest request, RexProMessage message, AbstractRexProSession session) throws IOException {
        if (session == null) {
            request.writeResponseMessage(MessageUtil.createErrorResponse(message.Request, RexProMessage.EMPTY_SESSION_AS_BYTES, ErrorResponseMessage.INVALID_SESSION_ERROR, "The session on the request does not exist or has otherwise expired."));
            return true;
        }
        return false;
    }

    private class EmptySession
    extends AbstractRexProSession {
        private EmptySession(RexsterApplication rexsterApplication) {
            super(rexsterApplication);
        }

        @Override
        protected void execute(AbstractRexProSession.Evaluator evaluator) throws ScriptException {
            try {
                evaluator.call();
            }
            catch (Exception e) {
                throw new ScriptException(e);
            }
        }
    }
}

