/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.facets;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.forge.addon.facets.Facet;
import org.jboss.forge.addon.facets.FacetFactory;
import org.jboss.forge.addon.facets.FacetIsAmbiguousException;
import org.jboss.forge.addon.facets.FacetNotFoundException;
import org.jboss.forge.addon.facets.Faceted;
import org.jboss.forge.addon.facets.MutableFacet;
import org.jboss.forge.addon.facets.MutableFaceted;
import org.jboss.forge.addon.facets.constraints.FacetConstraint;
import org.jboss.forge.addon.facets.constraints.FacetInspector;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.addons.AddonRegistry;
import org.jboss.forge.furnace.container.simple.Service;
import org.jboss.forge.furnace.container.simple.lifecycle.SimpleContainer;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.forge.furnace.services.Imported;
import org.jboss.forge.furnace.util.Assert;
import org.jboss.forge.furnace.util.Predicate;

public class FacetFactoryImpl
implements FacetFactory,
Service {
    private static final Logger log = Logger.getLogger(FacetFactoryImpl.class.getName());
    private AddonRegistry registry;

    public <FACETEDTYPE extends Faceted<?>, FACETTYPE extends Facet<FACETEDTYPE>> FACETTYPE create(FACETEDTYPE origin, Class<FACETTYPE> type) {
        FACETTYPE instance = this.create(type);
        if (!(instance instanceof MutableFacet)) {
            throw new IllegalArgumentException("Facet type [" + type.getName() + "] does not support setting an origin.");
        }
        ((MutableFacet)instance).setFaceted(origin);
        return instance;
    }

    private <FACETEDTYPE extends Faceted<?>, FACETTYPE extends Facet<FACETEDTYPE>> FACETTYPE create(Class<FACETTYPE> type) {
        Assert.notNull(type, (String)"Facet type must not be null.");
        Imported instance = this.getAddonRegistry().getServices(type);
        if (instance.isAmbiguous()) {
            if (!type.isInterface() && !Modifier.isAbstract(type.getModifiers())) {
                Facet facet = (Facet)instance.selectExact(type);
                return (FACETTYPE)facet;
            }
            throw new FacetIsAmbiguousException("Cannot resolve ambiguous facet type [" + type.getName() + "] because multiple matching types were found: \n" + instance);
        }
        if (instance.isUnsatisfied()) {
            throw new FacetNotFoundException("Could not find Facet of type [" + type.getName() + "]");
        }
        return (FACETTYPE)((Facet)instance.get());
    }

    public <FACETEDTYPE extends Faceted<?>, FACETTYPE extends Facet<FACETEDTYPE>> Iterable<FACETTYPE> createFacets(FACETEDTYPE origin, Class<FACETTYPE> type) {
        Iterable<FACETTYPE> facets = this.createFacets(type);
        for (Facet facet : facets) {
            if (facet instanceof MutableFacet) {
                ((MutableFacet)facet).setFaceted(origin);
                continue;
            }
            throw new IllegalArgumentException("Facet type [" + type.getName() + "] does not support setting an origin.");
        }
        return facets;
    }

    private <FACETEDTYPE extends Faceted<?>, FACETTYPE extends Facet<FACETEDTYPE>> Iterable<FACETTYPE> createFacets(Class<FACETTYPE> type) {
        Assert.notNull(type, (String)"Facet type must not be null.");
        Imported instances = this.getAddonRegistry().getServices(type);
        HashSet<Facet> facets = new HashSet<Facet>();
        for (Facet instance : instances) {
            facets.add(instance);
        }
        return facets;
    }

    public <FACETEDTYPE extends Faceted<?>, FACETTYPE extends Facet<FACETEDTYPE>> FACETTYPE install(FACETEDTYPE origin, Class<FACETTYPE> type) throws FacetNotFoundException {
        return this.install(origin, type, null);
    }

    public <FACETEDTYPE extends Faceted<?>, FACETTYPE extends Facet<FACETEDTYPE>> FACETTYPE install(FACETEDTYPE origin, Class<FACETTYPE> type, Predicate<FACETTYPE> filter) throws FacetNotFoundException, IllegalStateException, FacetIsAmbiguousException {
        FACETTYPE facet = this.create(origin, type);
        if (!this.install(origin, facet, filter)) {
            throw new IllegalStateException("Facet type [" + type.getName() + "] could not be installed into [" + origin + "] of type [" + origin.getClass().getName() + "]. You may wish to check for inconsistent origin state as partial installation may have occurred.");
        }
        return facet;
    }

    public <FACETEDTYPE extends Faceted<?>, FACETTYPE extends Facet<FACETEDTYPE>> boolean install(FACETEDTYPE origin, FACETTYPE facet) {
        return this.install(origin, facet, null);
    }

    public <FACETEDTYPE extends Faceted<?>, FACETTYPE extends Facet<FACETEDTYPE>> boolean install(FACETEDTYPE origin, FACETTYPE facet, Predicate<FACETTYPE> filter) throws IllegalArgumentException, IllegalStateException {
        Assert.notNull(origin, (String)"Origin instance must not be null.");
        Assert.notNull(facet, (String)"Facet instance must not be null.");
        LinkedHashSet<Class<FACETTYPE>> seen = new LinkedHashSet<Class<FACETTYPE>>();
        return this.install(seen, origin, facet, filter);
    }

    private <FACETEDTYPE extends Faceted<?>, FACETTYPE extends Facet<FACETEDTYPE>> boolean install(Set<Class<FACETTYPE>> seen, FACETEDTYPE origin, FACETTYPE facet, Predicate<FACETTYPE> filter) {
        if (filter == null) {
            filter = new Predicate<FACETTYPE>(){

                public boolean accept(FACETTYPE type) {
                    return true;
                }
            };
        }
        if (FacetInspector.hasCircularConstraints(facet.getClass())) {
            throw new IllegalStateException("Circular dependencies detected in @" + FacetConstraint.class.getSimpleName() + " annotation located at [" + facet.getClass().getName() + "]");
        }
        seen.add(facet.getClass());
        FACETEDTYPE faceted = origin;
        Assert.isTrue((boolean)(faceted instanceof MutableFaceted), (String)("The given origin [" + origin + "] is not an instance of [" + MutableFaceted.class.getName() + "], and does not support " + Facet.class.getSimpleName() + " installation."));
        if (facet.getFaceted() == null && facet instanceof MutableFacet) {
            ((MutableFacet)facet).setFaceted(origin);
        }
        Assert.isTrue((boolean)origin.equals(facet.getFaceted()), (String)("The given origin [" + origin + "] is not an instance of [" + MutableFaceted.class.getName() + "], and does not support " + Facet.class.getSimpleName() + " installation."));
        this.register(origin, facet);
        Set requiredFacets = FacetInspector.getRequiredFacets(facet.getClass());
        ArrayList<Class> facetsToInstall = new ArrayList<Class>();
        for (Class requirementType : requiredFacets) {
            boolean isSeen = false;
            for (Class<FACETTYPE> seenType : seen) {
                if (!requirementType.isAssignableFrom(seenType)) continue;
                isSeen = true;
                break;
            }
            if (isSeen || origin.hasFacet(requirementType)) continue;
            facetsToInstall.add(requirementType);
        }
        for (Class requirementType : facetsToInstall) {
            FACETTYPE requirement = this.create(origin, requirementType);
            this.install(seen, origin, requirement, (Predicate<FACETTYPE>)filter);
        }
        boolean result = false;
        if (faceted.hasFacet(facet.getClass())) {
            result = true;
        } else if (FacetInspector.isConstraintSatisfied(faceted, (Set)requiredFacets) && filter.accept(facet)) {
            try {
                result = ((MutableFaceted)faceted).install(facet);
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Could not install Facet of type [" + facet.getClass() + "], due to exception: ", e);
                result = false;
            }
        }
        return result;
    }

    public <FACETEDTYPE extends Faceted<?>, FACETTYPE extends Facet<FACETEDTYPE>> FACETTYPE register(FACETEDTYPE origin, Class<FACETTYPE> type) throws FacetNotFoundException {
        FACETTYPE facet = this.create(origin, type);
        if (!this.register(origin, facet)) {
            throw new IllegalStateException("Facet type [" + type.getName() + "] could not be registered into [" + origin + "] of type [" + origin.getClass().getName() + "].");
        }
        return facet;
    }

    public <FACETEDTYPE extends Faceted<?>, FACETTYPE extends Facet<FACETEDTYPE>> boolean register(FACETEDTYPE origin, FACETTYPE facet) throws IllegalArgumentException {
        Assert.notNull(origin, (String)"Origin instance must not be null.");
        Assert.notNull(facet, (String)"Facet instance must not be null.");
        LinkedHashSet<Class<FACETTYPE>> seen = new LinkedHashSet<Class<FACETTYPE>>();
        return this.register(seen, origin, facet);
    }

    private <FACETEDTYPE extends Faceted<?>, FACETTYPE extends Facet<FACETEDTYPE>> boolean register(Set<Class<FACETTYPE>> seen, FACETEDTYPE origin, FACETTYPE facet) {
        Class<?> facetClass = facet.getClass();
        if (FacetInspector.hasCircularConstraints(facetClass)) {
            throw new IllegalStateException("Circular dependencies detected in @" + FacetConstraint.class.getSimpleName() + " annotation located at [" + facetClass.getName() + "]");
        }
        seen.add(facetClass);
        FACETEDTYPE faceted = origin;
        Assert.isTrue((boolean)(faceted instanceof MutableFaceted), (String)("The given origin [" + origin + "] is not an instance of [" + MutableFaceted.class.getName() + "], and does not support " + Facet.class.getSimpleName() + " installation."));
        if (facet.getFaceted() == null && facet instanceof MutableFacet) {
            ((MutableFacet)facet).setFaceted(origin);
        }
        Assert.isTrue((boolean)origin.equals(facet.getFaceted()), (String)("The given origin [" + origin + "] is not an instance of [" + MutableFaceted.class.getName() + "], and does not support " + Facet.class.getSimpleName() + " installation."));
        Set relatedFacets = FacetInspector.getAllRelatedFacets(facetClass);
        Set requiredFacets = FacetInspector.getAllRequiredFacets(facetClass);
        ArrayList<Class> facetsToRegister = new ArrayList<Class>();
        for (Class relatedType : relatedFacets) {
            boolean isSeen = false;
            for (Class<FACETTYPE> seenType : seen) {
                if (!relatedType.isAssignableFrom(seenType)) continue;
                isSeen = true;
                break;
            }
            if (isSeen || origin.hasFacet(relatedType)) continue;
            facetsToRegister.add(relatedType);
        }
        for (Class relatedType : facetsToRegister) {
            Iterable<FACETTYPE> requirements = this.createFacets(origin, relatedType);
            for (Facet requirement : requirements) {
                this.register(seen, origin, requirement);
            }
        }
        boolean result = false;
        if (faceted.hasFacet(facetClass)) {
            result = true;
        } else if (FacetInspector.isConstraintSatisfied(faceted, (Set)requiredFacets)) {
            try {
                result = ((MutableFaceted)faceted).register(facet);
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Could not register Facet of type [" + facetClass + "], due to exception: ", e);
                result = false;
            }
        }
        return result;
    }

    private AddonRegistry getAddonRegistry() {
        if (this.registry == null) {
            Furnace furnace = SimpleContainer.getFurnace((ClassLoader)this.getClass().getClassLoader());
            this.registry = furnace.getAddonRegistry(new AddonRepository[0]);
        }
        return this.registry;
    }
}

