/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log.entry;

import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.ReplicatedDatabaseConfig;
import com.sleepycat.je.log.DbOpReplicationContext;
import com.sleepycat.je.log.LogEntryHeader;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.ReplicationContext;
import com.sleepycat.je.log.entry.DbOperationType;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.NameLN;
import com.sleepycat.je.txn.Txn;
import java.nio.ByteBuffer;

public class NameLNLogEntry
extends LNLogEntry {
    private DbOperationType operationType;
    private DatabaseId truncateOldDbId;
    private ReplicatedDatabaseConfig replicatedCreateConfig;

    public NameLNLogEntry() {
        super((Class<? extends LN>)NameLN.class);
    }

    public NameLNLogEntry(LogEntryType entryType, NameLN nameLN, DatabaseId dbId, byte[] key, long abortLsn, boolean abortKnownDeleted, Txn txn, ReplicationContext repContext) {
        super(entryType, nameLN, dbId, key, abortLsn, abortKnownDeleted, txn);
        ReplicationContext operationContext = repContext;
        this.operationType = repContext.getDbOperationType();
        if (DbOperationType.isWriteConfigType(this.operationType)) {
            this.replicatedCreateConfig = ((DbOpReplicationContext)operationContext).getCreateConfig();
        }
        if (this.operationType == DbOperationType.TRUNCATE) {
            this.truncateOldDbId = ((DbOpReplicationContext)operationContext).getTruncateOldDbId();
        }
    }

    public void readEntry(EnvironmentImpl envImpl, LogEntryHeader header, ByteBuffer entryBuffer) {
        this.readBaseLNEntry(envImpl, header, entryBuffer, false);
        int version = header.getVersion();
        if (version >= 6) {
            this.operationType = DbOperationType.readTypeFromLog(entryBuffer, version);
            if (DbOperationType.isWriteConfigType(this.operationType)) {
                this.replicatedCreateConfig = new ReplicatedDatabaseConfig();
                this.replicatedCreateConfig.readFromLog(entryBuffer, version);
            }
            if (this.operationType == DbOperationType.TRUNCATE) {
                this.truncateOldDbId = new DatabaseId();
                this.truncateOldDbId.readFromLog(entryBuffer, version);
            }
        } else {
            this.operationType = DbOperationType.NONE;
        }
    }

    public StringBuilder dumpEntry(StringBuilder sb, boolean verbose) {
        super.dumpEntry(sb, verbose);
        this.operationType.dumpLog(sb, verbose);
        if (this.replicatedCreateConfig != null) {
            this.replicatedCreateConfig.dumpLog(sb, verbose);
        }
        if (this.truncateOldDbId != null) {
            this.truncateOldDbId.dumpLog(sb, verbose);
        }
        return sb;
    }

    public int getSize() {
        int size = this.getBaseLNEntrySize(false) + this.operationType.getLogSize();
        if (DbOperationType.isWriteConfigType(this.operationType)) {
            size += this.replicatedCreateConfig.getLogSize();
        }
        if (this.operationType == DbOperationType.TRUNCATE) {
            size += this.truncateOldDbId.getLogSize();
        }
        return size;
    }

    public void writeEntry(LogEntryHeader header, ByteBuffer destBuffer) {
        this.writeBaseLNEntry(header, destBuffer, false);
        this.operationType.writeToLog(destBuffer);
        if (DbOperationType.isWriteConfigType(this.operationType)) {
            this.replicatedCreateConfig.writeToLog(destBuffer);
        }
        if (this.operationType == DbOperationType.TRUNCATE) {
            this.truncateOldDbId.writeToLog(destBuffer);
        }
    }

    public boolean logicalEquals(LogEntry other) {
        if (!super.logicalEquals(other)) {
            return false;
        }
        NameLNLogEntry otherEntry = (NameLNLogEntry)other;
        if (!this.operationType.logicalEquals(otherEntry.operationType)) {
            return false;
        }
        if (this.truncateOldDbId != null && !this.truncateOldDbId.logicalEquals(otherEntry.truncateOldDbId)) {
            return false;
        }
        return this.replicatedCreateConfig == null || this.replicatedCreateConfig.logicalEquals(otherEntry.replicatedCreateConfig);
    }

    public DbOperationType getOperationType() {
        return this.operationType;
    }

    public ReplicatedDatabaseConfig getReplicatedCreateConfig() {
        return this.replicatedCreateConfig;
    }

    public DatabaseId getTruncateOldDbId() {
        return this.truncateOldDbId;
    }

    public void dumpRep(StringBuilder sb) {
        super.dumpRep(sb);
        sb.append(" dbop=").append(this.operationType);
    }
}

