/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster;

import com.tinkerpop.rexster.protocol.EngineConfiguration;
import com.tinkerpop.rexster.protocol.EngineController;
import com.tinkerpop.rexster.server.HttpRexsterServer;
import com.tinkerpop.rexster.server.RexProRexsterServer;
import com.tinkerpop.rexster.server.RexsterApplication;
import com.tinkerpop.rexster.server.RexsterCommandLine;
import com.tinkerpop.rexster.server.RexsterProperties;
import com.tinkerpop.rexster.server.RexsterServer;
import com.tinkerpop.rexster.server.RexsterSettings;
import com.tinkerpop.rexster.server.ShutdownManager;
import com.tinkerpop.rexster.server.XmlRexsterApplication;
import com.tinkerpop.rexster.server.metrics.ReporterConfig;
import com.tinkerpop.rexster.util.JuliToLog4jHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.net.BindException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.apache.log4j.PropertyConfigurator;

public class Application {
    private static final org.apache.log4j.Logger logger;
    private final RexsterServer httpServer;
    private final RexsterServer rexproServer;
    private final RexsterApplication rexsterApplication;
    private final RexsterProperties properties;
    private final ReporterConfig reporterConfig;
    private final FileAlterationMonitor configurationMonitor;

    public Application(RexsterProperties properties, FileAlterationObserver rexsterConfigurationObserver) throws Exception {
        rexsterConfigurationObserver.addListener((FileAlterationListener)properties);
        this.configurationMonitor = new FileAlterationMonitor(properties.getConfigCheckInterval().longValue());
        this.configurationMonitor.addObserver(rexsterConfigurationObserver);
        this.properties = properties;
        this.rexsterApplication = new XmlRexsterApplication(this.properties);
        this.reporterConfig = new ReporterConfig(properties, this.rexsterApplication.getMetricRegistry());
        this.httpServer = new HttpRexsterServer(properties);
        this.rexproServer = new RexProRexsterServer(properties, true);
    }

    public void start() throws Exception {
        this.configureScriptEngine();
        this.properties.addListener(new RexsterProperties.RexsterPropertiesListener(){

            @Override
            public void propertiesChanged(XMLConfiguration configuration) {
                Application.this.configureScriptEngine();
            }
        });
        this.httpServer.start(this.rexsterApplication);
        this.rexproServer.start(this.rexsterApplication);
        this.configurationMonitor.start();
        this.startShutdownManager(this.properties);
    }

    private void configureScriptEngine() {
        ArrayList<EngineConfiguration> configuredScriptEngines = new ArrayList<EngineConfiguration>();
        List<HierarchicalConfiguration> configs = this.properties.getScriptEngines();
        for (HierarchicalConfiguration config : configs) {
            configuredScriptEngines.add(new EngineConfiguration(config));
        }
        EngineController.configure(configuredScriptEngines);
    }

    public void stop() {
        try {
            this.configurationMonitor.stop();
        }
        catch (Exception ex) {
            logger.debug((Object)"Error shutting down the configuration monitor");
        }
        try {
            this.httpServer.stop();
        }
        catch (Exception ex) {
            logger.debug((Object)"Error shutting down Rexster Server ignored.", (Throwable)ex);
        }
        try {
            this.rexproServer.stop();
        }
        catch (Exception ex) {
            logger.debug((Object)"Error shutting down RexPro Server ignored.", (Throwable)ex);
        }
        try {
            this.rexsterApplication.stop();
        }
        catch (Exception ex) {
            logger.warn((Object)"Error while shutting down graphs.  All graphs may not have been shutdown cleanly.");
        }
    }

    private void startShutdownManager(RexsterProperties properties) throws Exception {
        ShutdownManager shutdownManager = new ShutdownManager(properties);
        shutdownManager.registerShutdownListener(new ShutdownManager.ShutdownListener(){

            @Override
            public void shutdown() {
                Application.this.stop();
            }
        });
        shutdownManager.start();
        shutdownManager.waitForShutdown();
    }

    public static void main(String[] args) {
        logger.info((Object)".:Welcome to Rexster:.");
        RexsterSettings settings = new RexsterSettings(args);
        Application.initializeDebugLogging(settings);
        RexsterCommandLine line = settings.getCommand();
        if (settings.getPrimeCommand().equals("start")) {
            try {
                new Application(settings.getProperties(), Application.createRexsterConfigurationObserver(settings)).start();
            }
            catch (BindException be) {
                logger.fatal((Object)"Could not start Rexster Server.  A port that Rexster needs is in use.");
            }
            catch (Exception ex) {
                logger.fatal((Object)"The Rexster Server could not be started", (Throwable)ex);
            }
        } else if (settings.getPrimeCommand().equals("version")) {
            logger.info((Object)String.format("Rexster version [%s]", "2.5.0"));
        } else if (settings.getPrimeCommand().equals("stop")) {
            if (line.hasCommandParameters() && line.getCommandParameters().hasOption("wait")) {
                Application.issueControlCommand(line, "sw");
            } else {
                Application.issueControlCommand(line, "s");
            }
        } else if (settings.getPrimeCommand().equals("status")) {
            Application.issueControlCommand(line, "status");
        } else {
            settings.printHelp();
        }
    }

    private static void initializeDebugLogging(RexsterSettings settings) {
        if (settings.isDebug()) {
            for (String l : Collections.list(LogManager.getLogManager().getLoggerNames())) {
                Logger logger = Logger.getLogger(l);
                logger.setLevel(Level.ALL);
                for (Handler handler : logger.getHandlers()) {
                    logger.removeHandler(handler);
                }
                JuliToLog4jHandler handler = new JuliToLog4jHandler();
                handler.setLevel(Level.ALL);
                Logger.getLogger(l).addHandler(handler);
            }
        } else {
            for (String l : Collections.list(LogManager.getLogManager().getLoggerNames())) {
                Logger.getLogger(l).setLevel(Level.OFF);
            }
        }
    }

    private static FileAlterationObserver createRexsterConfigurationObserver(RexsterSettings settings) {
        File rexsterConfigurationFile = settings.getRexsterXmlFile();
        File absolute = new File(rexsterConfigurationFile.getAbsolutePath());
        File rexsterConfigurationDirectory = absolute.getParentFile();
        logger.info((Object)String.format("Rexster is watching [%s] for change.", rexsterConfigurationFile.getAbsolutePath()));
        return new FileAlterationObserver(rexsterConfigurationDirectory, (FileFilter)FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFileFilter.FILE, FileFilterUtils.nameFileFilter((String)rexsterConfigurationFile.getName())}));
    }

    private static int parseInt(String intString, int intDefault) {
        try {
            return Integer.parseInt(intString);
        }
        catch (NumberFormatException nfe) {
            return intDefault;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void issueControlCommand(RexsterCommandLine line, String command) {
        String host = line.getCommandOption("rexsterhost", "127.0.0.1");
        String portString = line.getCommandOption("rexsterport", null);
        int port = Application.parseInt(portString, 8183);
        if (line.hasCommandOption("rexsterport") && !Integer.toString(port).equals(portString)) {
            logger.warn((Object)("The value of the <port> parameter was not a valid value.  Utilizing the default port of " + port + "."));
        }
        Socket shutdownConnection = null;
        try {
            InetAddress hostAddress = InetAddress.getByName(host);
            shutdownConnection = new Socket(hostAddress, port);
            shutdownConnection.setSoTimeout(30000);
            BufferedReader reader = new BufferedReader(new InputStreamReader(shutdownConnection.getInputStream()));
            PrintStream writer = new PrintStream(shutdownConnection.getOutputStream());
            try {
                String theLine;
                writer.println(command);
                writer.flush();
                while ((theLine = reader.readLine()) != null) {
                    System.out.println(theLine);
                }
            }
            finally {
                IOUtils.closeQuietly((Reader)reader);
                IOUtils.closeQuietly((OutputStream)writer);
            }
        }
        catch (SocketTimeoutException ste) {
            logger.warn((Object)"Taking longer than 30 seconds to shutdown Rexster.  Check shutdown status with --status");
        }
        catch (IOException ioe) {
            logger.warn((Object)"Cannot connect to Rexster Server to issue command.  It may not be running.");
        }
        finally {
            try {
                if (shutdownConnection != null) {
                    shutdownConnection.close();
                }
            }
            catch (IOException ioe) {}
        }
    }

    static {
        URL logConfigFileUrl;
        logger = org.apache.log4j.Logger.getLogger(Application.class);
        File logConfigFile = new File("log4j.properties");
        try {
            logConfigFileUrl = logConfigFile.exists() ? logConfigFile.toURI().toURL() : Application.class.getResource("log4j.properties");
        }
        catch (MalformedURLException mue) {
            logConfigFileUrl = Application.class.getResource("log4j.properties");
        }
        PropertyConfigurator.configure((URL)logConfigFileUrl);
    }
}

