/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster.config;

import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.IndexableGraph;
import com.tinkerpop.blueprints.util.wrappers.readonly.ReadOnlyGraph;
import com.tinkerpop.blueprints.util.wrappers.readonly.ReadOnlyIndexableGraph;
import com.tinkerpop.rexster.RexsterApplicationGraph;
import com.tinkerpop.rexster.config.GraphConfiguration;
import com.tinkerpop.rexster.config.GraphConfigurationContext;
import com.tinkerpop.rexster.config.GraphConfigurationException;
import com.tinkerpop.rexster.config.IdGraphConfiguration;
import com.tinkerpop.rexster.config.LinkedDataSailGraphConfiguration;
import com.tinkerpop.rexster.config.MemoryStoreSailGraphConfiguration;
import com.tinkerpop.rexster.config.NativeStoreSailGraphConfiguration;
import com.tinkerpop.rexster.config.Neo4jGraphConfiguration;
import com.tinkerpop.rexster.config.RexsterGraphGraphConfiguration;
import com.tinkerpop.rexster.config.SparkseeGraphConfiguration;
import com.tinkerpop.rexster.config.SparqlRepositorySailGraphConfiguration;
import com.tinkerpop.rexster.config.TinkerGraphGraphConfiguration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.log4j.Logger;

public class GraphConfigurationContainer {
    protected static final Logger logger = Logger.getLogger(GraphConfigurationContainer.class);
    private final Map<String, RexsterApplicationGraph> graphs = new HashMap<String, RexsterApplicationGraph>();
    private final List<HierarchicalConfiguration> failedConfigurations = new ArrayList<HierarchicalConfiguration>();

    public GraphConfigurationContainer(List<HierarchicalConfiguration> configurations) throws GraphConfigurationException {
        if (configurations == null) {
            throw new GraphConfigurationException("No graph configurations");
        }
        for (HierarchicalConfiguration graphConfig : configurations) {
            String graphName = graphConfig.getString("graph-name", "");
            if (graphName.equals("")) {
                logger.warn((Object)("Could not load graph " + graphName + ".  The graph-name element was not set."));
                this.failedConfigurations.add(graphConfig);
                continue;
            }
            if (!this.graphs.containsKey(graphName)) {
                if (graphConfig.getBoolean("graph-enabled", true)) {
                    try {
                        Graph graph = this.getGraphFromConfiguration(graphConfig);
                        RexsterApplicationGraph rag = new RexsterApplicationGraph(graphName, graph, graphConfig);
                        this.graphs.put(rag.getGraphName(), rag);
                        logger.info((Object)("Graph " + graphName + " - " + graph + " loaded"));
                    }
                    catch (GraphConfigurationException gce) {
                        logger.warn((Object)("Could not load graph " + graphName + ". Please check the XML configuration."));
                        logger.warn((Object)gce.getMessage(), (Throwable)gce);
                        if (gce.getCause() != null) {
                            logger.warn((Object)gce.getCause().getMessage(), gce.getCause());
                        }
                        this.failedConfigurations.add(graphConfig);
                    }
                    catch (Exception e) {
                        logger.warn((Object)("Could not load graph " + graphName + "."), (Throwable)e);
                        this.failedConfigurations.add(graphConfig);
                    }
                    continue;
                }
                logger.info((Object)("Graph " + graphName + " - " + " not enabled and not loaded."));
                continue;
            }
            logger.warn((Object)("A graph with the name " + graphName + " was already configured.  Please check the XML configuration."));
            this.failedConfigurations.add(graphConfig);
        }
    }

    public Map<String, RexsterApplicationGraph> getApplicationGraphs() {
        return this.graphs;
    }

    public List<HierarchicalConfiguration> getFailedConfigurations() {
        return this.failedConfigurations;
    }

    private Graph getGraphFromConfiguration(HierarchicalConfiguration graphConfiguration) throws GraphConfigurationException {
        Object graph;
        String graphConfigurationType = graphConfiguration.getString("graph-type");
        boolean isReadOnly = graphConfiguration.getBoolean("graph-read-only", false);
        if (graphConfigurationType.equals("idgraph")) {
            graphConfigurationType = IdGraphConfiguration.class.getName();
        } else if (graphConfigurationType.equals("neo4jgraph")) {
            graphConfigurationType = Neo4jGraphConfiguration.class.getName();
        } else if (graphConfigurationType.equals("tinkergraph")) {
            graphConfigurationType = TinkerGraphGraphConfiguration.class.getName();
        } else if (graphConfigurationType.equals("rexstergraph")) {
            graphConfigurationType = RexsterGraphGraphConfiguration.class.getName();
        } else if (graphConfigurationType.equals("linkeddatasailgraph")) {
            graphConfigurationType = LinkedDataSailGraphConfiguration.class.getName();
        } else if (graphConfigurationType.equals("memorystoresailgraph")) {
            graphConfigurationType = MemoryStoreSailGraphConfiguration.class.getName();
        } else if (graphConfigurationType.equals("nativestoresailgraph")) {
            graphConfigurationType = NativeStoreSailGraphConfiguration.class.getName();
        } else if (graphConfigurationType.equals("sparqlrepositorysailgraph")) {
            graphConfigurationType = SparqlRepositorySailGraphConfiguration.class.getName();
        } else if (graphConfigurationType.equals("sparkseegraph")) {
            graphConfigurationType = SparkseeGraphConfiguration.class.getName();
        }
        try {
            Class<?> clazz = Class.forName(graphConfigurationType, true, Thread.currentThread().getContextClassLoader());
            GraphConfiguration graphConfigInstance = (GraphConfiguration)clazz.newInstance();
            GraphConfigurationContext context = new GraphConfigurationContext((Configuration)graphConfiguration, this.getApplicationGraphs());
            Graph readWriteGraph = graphConfigInstance.configureGraphInstance(context);
            graph = isReadOnly ? (readWriteGraph instanceof IndexableGraph ? new ReadOnlyIndexableGraph((IndexableGraph)readWriteGraph) : new ReadOnlyGraph(readWriteGraph)) : readWriteGraph;
        }
        catch (NoClassDefFoundError err) {
            throw new GraphConfigurationException(String.format("GraphConfiguration [%s] could not instantiate a class [%s].  Ensure that it is in Rexster's path.", graphConfigurationType, err.getMessage()));
        }
        catch (Exception ex) {
            throw new GraphConfigurationException(String.format("GraphConfiguration could not be found or otherwise instantiated: [%s]. Ensure that it is in Rexster's path.", graphConfigurationType), (Throwable)ex);
        }
        return graph;
    }
}

