/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.config;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.jboss.forge.furnace.addons.Addon;
import org.jboss.windup.config.RulePhase;
import org.jboss.windup.config.metadata.RuleMetadata;
import org.jboss.windup.graph.GraphContext;
import org.ocpsoft.rewrite.config.ConfigurationProvider;
import org.ocpsoft.rewrite.context.Context;

public abstract class WindupRuleProvider
implements ConfigurationProvider<GraphContext> {
    public static final RulePhase DEFAULT_PHASE = RulePhase.MIGRATION_RULES;
    @Inject
    private Addon addon;

    public String getID() {
        return this.addon.getId().getName() + "." + this.getClass().getSimpleName();
    }

    public RulePhase getPhase() {
        return DEFAULT_PHASE;
    }

    public void enhanceMetadata(Context context) {
        if (!context.containsKey((Object)RuleMetadata.CATEGORY)) {
            context.put((Object)RuleMetadata.CATEGORY, (Object)"Uncategorized");
        }
        if (!context.containsKey((Object)RuleMetadata.ORIGIN)) {
            context.put((Object)RuleMetadata.ORIGIN, (Object)this.getClass().getName());
        }
        if (!context.containsKey((Object)RuleMetadata.RULE_PROVIDER)) {
            context.put((Object)RuleMetadata.RULE_PROVIDER, (Object)this);
        }
    }

    public List<Class<? extends WindupRuleProvider>> getExecuteAfter() {
        return Collections.emptyList();
    }

    public List<String> getExecuteAfterIDs() {
        return Collections.emptyList();
    }

    public List<Class<? extends WindupRuleProvider>> getExecuteBefore() {
        return Collections.emptyList();
    }

    public List<String> getExecuteBeforeIDs() {
        return Collections.emptyList();
    }

    @SafeVarargs
    protected final List<Class<? extends WindupRuleProvider>> asClassList(Class<? extends WindupRuleProvider> ... deps) {
        return Arrays.asList(deps);
    }

    @SafeVarargs
    protected final List<String> asStringList(String ... deps) {
        return Arrays.asList(deps);
    }

    public int priority() {
        return this.getPhase().getPriority();
    }

    public boolean handles(Object payload) {
        return payload instanceof GraphContext;
    }

    public boolean equals(Object other) {
        boolean result = false;
        if (other instanceof WindupRuleProvider) {
            WindupRuleProvider that = (WindupRuleProvider)other;
            result = this.getID().equals(that.getID());
        }
        return result;
    }

    public int hashCode() {
        return this.getID().hashCode();
    }
}

