/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.groovy.console;

import com.tinkerpop.gremlin.groovy.console.ConsolePlugin;
import org.codehaus.groovy.tools.shell.IO;

public class ConsoleIO {
    private final IO io;
    private final ConsolePlugin plugin;
    private boolean startedWrite = false;

    public ConsoleIO(ConsolePlugin plugin, IO io) {
        this.io = io;
        this.plugin = plugin;
    }

    public void println() {
        this.writeLn("");
    }

    public void println(boolean b) {
        this.writeLn(String.valueOf(b));
    }

    public void println(char c) {
        this.writeLn(String.valueOf(c));
    }

    public void println(int i) {
        this.writeLn(String.valueOf(i));
    }

    public void println(long x) {
        this.writeLn(String.valueOf(x));
    }

    public void println(float f) {
        this.writeLn(String.valueOf(f));
    }

    public void println(double d) {
        this.writeLn(String.valueOf(d));
    }

    public void println(char[] s) {
        this.writeLn(new String(s));
    }

    public void println(String s) {
        this.writeLn(s);
    }

    public void println(Object x) {
        this.writeLn(String.valueOf(x));
    }

    public void print(boolean b) {
        this.write(String.valueOf(b));
    }

    public void print(char c) {
        this.write(String.valueOf(c));
    }

    public void print(int i) {
        this.write(String.valueOf(i));
    }

    public void print(long x) {
        this.write(String.valueOf(x));
    }

    public void print(float f) {
        this.write(String.valueOf(f));
    }

    public void print(double d) {
        this.write(String.valueOf(d));
    }

    public void print(char[] s) {
        this.write(new String(s));
    }

    public void print(String s) {
        this.write(s);
    }

    public void print(Object x) {
        this.write(String.valueOf(x));
    }

    private void write(String s) {
        if (this.startedWrite) {
            this.io.out.print(s);
        } else {
            this.io.out.print(String.format("%s[%s] %s", "==>", this.plugin.getName(), s));
        }
        this.startedWrite = true;
    }

    private void writeLn(String s) {
        this.write(s);
        this.io.out.println();
        this.startedWrite = false;
    }
}

