/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.maven.projects.facets;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.Dependent;
import org.apache.maven.model.Build;
import org.apache.maven.model.Resource;
import org.jboss.forge.addon.facets.AbstractFacet;
import org.jboss.forge.addon.facets.Faceted;
import org.jboss.forge.addon.facets.constraints.FacetConstraint;
import org.jboss.forge.addon.maven.projects.MavenFacet;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.facets.ResourcesFacet;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.resource.ResourceFilter;
import org.jboss.forge.addon.resource.visit.ResourceVisit;
import org.jboss.forge.addon.resource.visit.ResourceVisitor;

@Dependent
@FacetConstraint(value={MavenFacet.class})
public class MavenResourcesFacet
extends AbstractFacet<Project>
implements ResourcesFacet {
    public List<DirectoryResource> getResourceDirectories() {
        ArrayList<DirectoryResource> result = new ArrayList<DirectoryResource>();
        result.add(this.getResourceDirectory());
        result.add(this.getTestResourceDirectory());
        return result;
    }

    public DirectoryResource getResourceDirectory() {
        MavenFacet mavenFacet = (MavenFacet)((Project)this.getFaceted()).getFacet(MavenFacet.class);
        Build build = mavenFacet.getModel().getBuild();
        String resFolderName = build != null && !build.getResources().isEmpty() && ((Resource)build.getResources().get(0)).getDirectory() != null ? ((Resource)build.getResources().get(0)).getDirectory() : "src" + File.separator + "main" + File.separator + "resources";
        DirectoryResource projectRoot = ((Project)this.getFaceted()).getRootDirectory();
        return projectRoot.getChildDirectory(resFolderName);
    }

    public DirectoryResource getTestResourceDirectory() {
        MavenFacet mavenFacet = (MavenFacet)((Project)this.getFaceted()).getFacet(MavenFacet.class);
        Build build = mavenFacet.getModel().getBuild();
        String resFolderName = build != null && !build.getTestResources().isEmpty() && ((Resource)build.getTestResources().get(0)).getDirectory() != null ? ((Resource)build.getTestResources().get(0)).getDirectory() : "src" + File.separator + "test" + File.separator + "resources";
        DirectoryResource projectRoot = ((Project)this.getFaceted()).getRootDirectory();
        return projectRoot.getChildDirectory(resFolderName);
    }

    public void setFaceted(Project origin) {
        super.setFaceted((Faceted)origin);
    }

    public boolean isInstalled() {
        return this.getResourceDirectory().exists();
    }

    public boolean install() {
        if (!this.isInstalled()) {
            for (DirectoryResource folder : this.getResourceDirectories()) {
                folder.mkdirs();
            }
        }
        return true;
    }

    public FileResource<?> getResource(String relativePath) {
        return (FileResource)this.getResourceDirectory().getChild(relativePath);
    }

    public FileResource<?> getTestResource(String relativePath) {
        return (FileResource)this.getTestResourceDirectory().getChild(relativePath);
    }

    public FileResource<?> createResource(char[] bytes, String relativeFilename) {
        FileResource file = (FileResource)this.getResourceDirectory().getChild(relativeFilename);
        file.setContents(bytes);
        return file;
    }

    public FileResource<?> createTestResource(char[] bytes, String relativeFilename) {
        FileResource file = (FileResource)this.getTestResourceDirectory().getChild(relativeFilename);
        file.setContents(bytes);
        return file;
    }

    public void visitResources(ResourceVisitor visitor) {
        new ResourceVisit((org.jboss.forge.addon.resource.Resource)this.getResourceDirectory()).perform(visitor, new ResourceFilter(){

            public boolean accept(org.jboss.forge.addon.resource.Resource<?> resource) {
                return resource instanceof DirectoryResource;
            }
        }, new ResourceFilter(){

            public boolean accept(org.jboss.forge.addon.resource.Resource<?> type) {
                return true;
            }
        });
    }

    public void visitTestResources(ResourceVisitor visitor) {
        new ResourceVisit((org.jboss.forge.addon.resource.Resource)this.getTestResourceDirectory()).perform(visitor, new ResourceFilter(){

            public boolean accept(org.jboss.forge.addon.resource.Resource<?> resource) {
                return resource instanceof DirectoryResource;
            }
        }, new ResourceFilter(){

            public boolean accept(org.jboss.forge.addon.resource.Resource<?> type) {
                return true;
            }
        });
    }
}

