/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster.protocol.msg;

import com.tinkerpop.rexster.client.RexProException;
import com.tinkerpop.rexster.protocol.msg.RexProMessageMeta;

public class RexProMessageMetaField<FieldType> {
    protected String key;
    protected Boolean required;
    protected Object defaultValue;
    protected Class fieldType;

    public RexProMessageMetaField(String key, Boolean required, FieldType defaultValue, Class<FieldType> fieldType) {
        this.key = key;
        this.required = required;
        this.defaultValue = defaultValue;
        this.fieldType = fieldType;
    }

    public RexProMessageMetaField(String key, Boolean required, Class<FieldType> fieldType) {
        this(key, required, null, fieldType);
    }

    public static <T> RexProMessageMetaField<T> define(String key, Boolean required, Class<T> fieldType) {
        return new RexProMessageMetaField<T>(key, required, fieldType);
    }

    public static <T> RexProMessageMetaField<T> define(String key, Boolean required, T defaultValue, Class<T> fieldType) {
        return new RexProMessageMetaField<T>(key, required, defaultValue, fieldType);
    }

    public void validateMeta(RexProMessageMeta meta) throws RexProException {
        if (meta.get(this.key) == null) {
            if (this.defaultValue != null) {
                meta.put(this.key, this.defaultValue);
                return;
            }
            if (this.required.booleanValue()) {
                throw new RexProException("meta value is required for " + this.key);
            }
            return;
        }
        Object val = meta.get(this.key);
        if (!this.fieldType.isInstance(val)) {
            throw new RexProException(this.fieldType.toString() + " type required for " + this.key + ", " + val.getClass().toString() + " found");
        }
    }
}

