/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.xml.condition;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.NamespaceContext;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.jboss.forge.furnace.util.Assert;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.Variables;
import org.jboss.windup.config.condition.GraphCondition;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.reporting.model.FileReferenceModel;
import org.jboss.windup.rules.apps.xml.condition.XmlFileCache;
import org.jboss.windup.rules.apps.xml.condition.XmlFileFrom;
import org.jboss.windup.rules.apps.xml.model.NamespaceMetaModel;
import org.jboss.windup.rules.apps.xml.model.XmlFileModel;
import org.jboss.windup.rules.apps.xml.model.XmlTypeReferenceModel;
import org.jboss.windup.rules.apps.xml.service.XmlFileService;
import org.jboss.windup.util.ExecutionStatistics;
import org.jboss.windup.util.Logging;
import org.jboss.windup.util.exception.WindupException;
import org.jboss.windup.util.xml.NamespaceMapContext;
import org.jboss.windup.util.xml.XmlUtil;
import org.ocpsoft.rewrite.config.ConditionBuilder;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlFile
extends GraphCondition {
    private static final Logger LOG = Logging.get(XmlFile.class);
    protected static final String UNPARSEABLE_XML_CLASSIFICATION = "Unparseable XML File";
    protected static final String UNPARSEABLE_XML_DESCRIPTION = "This file could not be parsed via XPath";
    private static XPathFactory factory = XPathFactory.newInstance();
    private XPath xpathEngine = factory.newXPath();
    private String variable = "default";
    private String xpathString;
    private XPathExpression compiledXPath;
    private Map<String, String> namespaces = new HashMap<String, String>();
    private String fileName;
    private String publicId;
    private String xpathResultMatch;

    public void setXpathResultMatch(String xpathResultMatch) {
        this.xpathResultMatch = xpathResultMatch;
    }

    private XmlFile(String xpath) {
        this.xpathString = xpath;
    }

    XmlFile() {
    }

    public static XmlFile matchesXpath(String xpath) {
        return new XmlFile(xpath);
    }

    public static XmlFile withDTDPublicId(String publicIdRegex) {
        XmlFile xmlFile = new XmlFile();
        xmlFile.publicId = publicIdRegex;
        return xmlFile;
    }

    public ConditionBuilder as(String variable) {
        Assert.notNull((Object)variable, (String)"Variable name must not be null.");
        this.variable = variable;
        return this;
    }

    public XmlFile inFile(String fileName) {
        this.fileName = fileName;
        return this;
    }

    public XmlFile resultMatches(String regex) {
        this.xpathResultMatch = regex;
        return this;
    }

    public static XmlFileFrom from(String fromVariable) {
        return new XmlFileFrom(fromVariable);
    }

    public boolean evaluate(GraphRewrite event, EvaluationContext context) {
        ExecutionStatistics.get().begin("XmlFile.evaluate");
        ArrayList<XmlTypeReferenceModel> resultLocations = new ArrayList<XmlTypeReferenceModel>();
        GraphContext graphContext = event.getGraphContext();
        GraphService xmlResourceService = new GraphService(graphContext, XmlFileModel.class);
        Iterable allXmls = this.getInputVariablesName() == null || this.getInputVariablesName().equals("") ? xmlResourceService.findAll() : Variables.instance((GraphRewrite)event).findVariable(this.getInputVariablesName());
        for (WindupVertexFrame iterated : allXmls) {
            XmlFileService xmlFileService;
            Document document;
            XmlFileModel xml = null;
            if (iterated instanceof FileReferenceModel) {
                xml = (XmlFileModel)((FileReferenceModel)iterated).getFile();
            } else if (iterated instanceof XmlFileModel) {
                xml = (XmlFileModel)iterated;
            } else {
                throw new WindupException("XmlFile was called on the wrong graph type ( " + iterated.toPrettyString() + ")");
            }
            if (!XmlFileCache.matchIsPossible(xml.asVertex().getId(), this.xpathString, this.namespaces) || this.fileName != null && !this.fileName.equals("") && !xml.getFileName().matches(this.fileName) || this.publicId != null && !this.publicId.equals("") && (xml.getDoctype() == null || xml.getDoctype().getPublicId() == null || !xml.getDoctype().getPublicId().matches(this.publicId)) || this.xpathString == null) continue;
            if (this.compiledXPath == null) {
                NamespaceMapContext nsContext = new NamespaceMapContext(this.namespaces);
                this.xpathEngine.setNamespaceContext((NamespaceContext)nsContext);
                try {
                    this.compiledXPath = this.xpathEngine.compile(this.xpathString);
                }
                catch (Exception e) {
                    LOG.severe("Condition: " + (Object)((Object)this) + " failed to run, as the following xpath was uncompilable: " + this.xpathString);
                    return false;
                }
            }
            if ((document = (xmlFileService = new XmlFileService(graphContext)).loadDocumentQuiet(xml)) == null) continue;
            NodeList result = XmlUtil.xpathNodeList((Node)document, (XPathExpression)this.compiledXPath);
            if (result == null || result.getLength() == 0) {
                XmlFileCache.cacheNoResultsFound(xml.asVertex().getId(), this.xpathString, this.namespaces);
                continue;
            }
            for (int i = 0; i < result.getLength(); ++i) {
                Node node = result.item(i);
                if (this.xpathResultMatch != null && !node.toString().matches(this.xpathResultMatch)) continue;
                int lineNumber = (Integer)node.getUserData("ln");
                int columnNumber = (Integer)node.getUserData("cn");
                graphContext = event.getGraphContext();
                GraphService fileLocationService = new GraphService(graphContext, XmlTypeReferenceModel.class);
                XmlTypeReferenceModel fileLocation = (XmlTypeReferenceModel)fileLocationService.create();
                String sourceSnippit = XmlFile.nodeToString(node);
                fileLocation.setSourceSnippit(sourceSnippit);
                fileLocation.setLineNumber(lineNumber);
                fileLocation.setColumnNumber(columnNumber);
                fileLocation.setLength(node.toString().length());
                fileLocation.setFile(xml);
                fileLocation.setXpath(this.xpathString);
                GraphService metaModelService = new GraphService(graphContext, NamespaceMetaModel.class);
                for (Map.Entry<String, String> namespace : this.namespaces.entrySet()) {
                    NamespaceMetaModel metaModel = (NamespaceMetaModel)metaModelService.create();
                    metaModel.setSchemaLocation(namespace.getKey());
                    metaModel.setSchemaLocation(namespace.getValue());
                    metaModel.addXmlResource(xml);
                    fileLocation.addNamespace(metaModel);
                }
                resultLocations.add(fileLocation);
            }
        }
        Variables.instance((GraphRewrite)event).setVariable(this.variable, resultLocations);
        ExecutionStatistics.get().end("XmlFile.evaluate");
        return !resultLocations.isEmpty();
    }

    public XmlFile namespace(String prefix, String url) {
        this.namespaces.put(prefix, url);
        return this;
    }

    public void setXpath(String xpath) {
        this.xpathString = xpath;
        this.compiledXPath = null;
    }

    public void setPublicId(String publicId) {
        this.publicId = publicId;
    }

    private static String nodeToString(Node node) {
        StringWriter sw = new StringWriter();
        try {
            Transformer t = TransformerFactory.newInstance().newTransformer();
            t.setOutputProperty("omit-xml-declaration", "yes");
            t.setOutputProperty("indent", "yes");
            t.transform(new DOMSource(node), new StreamResult(sw));
        }
        catch (TransformerException te) {
            System.out.println("nodeToString Transformer Exception");
        }
        return sw.toString();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("XmlFile");
        if (this.getInputVariablesName() != null) {
            builder.append(".inputVariable(" + this.getInputVariablesName() + ")");
        }
        if (this.xpathString != null) {
            builder.append(".matches(" + this.xpathString + ")");
        }
        if (this.fileName != null) {
            builder.append(".inFile(" + this.fileName + ")");
        }
        if (this.publicId != null) {
            builder.append(".withDTDPublicId(" + this.publicId + ")");
        }
        builder.append(".as(" + this.variable + ")");
        return builder.toString();
    }
}

