/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster.server;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.io.monitor.FileAlterationListenerAdaptor;
import org.apache.log4j.Logger;

public class RexsterProperties
extends FileAlterationListenerAdaptor {
    private static final Logger logger = Logger.getLogger(RexsterProperties.class);
    private XMLConfiguration configuration;
    private final List<RexsterPropertiesListener> listeners = new ArrayList<RexsterPropertiesListener>();
    private final Map<String, RexsterPropertyOverride> overrides = new HashMap<String, RexsterPropertyOverride>();

    public RexsterProperties(XMLConfiguration configuration) {
        this.configuration = configuration;
    }

    public RexsterProperties(String rexsterXmlFileLocation) {
        this.readConfigurationFromFile(rexsterXmlFileLocation);
    }

    private void readConfigurationFromFile(String rexsterXmlFileLocation) {
        String rexsterXmlWithHome;
        this.configuration = new XMLConfiguration();
        String rexsterHome = System.getenv("REXSTER_HOME");
        String string = rexsterXmlWithHome = rexsterHome == null ? rexsterXmlFileLocation : rexsterHome + File.separator + rexsterXmlFileLocation;
        if (rexsterHome != null) {
            logger.info((Object)String.format("REXSTER_HOME is set, trying config at [%s]", rexsterXmlWithHome));
        }
        File rexsterXmlFile = new File(rexsterXmlWithHome);
        try {
            this.configuration.load((Reader)new FileReader(rexsterXmlWithHome));
            logger.info((Object)String.format("Using [%s] as configuration source.", rexsterXmlFile.getAbsolutePath()));
        }
        catch (Exception e) {
            String msg = String.format("Could not load configuration from [%s]", rexsterXmlFile.getAbsolutePath());
            logger.warn((Object)msg);
            throw new RuntimeException(msg);
        }
    }

    public XMLConfiguration getConfiguration() {
        return this.configuration;
    }

    public List<HierarchicalConfiguration> getGraphConfigurations() {
        return this.configuration.configurationsAt("graphs.graph");
    }

    public List<HierarchicalConfiguration> getReporterConfigurations() {
        return this.configuration.configurationsAt("metrics.reporter");
    }

    public Long getConfigCheckInterval() {
        return this.configuration.getLong("config-check-interval", new Long(10000L));
    }

    public Long getRexProSessionMaxIdle() {
        return this.configuration.getLong("rexpro.session-max-idle", new Long(1790000L));
    }

    public Long getRexProSessionCheckInterval() {
        return this.configuration.getLong("rexpro.session-check-interval", new Long(3000000L));
    }

    public Integer getRexsterShutdownPort() {
        return this.configuration.getInteger("shutdown-port", new Integer(8183));
    }

    public String getRexsterShutdownHost() {
        return this.configuration.getString("shutdown-host", "127.0.0.1");
    }

    public List<HierarchicalConfiguration> getScriptEngines() {
        return this.configuration.configurationsAt("script-engines.script-engine");
    }

    public HierarchicalConfiguration getSecuritySettings() {
        try {
            return this.configuration.configurationAt("security.authentication");
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
    }

    public void addListener(RexsterPropertiesListener listener) {
        this.listeners.add(listener);
    }

    public void addOverride(String overrideKey, Object overrideValue) {
        this.configuration.setProperty(overrideKey, overrideValue);
        this.overrides.put(overrideKey, new RexsterPropertyOverride(overrideKey, overrideValue));
    }

    public void removeOverride(String overrideKey) {
        this.overrides.remove(overrideKey);
    }

    public void onFileChange(File file) {
        logger.info((Object)String.format("File settings have changed.  Rexster is reloading [%s]", file.getAbsolutePath()));
        this.readConfigurationFromFile(file.getAbsolutePath());
        for (RexsterPropertyOverride override : this.overrides.values()) {
            this.configuration.setProperty(override.getKeyToOverride(), override.getOverrideValue());
        }
        for (RexsterPropertiesListener listener : this.listeners) {
            listener.propertiesChanged(this.configuration);
        }
    }

    class RexsterPropertyOverride {
        private final String keyToOverride;
        private final Object overrideValue;

        public RexsterPropertyOverride(String keyToOverride, Object overrideValue) {
            this.keyToOverride = keyToOverride;
            this.overrideValue = overrideValue;
        }

        public String getKeyToOverride() {
            return this.keyToOverride;
        }

        public Object getOverrideValue() {
            return this.overrideValue;
        }
    }

    public static interface RexsterPropertiesListener {
        public void propertiesChanged(XMLConfiguration var1);
    }
}

