/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.engine.predicates;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.jboss.forge.furnace.util.Predicate;
import org.jboss.windup.config.WindupRuleProvider;

public class RuleProviderWithDependenciesPredicate
implements Predicate<WindupRuleProvider> {
    private static Logger LOG = Logger.getLogger(RuleProviderWithDependenciesPredicate.class.getName());
    private List<WindupRuleProvider> ruleProviders;

    public RuleProviderWithDependenciesPredicate(Class<? extends WindupRuleProvider> ruleProviderClass) throws InstantiationException, IllegalAccessException {
        this.ruleProviders = Collections.singletonList(ruleProviderClass.newInstance());
    }

    @SafeVarargs
    public RuleProviderWithDependenciesPredicate(Class<? extends WindupRuleProvider> ... ruleProviderClass) throws InstantiationException, IllegalAccessException {
        this.ruleProviders = new ArrayList<WindupRuleProvider>(ruleProviderClass.length);
        for (Class<? extends WindupRuleProvider> clz : ruleProviderClass) {
            this.ruleProviders.add(clz.newInstance());
        }
    }

    public boolean accept(WindupRuleProvider type) {
        for (WindupRuleProvider ruleProvider : this.ruleProviders) {
            int compareTo = type.getPhase().compareTo((Enum)ruleProvider.getPhase());
            if (compareTo < 0) {
                LOG.info("Accepting provider: " + type.getID());
                return true;
            }
            if (compareTo != 0) continue;
            List executeAfter = ruleProvider.getExecuteAfter();
            List executeAfterIDs = ruleProvider.getExecuteAfterIDs();
            if (executeAfter.contains(type.getClass()) || executeAfterIDs.contains(type.getID())) {
                LOG.info("Accepting provider: " + type.getID());
                return true;
            }
            for (Class ruleProviderClassAfter : executeAfter) {
                if (!ruleProviderClassAfter.isAssignableFrom(type.getClass())) continue;
                LOG.info("Accepting provider: " + type.getID());
                return true;
            }
            if (!ruleProvider.getClass().isAssignableFrom(type.getClass())) continue;
            LOG.info("Accepting provider: " + type.getID());
            return true;
        }
        LOG.info("Skipping provider: " + type.getID());
        return false;
    }
}

