/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.maven.projects.facets;

import java.io.File;
import javax.enterprise.context.Dependent;
import org.jboss.forge.addon.facets.AbstractFacet;
import org.jboss.forge.addon.facets.constraints.FacetConstraint;
import org.jboss.forge.addon.maven.projects.MavenFacet;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.templates.facets.TemplateFacet;

@Dependent
@FacetConstraint(value={MavenFacet.class})
public class MavenTemplateFacet
extends AbstractFacet<Project>
implements TemplateFacet {
    public DirectoryResource getRootTemplateDirectory() {
        Project project = (Project)this.getFaceted();
        return project.getRootDirectory().getChildDirectory("src" + File.separator + "main" + File.separator + "templates");
    }

    public boolean isInstalled() {
        Project project = (Project)this.getFaceted();
        return project.hasFacet(MavenFacet.class) && this.getRootTemplateDirectory().exists();
    }

    public boolean install() {
        if (!this.isInstalled()) {
            this.getRootTemplateDirectory().mkdir();
        }
        return true;
    }

    public FileResource<?> getResource(String path) {
        return (FileResource)this.getRootTemplateDirectory().getChild(path);
    }
}

