/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.binary;

import com.thinkaurelius.titan.core.TitanGraph;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.operation.ruleelement.AbstractIterationOperation;
import org.jboss.windup.decompiler.api.DecompilationException;
import org.jboss.windup.decompiler.api.DecompilationListener;
import org.jboss.windup.decompiler.api.DecompilationResult;
import org.jboss.windup.decompiler.procyon.ProcyonConfiguration;
import org.jboss.windup.decompiler.procyon.ProcyonDecompiler;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ArchiveModel;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.ArchiveService;
import org.jboss.windup.graph.service.FileModelService;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.reporting.model.TechnologyTagLevel;
import org.jboss.windup.reporting.service.TechnologyTagService;
import org.jboss.windup.rules.apps.java.model.JavaClassFileModel;
import org.jboss.windup.rules.apps.java.model.JavaSourceFileModel;
import org.jboss.windup.rules.apps.java.model.WarArchiveModel;
import org.jboss.windup.util.ExecutionStatistics;
import org.jboss.windup.util.Logging;
import org.jboss.windup.util.exception.WindupException;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class ProcyonDecompilerOperation
extends AbstractIterationOperation<ArchiveModel> {
    private static Logger LOG = Logging.get(ProcyonDecompilerOperation.class);
    private static final String TECH_TAG = "Decompiled Java File";
    private static final TechnologyTagLevel TECH_TAG_LEVEL = TechnologyTagLevel.INFORMATIONAL;

    public ProcyonDecompilerOperation(String variableName) {
        super(variableName);
    }

    public ProcyonDecompilerOperation() {
    }

    public void perform(GraphRewrite event, EvaluationContext context, ArchiveModel payload) {
        ExecutionStatistics.get().begin("ProcyonDecompilationOperation.perform");
        if (payload.getUnzippedDirectory() != null) {
            ProcyonDecompiler decompiler = new ProcyonDecompiler(new ProcyonConfiguration().setIncludeNested(false));
            int totalCores = Runtime.getRuntime().availableProcessors();
            int threads = totalCores;
            if (threads == 0) {
                threads = 1;
            }
            LOG.info("Decompiling with " + threads + " threads");
            decompiler.setExecutorService(Executors.newFixedThreadPool(threads), threads);
            String archivePath = payload.getFilePath();
            File archive = new File(archivePath);
            File outputDir = new File(payload.getUnzippedDirectory().getFilePath());
            if (payload instanceof WarArchiveModel) {
                outputDir = outputDir.toPath().resolve("WEB-INF").resolve("classes").toFile();
            }
            try {
                AddDecompiledItemsToGraph addDecompiledItemsToGraph = new AddDecompiledItemsToGraph(payload, event.getGraphContext());
                DecompilationResult result = decompiler.decompileArchive(archive, outputDir, (DecompilationListener)addDecompiledItemsToGraph);
                decompiler.close();
            }
            catch (DecompilationException exc) {
                throw new WindupException("Error decompiling archive " + archivePath + " due to: " + exc.getMessage(), (Throwable)exc);
            }
        }
        ExecutionStatistics.get().end("ProcyonDecompilationOperation.perform");
    }

    private class AddDecompiledItemsToGraph
    implements DecompilationListener {
        private final ExecutorService executorService = Executors.newSingleThreadExecutor();
        private final GraphContext context;
        private final Object archiveModelID;
        private final FileModelService fileService;
        private final AtomicInteger atomicInteger = new AtomicInteger(0);

        private AddDecompiledItemsToGraph(ArchiveModel archiveModel, GraphContext context) {
            this.context = context;
            this.archiveModelID = archiveModel.asVertex().getId();
            this.fileService = new FileModelService(context);
        }

        public void decompilationProcessComplete() {
            this.executorService.submit(new Runnable(){

                @Override
                public void run() {
                    LOG.info("Performing final commit for archive vertex: " + AddDecompiledItemsToGraph.this.archiveModelID);
                    ((TitanGraph)AddDecompiledItemsToGraph.this.context.getGraph().getBaseGraph()).commit();
                }
            });
            this.executorService.shutdown();
            try {
                this.executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("Thread pool failed to complete.");
            }
        }

        public synchronized void fileDecompiled(final String inputPath, final String decompiledOutputFile) {
            this.executorService.submit(new Runnable(){

                @Override
                public void run() {
                    ArchiveService archiveService = new ArchiveService(AddDecompiledItemsToGraph.this.context);
                    ArchiveModel archiveModel = (ArchiveModel)archiveService.getById(AddDecompiledItemsToGraph.this.archiveModelID);
                    String[] classFilePathTokens = inputPath.split("\\\\|/");
                    Path classFilePath = Paths.get(archiveModel.getUnzippedDirectory().getFilePath(), new String[0]);
                    for (String pathToken : classFilePathTokens) {
                        classFilePath = classFilePath.resolve(pathToken);
                    }
                    FileModel decompiledFileModel = (FileModel)AddDecompiledItemsToGraph.this.fileService.getUniqueByProperty("filePath", (Object)decompiledOutputFile);
                    if (decompiledFileModel == null) {
                        FileModel parentFileModel = AddDecompiledItemsToGraph.this.fileService.findByPath(Paths.get(decompiledOutputFile, new String[0]).getParent().toString());
                        if (parentFileModel == null) {
                            LinkedList<Path> lineage = new LinkedList<Path>();
                            Path parentPath = Paths.get(decompiledOutputFile, new String[0]).getParent();
                            FileModel existingParentFM = parentFileModel;
                            while (existingParentFM == null) {
                                lineage.add(0, parentPath);
                                parentPath = parentPath.getParent();
                                existingParentFM = AddDecompiledItemsToGraph.this.fileService.findByPath(parentPath.toString());
                            }
                            FileModel currentParent = existingParentFM;
                            for (Path p : lineage) {
                                currentParent = AddDecompiledItemsToGraph.this.fileService.createByFilePath(currentParent, p.toString());
                            }
                            parentFileModel = currentParent;
                        }
                        decompiledFileModel = AddDecompiledItemsToGraph.this.fileService.createByFilePath(parentFileModel, decompiledOutputFile);
                        decompiledFileModel.setParentArchive(archiveModel);
                    }
                    ProjectModel projectModel = archiveModel.getProjectModel();
                    decompiledFileModel.setProjectModel(projectModel);
                    projectModel.addFileModel(decompiledFileModel);
                    if (decompiledOutputFile.endsWith(".java")) {
                        if (!(decompiledFileModel instanceof JavaSourceFileModel)) {
                            decompiledFileModel = (FileModel)new GraphService(AddDecompiledItemsToGraph.this.context, JavaSourceFileModel.class).addTypeToModel((WindupVertexFrame)decompiledFileModel);
                        }
                        JavaSourceFileModel decompiledSourceFileModel = (JavaSourceFileModel)decompiledFileModel;
                        TechnologyTagService techTagService = new TechnologyTagService(AddDecompiledItemsToGraph.this.context);
                        techTagService.addTagToFileModel((FileModel)decompiledSourceFileModel, ProcyonDecompilerOperation.TECH_TAG, TECH_TAG_LEVEL);
                        FileModel classFileModel = (FileModel)AddDecompiledItemsToGraph.this.fileService.getUniqueByProperty("filePath", (Object)classFilePath.toAbsolutePath().toString());
                        if (classFileModel != null && classFileModel instanceof JavaClassFileModel) {
                            JavaClassFileModel classModel = (JavaClassFileModel)classFileModel;
                            classModel.getJavaClass().setDecompiledSource(decompiledSourceFileModel);
                            decompiledSourceFileModel.setPackageName(classModel.getPackageName());
                        } else {
                            throw new WindupException("Failed to find original JavaClassFileModel for decompiled Java file: " + decompiledOutputFile + " at: " + classFilePath.toString());
                        }
                    }
                    archiveModel.addDecompiledFileModel(decompiledFileModel);
                    if (AddDecompiledItemsToGraph.this.atomicInteger.incrementAndGet() % 100 == 0) {
                        LOG.info("Performing periodic commit (" + AddDecompiledItemsToGraph.this.atomicInteger.get() + ") for archive vertex: " + AddDecompiledItemsToGraph.this.archiveModelID);
                        ((TitanGraph)AddDecompiledItemsToGraph.this.context.getGraph().getBaseGraph()).commit();
                    }
                }
            });
        }

        public String toString() {
            return "DecompileWithProcyon";
        }
    }
}

