/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.reporting.rules;

import java.util.ArrayList;
import java.util.List;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.RulePhase;
import org.jboss.windup.config.WindupRuleProvider;
import org.jboss.windup.config.operation.ruleelement.AbstractIterationOperation;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.config.query.QueryBuilderFind;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.model.report.IgnoredFileRegexModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.graph.service.WindupConfigurationService;
import org.jboss.windup.reporting.model.IgnoredFilesReportModel;
import org.jboss.windup.reporting.model.ReportModel;
import org.jboss.windup.reporting.model.TemplateType;
import org.jboss.windup.reporting.service.ReportService;
import org.jboss.windup.rules.apps.java.model.IgnoredFileModel;
import org.jboss.windup.rules.apps.java.model.WindupJavaConfigurationModel;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class CreateJavaIgnoredFilesReportRuleProvider
extends WindupRuleProvider {
    public static final String TITLE = "Ignored Files";
    public static final String TEMPLATE_REPORT = "/reports/templates/ignored_files.ftl";

    public RulePhase getPhase() {
        return RulePhase.REPORT_GENERATION;
    }

    public Configuration getConfiguration(GraphContext context) {
        QueryBuilderFind applicationProjectModelsFound = Query.fromType(WindupJavaConfigurationModel.class);
        AbstractIterationOperation<WindupJavaConfigurationModel> addApplicationReport = new AbstractIterationOperation<WindupJavaConfigurationModel>(){

            public void perform(GraphRewrite event, EvaluationContext context, WindupJavaConfigurationModel payload) {
                WindupConfigurationModel configurationModel = WindupConfigurationService.getConfigurationModel((GraphContext)event.getGraphContext());
                ProjectModel projectModel = configurationModel.getInputPath().getProjectModel();
                CreateJavaIgnoredFilesReportRuleProvider.this.createIgnoredFilesReport(event.getGraphContext(), payload, projectModel);
            }

            public String toString() {
                return "CreateJavaApplicationOverviewReport";
            }
        };
        return ConfigurationBuilder.begin().addRule().when((Condition)applicationProjectModelsFound).perform((Operation)addApplicationReport);
    }

    private IgnoredFilesReportModel createIgnoredFilesReport(GraphContext context, WindupJavaConfigurationModel javaCfg, ProjectModel rootProjectModel) {
        GraphService ignoredFilesService = new GraphService(context, IgnoredFilesReportModel.class);
        IgnoredFilesReportModel ignoredFilesReportModel = (IgnoredFilesReportModel)ignoredFilesService.create();
        ignoredFilesReportModel.setReportPriority(100);
        ignoredFilesReportModel.setReportName(TITLE);
        ignoredFilesReportModel.setMainApplicationReport(Boolean.valueOf(false));
        ignoredFilesReportModel.setDisplayInApplicationReportIndex(Boolean.valueOf(true));
        ignoredFilesReportModel.setProjectModel(rootProjectModel);
        ignoredFilesReportModel.setTemplatePath(TEMPLATE_REPORT);
        ignoredFilesReportModel.setTemplateType(TemplateType.FREEMARKER);
        ignoredFilesReportModel.setDisplayInApplicationList(Boolean.valueOf(false));
        GraphService ignoredFilesModelService = new GraphService(context, IgnoredFileModel.class);
        Iterable allIgnoredFiles = ignoredFilesModelService.findAll();
        ArrayList<IgnoredFileModel> returnIgnoredFiles = new ArrayList<IgnoredFileModel>();
        for (IgnoredFileModel file : allIgnoredFiles) {
            List<String> allProjectPaths = this.getAllFatherProjectPaths(file.getProjectModel());
            if (!allProjectPaths.contains(rootProjectModel.getRootFileModel().getFilePath())) continue;
            returnIgnoredFiles.add(file);
        }
        for (IgnoredFileModel ignored : returnIgnoredFiles) {
            ignoredFilesReportModel.addIgnoredFile((FileModel)ignored);
        }
        for (IgnoredFileRegexModel ignoreRegexModel : javaCfg.getIgnoredFileRegexes()) {
            ignoredFilesReportModel.addFileRegex(ignoreRegexModel);
        }
        ReportService reportService = new ReportService(context);
        reportService.setUniqueFilename((ReportModel)ignoredFilesReportModel, "ignoredfiles_" + rootProjectModel.getName(), "html");
        return ignoredFilesReportModel;
    }

    private List<String> getAllFatherProjectPaths(ProjectModel projectModel) {
        ArrayList<String> paths = new ArrayList<String>();
        paths.add(projectModel.getRootFileModel().getFilePath());
        while (projectModel.getParentProject() != null) {
            projectModel = projectModel.getParentProject();
            paths.add(projectModel.getRootFileModel().getFilePath());
        }
        return paths;
    }
}

