/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.reporting.rules;

import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.RulePhase;
import org.jboss.windup.config.WindupRuleProvider;
import org.jboss.windup.config.operation.ruleelement.AbstractIterationOperation;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.config.query.QueryBuilderFind;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.reporting.model.ApplicationReportModel;
import org.jboss.windup.reporting.model.ReportModel;
import org.jboss.windup.reporting.model.TemplateType;
import org.jboss.windup.reporting.service.ApplicationReportService;
import org.jboss.windup.reporting.service.ReportService;
import org.jboss.windup.util.exception.WindupException;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class CreateJavaNonClassifiedFileReportRuleProvider
extends WindupRuleProvider {
    private static final String TEMPLATE_APPLICATION_REPORT = "/reports/templates/non_classified_files.ftl";

    public RulePhase getPhase() {
        return RulePhase.REPORT_GENERATION;
    }

    public Configuration getConfiguration(GraphContext context) {
        QueryBuilderFind applicationProjectModelsFound = Query.fromType(WindupConfigurationModel.class);
        AbstractIterationOperation<WindupConfigurationModel> addApplicationReport = new AbstractIterationOperation<WindupConfigurationModel>(){

            public void perform(GraphRewrite event, EvaluationContext context, WindupConfigurationModel payload) {
                ProjectModel projectModel = payload.getInputPath().getProjectModel();
                if (projectModel == null) {
                    throw new WindupException("Error, no project found in: " + payload.getInputPath().getFilePath());
                }
                CreateJavaNonClassifiedFileReportRuleProvider.this.createApplicationReport(event.getGraphContext(), projectModel);
            }

            public String toString() {
                return "CreateNonClassifiedFilesApplicationReport";
            }
        };
        return ConfigurationBuilder.begin().addRule().when((Condition)applicationProjectModelsFound).perform((Operation)addApplicationReport);
    }

    private ApplicationReportModel createApplicationReport(GraphContext context, ProjectModel projectModel) {
        ApplicationReportService applicationReportService = new ApplicationReportService(context);
        ApplicationReportModel applicationReportModel = (ApplicationReportModel)applicationReportService.create();
        applicationReportModel.setReportPriority(200);
        applicationReportModel.setDisplayInApplicationReportIndex(Boolean.valueOf(true));
        applicationReportModel.setReportName("Unclassified Files");
        applicationReportModel.setMainApplicationReport(Boolean.valueOf(false));
        applicationReportModel.setProjectModel(projectModel);
        applicationReportModel.setTemplatePath(TEMPLATE_APPLICATION_REPORT);
        applicationReportModel.setTemplateType(TemplateType.FREEMARKER);
        applicationReportModel.setDisplayInApplicationList(Boolean.valueOf(false));
        ReportService reportService = new ReportService(context);
        reportService.setUniqueFilename((ReportModel)applicationReportModel, "nonclassifiedfiles_" + projectModel.getName(), "html");
        return applicationReportModel;
    }
}

