/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.scan.ast;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.rules.apps.java.model.JavaClassModel;
import org.jboss.windup.rules.apps.java.scan.ast.JavaTypeReferenceModel;
import org.jboss.windup.rules.apps.java.scan.ast.TypeInterestFactory;
import org.jboss.windup.rules.apps.java.scan.ast.TypeReferenceLocation;
import org.jboss.windup.rules.apps.java.service.JavaClassService;
import org.jboss.windup.rules.apps.java.service.TypeReferenceService;
import org.jboss.windup.rules.apps.java.service.WindupJavaConfigurationService;
import org.jboss.windup.util.Logging;

public class VariableResolvingASTVisitor
extends ASTVisitor {
    private static final Logger LOG = Logging.get(VariableResolvingASTVisitor.class);
    private final JavaClassService javaClassService;
    private final TypeReferenceService typeRefService;
    private final WindupJavaConfigurationService windupJavaCfgService;
    private CompilationUnit cu;
    private String fqcn;
    private final List<String> wildcardImports = new ArrayList<String>();
    private final Set<String> classNameLookedUp = new HashSet<String>();
    private final Map<String, String> classNameToFQCN = new HashMap<String, String>();
    private final Set<String> names = new HashSet<String>();
    private final Map<String, String> nameInstance = new HashMap<String, String>();
    private FileModel fileModel;

    public VariableResolvingASTVisitor(GraphContext context) {
        this.javaClassService = new JavaClassService(context);
        this.typeRefService = new TypeReferenceService(context);
        this.windupJavaCfgService = new WindupJavaConfigurationService(context);
    }

    public void init(CompilationUnit cu, FileModel fileModel) {
        this.cu = cu;
        this.fileModel = fileModel;
        this.wildcardImports.clear();
        this.classNameLookedUp.clear();
        this.classNameToFQCN.clear();
        this.names.clear();
        this.nameInstance.clear();
        PackageDeclaration packageDeclaration = cu.getPackage();
        String packageName = packageDeclaration == null ? "" : packageDeclaration.getName().getFullyQualifiedName();
        List types = cu.types();
        if (!types.isEmpty()) {
            TypeDeclaration typeDeclaration = (TypeDeclaration)types.get(0);
            String className = typeDeclaration.getName().getFullyQualifiedName();
            this.fqcn = packageName.equals("") ? className : packageName + "." + className;
            if (this.windupJavaCfgService.shouldScanPackage(packageName)) {
                this.typeRefService.createTypeReference(fileModel, TypeReferenceLocation.TYPE, cu.getLineNumber(typeDeclaration.getStartPosition()), cu.getColumnNumber(cu.getStartPosition()), cu.getLength(), this.fqcn);
            }
            this.names.add("this");
            this.nameInstance.put("this", this.fqcn);
        }
    }

    private void processConstructor(ConstructorType interest, int lineNumber, int columnNumber, int length) {
        String text = interest.toString();
        if (TypeInterestFactory.matchesAny(text, TypeReferenceLocation.CONSTRUCTOR_CALL)) {
            JavaTypeReferenceModel typeRef = this.typeRefService.createTypeReference(this.fileModel, TypeReferenceLocation.CONSTRUCTOR_CALL, lineNumber, columnNumber, length, text);
            LOG.finer("Candidate: " + typeRef);
        }
    }

    private void processMethod(MethodType interest, int lineNumber, int columnNumber, int length) {
        String text = interest.toString();
        if (TypeInterestFactory.matchesAny(text, TypeReferenceLocation.METHOD_CALL)) {
            JavaTypeReferenceModel typeRef = this.typeRefService.createTypeReference(this.fileModel, TypeReferenceLocation.METHOD_CALL, lineNumber, columnNumber, length, text);
            LOG.finer("Candidate: " + typeRef);
        }
    }

    private void processImport(String interest, int lineNumber, int columnNumber, int length) {
        String sourceString = interest;
        if (TypeInterestFactory.matchesAny(sourceString, TypeReferenceLocation.IMPORT)) {
            sourceString = this.resolveClassname(sourceString);
            JavaTypeReferenceModel typeRef = this.typeRefService.createTypeReference(this.fileModel, TypeReferenceLocation.IMPORT, lineNumber, columnNumber, length, interest.toString());
            LOG.finer("Candidate: " + typeRef);
        }
    }

    private void processType(Type type, TypeReferenceLocation referenceLocation) {
        if (type == null) {
            return;
        }
        String sourceString = type.toString();
        if (TypeInterestFactory.matchesAny(sourceString = this.resolveClassname(sourceString), referenceLocation)) {
            int lineNumber = this.cu.getLineNumber(type.getStartPosition());
            int columnNumber = this.cu.getColumnNumber(type.getStartPosition());
            int length = type.getLength();
            JavaTypeReferenceModel typeRef = this.typeRefService.createTypeReference(this.fileModel, referenceLocation, lineNumber, columnNumber, length, sourceString);
            LOG.finer("Prefix: " + (Object)((Object)referenceLocation));
            if (type instanceof SimpleType) {
                SimpleType sType = (SimpleType)type;
                LOG.finer("The type name is: " + sType.getName().getFullyQualifiedName() + " and " + sourceString);
            }
            LOG.finer("Candidate: " + typeRef);
        }
    }

    private void processName(Name name, TypeReferenceLocation referenceLocation, int lineNumber, int columnNumber, int length) {
        if (name == null) {
            return;
        }
        String sourceString = this.resolveClassname(name.toString());
        if (TypeInterestFactory.matchesAny(sourceString, referenceLocation)) {
            sourceString = this.resolveClassname(sourceString);
            JavaTypeReferenceModel typeRef = this.typeRefService.createTypeReference(this.fileModel, referenceLocation, lineNumber, columnNumber, length, sourceString);
            LOG.finer("Prefix: " + (Object)((Object)referenceLocation));
            LOG.finer("Candidate: " + typeRef);
        }
    }

    public boolean visit(MethodDeclaration node) {
        List throwsTypes;
        List parameters;
        Type returnType = node.getReturnType2();
        if (returnType != null) {
            this.processType(returnType, TypeReferenceLocation.RETURN_TYPE);
        }
        if ((parameters = node.parameters()) != null) {
            for (SingleVariableDeclaration type : parameters) {
                String typeName = type.getType().toString();
                typeName = this.resolveClassname(typeName);
                this.names.add(type.getName().toString());
                this.nameInstance.put(type.getName().toString(), typeName);
                this.processType(type.getType(), TypeReferenceLocation.METHOD_PARAMETER);
            }
        }
        if ((throwsTypes = node.thrownExceptions()) != null) {
            for (Name name : throwsTypes) {
                this.processName(name, TypeReferenceLocation.THROWS_METHOD_DECLARATION, this.cu.getLineNumber(node.getStartPosition()), this.cu.getColumnNumber(name.getStartPosition()), name.getLength());
            }
        }
        return super.visit(node);
    }

    public boolean visit(InstanceofExpression node) {
        Type type = node.getRightOperand();
        this.processType(type, TypeReferenceLocation.INSTANCE_OF);
        return super.visit(node);
    }

    public boolean visit(ThrowStatement node) {
        if (node.getExpression() instanceof ClassInstanceCreation) {
            ClassInstanceCreation cic = (ClassInstanceCreation)node.getExpression();
            this.processType(cic.getType(), TypeReferenceLocation.THROW_STATEMENT);
        }
        return super.visit(node);
    }

    public boolean visit(CatchClause node) {
        Type catchType = node.getException().getType();
        this.processType(catchType, TypeReferenceLocation.CATCH_EXCEPTION_STATEMENT);
        return super.visit(node);
    }

    public boolean visit(ReturnStatement node) {
        if (node.getExpression() instanceof ClassInstanceCreation) {
            ClassInstanceCreation cic = (ClassInstanceCreation)node.getExpression();
            this.processType(cic.getType(), TypeReferenceLocation.CONSTRUCTOR_CALL);
        }
        return super.visit(node);
    }

    public boolean visit(FieldDeclaration node) {
        for (int i = 0; i < node.fragments().size(); ++i) {
            String nodeType = node.getType().toString();
            nodeType = this.resolveClassname(nodeType);
            VariableDeclarationFragment frag = (VariableDeclarationFragment)node.fragments().get(i);
            frag.resolveBinding();
            this.names.add(frag.getName().getIdentifier());
            this.nameInstance.put(frag.getName().toString(), nodeType.toString());
            this.processType(node.getType(), TypeReferenceLocation.FIELD_DECLARATION);
        }
        return true;
    }

    public boolean visit(MarkerAnnotation node) {
        this.processName(node.getTypeName(), TypeReferenceLocation.ANNOTATION, this.cu.getLineNumber(node.getStartPosition()), this.cu.getColumnNumber(this.cu.getStartPosition()), this.cu.getLength());
        return super.visit(node);
    }

    public boolean visit(NormalAnnotation node) {
        this.processName(node.getTypeName(), TypeReferenceLocation.ANNOTATION, this.cu.getLineNumber(node.getStartPosition()), this.cu.getColumnNumber(node.getStartPosition()), node.getLength());
        return super.visit(node);
    }

    public boolean visit(SingleMemberAnnotation node) {
        this.processName(node.getTypeName(), TypeReferenceLocation.ANNOTATION, this.cu.getLineNumber(node.getStartPosition()), this.cu.getColumnNumber(node.getStartPosition()), node.getLength());
        return super.visit(node);
    }

    public boolean visit(TypeDeclaration node) {
        Object clzInterfaces = node.getStructuralProperty((StructuralPropertyDescriptor)TypeDeclaration.SUPER_INTERFACE_TYPES_PROPERTY);
        Object clzSuperClasses = node.getStructuralProperty((StructuralPropertyDescriptor)TypeDeclaration.SUPERCLASS_TYPE_PROPERTY);
        if (clzInterfaces != null && List.class.isAssignableFrom(clzInterfaces.getClass())) {
            List clzInterfacesList = (List)clzInterfaces;
            for (Object clzInterface : clzInterfacesList) {
                if (clzInterface instanceof SimpleType) {
                    this.processType((Type)((SimpleType)clzInterface), TypeReferenceLocation.IMPLEMENTS_TYPE);
                    continue;
                }
                LOG.finer("" + clzInterface);
            }
        }
        if (clzSuperClasses != null) {
            if (clzSuperClasses instanceof SimpleType) {
                this.processType((Type)((SimpleType)clzSuperClasses), TypeReferenceLocation.EXTENDS_TYPE);
            } else {
                LOG.finer("" + clzSuperClasses);
            }
        }
        return super.visit(node);
    }

    public boolean visit(VariableDeclarationStatement node) {
        for (int i = 0; i < node.fragments().size(); ++i) {
            String nodeType = node.getType().toString();
            nodeType = this.resolveClassname(nodeType);
            VariableDeclarationFragment frag = (VariableDeclarationFragment)node.fragments().get(i);
            this.names.add(frag.getName().getIdentifier());
            this.nameInstance.put(frag.getName().toString(), nodeType.toString());
        }
        this.processType(node.getType(), TypeReferenceLocation.VARIABLE_DECLARATION);
        return super.visit(node);
    }

    public boolean visit(ImportDeclaration node) {
        String name = node.getName().toString();
        if (node.isOnDemand()) {
            this.wildcardImports.add(name);
            Iterable<JavaClassModel> classModels = this.javaClassService.findByJavaPackage(name);
            for (JavaClassModel classModel : classModels) {
                this.processImport(classModel.getQualifiedName(), this.cu.getLineNumber(node.getName().getStartPosition()), this.cu.getColumnNumber(node.getName().getStartPosition()), node.getName().getLength());
            }
        } else {
            String clzName = StringUtils.substringAfterLast((String)name, (String)".");
            this.classNameLookedUp.add(clzName);
            this.classNameToFQCN.put(clzName, name);
            this.processImport(node.getName().toString(), this.cu.getLineNumber(node.getName().getStartPosition()), this.cu.getColumnNumber(node.getName().getStartPosition()), node.getName().getLength());
        }
        return super.visit(node);
    }

    public boolean visit(MethodInvocation node) {
        if (!StringUtils.contains((String)node.toString(), (String)".")) {
            return true;
        }
        String nodeName = StringUtils.removeStart((String)node.toString(), (String)"this.");
        List arguments = node.arguments();
        List<String> resolvedParams = this.methodParameterGuesser(arguments);
        String objRef = StringUtils.substringBefore((String)nodeName, (String)("." + node.getName().toString()));
        if (this.nameInstance.containsKey(objRef)) {
            objRef = this.nameInstance.get(objRef);
        }
        objRef = this.resolveClassname(objRef);
        MethodType methodCall = new MethodType(objRef, node.getName().toString(), resolvedParams);
        this.processMethod(methodCall, this.cu.getLineNumber(node.getName().getStartPosition()), this.cu.getColumnNumber(node.getName().getStartPosition()), node.getName().getLength());
        return super.visit(node);
    }

    public boolean visit(PackageDeclaration node) {
        LOG.finer("Found package: " + node.getName().toString());
        return super.visit(node);
    }

    public boolean visit(ClassInstanceCreation node) {
        String nodeType = node.getType().toString();
        nodeType = this.resolveClassname(nodeType);
        List<String> resolvedParams = this.methodParameterGuesser(node.arguments());
        ConstructorType resolvedConstructor = new ConstructorType(nodeType, resolvedParams);
        this.processConstructor(resolvedConstructor, this.cu.getLineNumber(node.getType().getStartPosition()), this.cu.getColumnNumber(node.getType().getStartPosition()), node.getType().getLength());
        return super.visit(node);
    }

    private List<String> methodParameterGuesser(List<?> arguements) {
        ArrayList<String> resolvedParams = new ArrayList<String>(arguements.size());
        for (Object o : arguements) {
            if (o instanceof SimpleName) {
                String name = this.nameInstance.get(o.toString());
                if (name != null) {
                    resolvedParams.add(name);
                    continue;
                }
                resolvedParams.add("Undefined");
                continue;
            }
            if (o instanceof StringLiteral) {
                resolvedParams.add("java.lang.String");
                continue;
            }
            if (o instanceof FieldAccess) {
                String field = ((FieldAccess)o).getName().toString();
                if (this.names.contains(field)) {
                    resolvedParams.add(this.nameInstance.get(field));
                    continue;
                }
                resolvedParams.add("Undefined");
                continue;
            }
            if (o instanceof CastExpression) {
                String type = ((CastExpression)o).getType().toString();
                type = this.qualifyType(type);
                resolvedParams.add(type);
                continue;
            }
            if (o instanceof MethodInvocation) {
                String on = ((MethodInvocation)o).getName().toString();
                if (StringUtils.equals((String)on, (String)"toString")) {
                    if (((MethodInvocation)o).arguments().size() != 0) continue;
                    resolvedParams.add("java.lang.String");
                    continue;
                }
                resolvedParams.add("Undefined");
                continue;
            }
            if (o instanceof NumberLiteral) {
                if (StringUtils.endsWith((String)o.toString(), (String)"L")) {
                    resolvedParams.add("long");
                    continue;
                }
                if (StringUtils.endsWith((String)o.toString(), (String)"f")) {
                    resolvedParams.add("float");
                    continue;
                }
                if (StringUtils.endsWith((String)o.toString(), (String)"d")) {
                    resolvedParams.add("double");
                    continue;
                }
                resolvedParams.add("int");
                continue;
            }
            if (o instanceof BooleanLiteral) {
                resolvedParams.add("boolean");
                continue;
            }
            if (o instanceof ClassInstanceCreation) {
                String nodeType = ((ClassInstanceCreation)o).getType().toString();
                nodeType = this.resolveClassname(nodeType);
                resolvedParams.add(nodeType);
                continue;
            }
            if (o instanceof CharacterLiteral) {
                resolvedParams.add("char");
                continue;
            }
            if (o instanceof InfixExpression) {
                String expression = o.toString();
                if (StringUtils.contains((String)expression, (String)"\"")) {
                    resolvedParams.add("java.lang.String");
                    continue;
                }
                resolvedParams.add("Undefined");
                continue;
            }
            LOG.finer("Unable to determine type: " + o.getClass() + ReflectionToStringBuilder.toString(o));
            resolvedParams.add("Undefined");
        }
        return resolvedParams;
    }

    private String qualifyType(String objRef) {
        if (this.nameInstance.containsKey(objRef = StringUtils.removeEnd((String)objRef, (String)"[]"))) {
            objRef = this.nameInstance.get(objRef);
        }
        objRef = this.resolveClassname(objRef);
        return objRef;
    }

    private String resolveClassname(String sourceClassname) {
        if (!StringUtils.contains((String)sourceClassname, (String)".")) {
            if (this.classNameLookedUp.contains(sourceClassname)) {
                String qualifiedName = this.classNameToFQCN.get(sourceClassname);
                if (qualifiedName != null) {
                    return qualifiedName;
                }
                return sourceClassname;
            }
            this.classNameLookedUp.add(sourceClassname);
            for (String wildcardImport : this.wildcardImports) {
                String candidateQualifiedName = wildcardImport + "." + sourceClassname;
                Iterable models = this.javaClassService.findAllByProperty("qualifiedName", candidateQualifiedName);
                if (!models.iterator().hasNext()) continue;
                this.classNameToFQCN.put(sourceClassname, candidateQualifiedName);
                return candidateQualifiedName;
            }
            return sourceClassname;
        }
        return sourceClassname;
    }

    public static class ConstructorType {
        private final String qualifiedName;
        private final List<String> qualifiedParameters;

        public ConstructorType(String qualifiedName, List<String> qualifiedParameters) {
            this.qualifiedName = qualifiedName;
            this.qualifiedParameters = qualifiedParameters != null ? qualifiedParameters : new LinkedList<String>();
        }

        public String getQualifiedName() {
            return this.qualifiedName;
        }

        public List<String> getQualifiedParameters() {
            return this.qualifiedParameters;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.qualifiedName);
            builder.append("(");
            int j = this.qualifiedParameters.size();
            for (int i = 0; i < j; ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                String param = this.qualifiedParameters.get(i);
                builder.append(param);
            }
            builder.append(")");
            return builder.toString();
        }
    }

    public static class MethodType {
        private final String qualifiedName;
        private final String methodName;
        private final List<String> qualifiedParameters;

        public MethodType(String qualifiedName, String methodName, List<String> qualifiedParameters) {
            this.qualifiedName = qualifiedName;
            this.methodName = methodName;
            this.qualifiedParameters = qualifiedParameters != null ? qualifiedParameters : new LinkedList<String>();
        }

        public String getMethodName() {
            return this.methodName;
        }

        public String getQualifiedName() {
            return this.qualifiedName;
        }

        public List<String> getQualifiedParameters() {
            return this.qualifiedParameters;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.qualifiedName + "." + this.methodName);
            builder.append("(");
            int j = this.qualifiedParameters.size();
            for (int i = 0; i < j; ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                String param = this.qualifiedParameters.get(i);
                builder.append(param);
            }
            builder.append(")");
            return builder.toString();
        }
    }
}

