/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.scan.provider;

import java.util.List;
import java.util.logging.Logger;
import org.jboss.windup.config.RulePhase;
import org.jboss.windup.config.WindupRuleProvider;
import org.jboss.windup.config.operation.Commit;
import org.jboss.windup.config.operation.IterationProgress;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.config.query.QueryPropertyComparisonType;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.rules.apps.java.binary.DecompileArchivesRuleProvider;
import org.jboss.windup.rules.apps.java.scan.operation.AddClassFileMetadata;
import org.jboss.windup.rules.apps.java.scan.provider.UnzipArchivesToOutputRuleProvider;
import org.jboss.windup.util.Logging;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;

public class IndexClassFilesRuleProvider
extends WindupRuleProvider {
    private static Logger LOG = Logging.get(IndexClassFilesRuleProvider.class);

    public RulePhase getPhase() {
        return RulePhase.INITIAL_ANALYSIS;
    }

    public List<Class<? extends WindupRuleProvider>> getExecuteAfter() {
        return this.asClassList(new Class[]{UnzipArchivesToOutputRuleProvider.class});
    }

    public List<Class<? extends WindupRuleProvider>> getExecuteBefore() {
        return this.asClassList(new Class[]{DecompileArchivesRuleProvider.class});
    }

    public Configuration getConfiguration(GraphContext context) {
        return ConfigurationBuilder.begin().addRule().when((Condition)Query.fromType(FileModel.class).withProperty("isDirectory", (Object)false).withProperty("filePath", QueryPropertyComparisonType.REGEX, (Object)".*\\.class")).perform((Operation)new AddClassFileMetadata().and((Operation)Commit.every((int)10)).and((Operation)IterationProgress.monitoring((String)"Indexed class file: ", (int)1000)));
    }
}

