/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.config.loader;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.forge.furnace.proxy.Proxies;
import org.jboss.windup.config.RulePhase;
import org.jboss.windup.config.WindupRuleProvider;
import org.jboss.windup.config.loader.IncorrectPhaseDependencyException;
import org.jboss.windup.util.exception.WindupMultiException;
import org.jboss.windup.util.exception.WindupMultiStringException;
import org.jgrapht.DirectedGraph;
import org.jgrapht.alg.CycleDetector;
import org.jgrapht.graph.DefaultDirectedWeightedGraph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.traverse.TopologicalOrderIterator;

public class WindupRuleProviderSorter {
    private List<WindupRuleProvider> providers;
    private final IdentityHashMap<Class<? extends WindupRuleProvider>, WindupRuleProvider> classToProviderMap = new IdentityHashMap();
    private final Map<String, WindupRuleProvider> idToProviderMap = new HashMap<String, WindupRuleProvider>();

    private WindupRuleProviderSorter(List<WindupRuleProvider> providers) {
        this.providers = new ArrayList<WindupRuleProvider>(providers);
        this.initializeLookupCaches();
        this.sort();
    }

    public static List<WindupRuleProvider> sort(List<WindupRuleProvider> providers) {
        WindupRuleProviderSorter sorter = new WindupRuleProviderSorter(providers);
        return sorter.getProviders();
    }

    private List<WindupRuleProvider> getProviders() {
        return this.providers;
    }

    private void initializeLookupCaches() {
        for (WindupRuleProvider provider : this.providers) {
            Class<?> unproxiedClass = this.unwrapType(provider.getClass());
            this.classToProviderMap.put(unproxiedClass, provider);
            this.idToProviderMap.put(provider.getID(), provider);
        }
    }

    private void sort() {
        DefaultDirectedWeightedGraph g = new DefaultDirectedWeightedGraph(DefaultEdge.class);
        for (WindupRuleProvider provider : this.providers) {
            g.addVertex((Object)provider);
        }
        this.sortByPhase();
        this.checkForImproperPhaseRelationships();
        this.addProviderRelationships((DefaultDirectedWeightedGraph<WindupRuleProvider, DefaultEdge>)g);
        this.checkForCycles((DefaultDirectedWeightedGraph<WindupRuleProvider, DefaultEdge>)g);
        ArrayList<WindupRuleProvider> result = new ArrayList<WindupRuleProvider>(this.providers.size());
        TopologicalOrderIterator iterator = new TopologicalOrderIterator((DirectedGraph)g);
        while (iterator.hasNext()) {
            WindupRuleProvider provider = (WindupRuleProvider)iterator.next();
            result.add(provider);
        }
        this.providers = Collections.unmodifiableList(result);
    }

    private void sortByPhase() {
        Collections.sort(this.providers, new Comparator<WindupRuleProvider>(){

            @Override
            public int compare(WindupRuleProvider o1, WindupRuleProvider o2) {
                return o1.getPhase().getPriority() - o2.getPhase().getPriority();
            }
        });
    }

    private void addProviderRelationships(DefaultDirectedWeightedGraph<WindupRuleProvider, DefaultEdge> g) {
        ArrayList previousProviders = new ArrayList();
        ArrayList<WindupRuleProvider> currentProviders = new ArrayList<WindupRuleProvider>();
        RulePhase previousPhase = null;
        for (WindupRuleProvider provider : this.providers) {
            WindupRuleProvider otherProvider;
            RulePhase currentPhase = provider.getPhase();
            if (currentPhase != previousPhase && currentPhase != RulePhase.IMPLICIT) {
                previousProviders.clear();
                previousProviders.addAll(currentProviders);
                currentProviders.clear();
            }
            currentProviders.add(provider);
            LinkedList<String> errors = new LinkedList<String>();
            for (Class clz : provider.getExecuteAfter()) {
                otherProvider = this.getByClass(clz);
                if (otherProvider == null) {
                    errors.add("RuleProvider " + provider.getID() + " is specified to execute after class: " + clz.getName() + " but this class could not be found.");
                    continue;
                }
                g.addEdge((Object)otherProvider, (Object)provider);
            }
            for (Class clz : provider.getExecuteBefore()) {
                otherProvider = this.getByClass(clz);
                if (otherProvider == null) {
                    errors.add("RuleProvider " + provider.getID() + " is specified to execute before: " + clz.getName() + " but this class could not be found.");
                    continue;
                }
                g.addEdge((Object)provider, (Object)otherProvider);
            }
            for (String depID : provider.getExecuteAfterIDs()) {
                otherProvider = this.getByID(depID);
                if (otherProvider == null) {
                    errors.add("RuleProvider " + provider.getID() + " is specified to execute after: " + depID + " but this provider could not be found.");
                    continue;
                }
                g.addEdge((Object)otherProvider, (Object)provider);
            }
            for (String depID : provider.getExecuteBeforeIDs()) {
                otherProvider = this.getByID(depID);
                if (otherProvider == null) {
                    errors.add("RuleProvider " + provider.getID() + " is specified to execute before: " + depID + " but this provider could not be found.");
                    continue;
                }
                g.addEdge((Object)provider, (Object)otherProvider);
            }
            if (!errors.isEmpty()) {
                throw new WindupMultiStringException("Some rules to be executed before or after were not found:", errors);
            }
            if (currentPhase != RulePhase.IMPLICIT) {
                for (WindupRuleProvider prevV : previousProviders) {
                    g.addEdge((Object)prevV, (Object)provider);
                }
            }
            previousPhase = currentPhase;
        }
    }

    private void checkForCycles(DefaultDirectedWeightedGraph<WindupRuleProvider, DefaultEdge> g) {
        CycleDetector cycleDetector = new CycleDetector(g);
        if (cycleDetector.detectCycles()) {
            Set cycles = cycleDetector.findCycles();
            StringBuilder errorSB = new StringBuilder();
            for (WindupRuleProvider cycle : cycles) {
                errorSB.append("Found dependency cycle involving: " + cycle.getID() + "\n");
                Set subCycleSet = cycleDetector.findCyclesContainingVertex((Object)cycle);
                for (WindupRuleProvider subCycle : subCycleSet) {
                    errorSB.append("\tSubcycle: " + subCycle.getID() + "\n");
                }
            }
            throw new RuntimeException("Dependency cycles detected: " + errorSB.toString());
        }
    }

    private void checkForImproperPhaseRelationships() {
        for (WindupRuleProvider provider : this.providers) {
            if (provider.getPhase() == null) {
                if (provider.getExecuteAfter() != null && !provider.getExecuteAfter().isEmpty() || provider.getExecuteAfterIDs() != null && !provider.getExecuteAfterIDs().isEmpty() || provider.getExecuteBefore() != null && !provider.getExecuteBefore().isEmpty() || provider.getExecuteBeforeIDs() != null && !provider.getExecuteBeforeIDs().isEmpty()) continue;
                throw new IncorrectPhaseDependencyException("Rule \"" + provider.getID() + "\" uses an implicit phase (phase is null) but does not specify any dependencies.");
            }
            LinkedList<IncorrectPhaseDependencyException> exs = new LinkedList<IncorrectPhaseDependencyException>();
            for (WindupRuleProvider otherProvider : this.getProvidersAfter(provider, true)) {
                if (WindupRuleProviderSorter.phaseRelationshipOk(otherProvider, provider)) continue;
                exs.add(new IncorrectPhaseDependencyException(WindupRuleProviderSorter.formatErrorMessageAfter(provider, otherProvider)));
            }
            for (WindupRuleProvider otherProvider : this.getProvidersBefore(provider, true)) {
                if (WindupRuleProviderSorter.phaseRelationshipOk(provider, otherProvider)) continue;
                exs.add(new IncorrectPhaseDependencyException(WindupRuleProviderSorter.formatErrorMessageBefore(provider, otherProvider)));
            }
            if (exs.isEmpty()) continue;
            throw new WindupMultiException("Some rules have wrong relationships:", exs);
        }
    }

    private List<WindupRuleProvider> getProvidersAfter(WindupRuleProvider provider, boolean removeNulls) {
        LinkedList<WindupRuleProvider> otherProviders = new LinkedList<WindupRuleProvider>(this.getByClasses(provider.getExecuteAfter()));
        otherProviders.addAll(this.getByIDs(provider.getExecuteAfterIDs()));
        if (removeNulls) {
            otherProviders.removeAll(Collections.singleton(null));
        }
        return otherProviders;
    }

    private List<WindupRuleProvider> getProvidersBefore(WindupRuleProvider provider, boolean removeNulls) {
        LinkedList<WindupRuleProvider> otherProviders = new LinkedList<WindupRuleProvider>(this.getByClasses(provider.getExecuteBefore()));
        otherProviders.addAll(this.getByIDs(provider.getExecuteBeforeIDs()));
        if (removeNulls) {
            otherProviders.removeAll(Collections.singleton(null));
        }
        return otherProviders;
    }

    private static String formatErrorMessageAfter(WindupRuleProvider provider, WindupRuleProvider otherProvider) {
        return WindupRuleProvider.class.getSimpleName() + '[' + provider.getID() + "] from phase " + provider.getPhase() + " is to set to execute after\n" + WindupRuleProvider.class.getSimpleName() + '[' + otherProvider.getID() + "] from later phase " + otherProvider.getPhase() + ".\nPossible solution is to specify phase " + otherProvider.getPhase() + " or later for the former.";
    }

    private static String formatErrorMessageBefore(WindupRuleProvider provider, WindupRuleProvider otherProvider) {
        return WindupRuleProvider.class.getSimpleName() + '[' + provider.getID() + "] from phase " + provider.getPhase() + " is to set to execute before\n" + WindupRuleProvider.class.getSimpleName() + '[' + otherProvider.getID() + "] from earlier phase " + otherProvider.getPhase() + ".\nPossible solution is to specify phase " + otherProvider.getPhase() + " or earlier for the former.";
    }

    private static boolean phaseRelationshipOk(WindupRuleProvider before, WindupRuleProvider after) {
        RulePhase beforePhase = before.getPhase();
        RulePhase afterPhase = after.getPhase();
        if (beforePhase == RulePhase.IMPLICIT || afterPhase == RulePhase.IMPLICIT) {
            return true;
        }
        return beforePhase.getPriority() <= afterPhase.getPriority();
    }

    private WindupRuleProvider getByClass(Class<? extends WindupRuleProvider> c) {
        return this.classToProviderMap.get(c);
    }

    private List<WindupRuleProvider> getByClasses(List<Class<? extends WindupRuleProvider>> clss) {
        ArrayList<WindupRuleProvider> rps = new ArrayList<WindupRuleProvider>(clss.size());
        for (Class<? extends WindupRuleProvider> cls : clss) {
            rps.add(this.classToProviderMap.get(cls));
        }
        return rps;
    }

    private WindupRuleProvider getByID(String id) {
        return this.idToProviderMap.get(id);
    }

    private List<WindupRuleProvider> getByIDs(List<String> ids) {
        ArrayList<WindupRuleProvider> rps = new ArrayList<WindupRuleProvider>(ids.size());
        for (String id : ids) {
            rps.add(this.idToProviderMap.get(id));
        }
        return rps;
    }

    private <T> Class<T> unwrapType(Class<T> wrapped) {
        return Proxies.unwrapProxyTypes(wrapped, (ClassLoader[])new ClassLoader[0]);
    }
}

