/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.sesametools;

import java.util.Collection;
import java.util.Iterator;
import org.openrdf.model.Graph;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;

public class RepositoryGraph
implements Graph {
    private static final boolean INFER = false;
    private final RepositoryConnection rc;

    public RepositoryGraph(RepositoryConnection rc) throws RepositoryException {
        this.rc = rc;
    }

    public ValueFactory getValueFactory() {
        return this.rc.getValueFactory();
    }

    public boolean add(Resource s, URI p, Value o, Resource ... c) {
        try {
            this.rc.begin();
            this.rc.add(s, p, o, c);
            this.rc.commit();
            return true;
        }
        catch (RepositoryException e) {
            throw new RepositoryGraphRuntimeException((Throwable)e);
        }
    }

    public Iterator<Statement> match(Resource s, URI p, Value o, Resource ... c) {
        RepositoryResult result = null;
        try {
            result = this.rc.getStatements(s, p, o, false, c);
        }
        catch (RepositoryException e) {
            throw new RepositoryGraphRuntimeException((Throwable)e);
        }
        return new RepositoryResultIterator(result);
    }

    public int size() {
        try {
            return (int)this.rc.size(new Resource[0]);
        }
        catch (RepositoryException e) {
            throw new RepositoryGraphRuntimeException((Throwable)e);
        }
    }

    public boolean isEmpty() {
        return 0 == this.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object o) {
        if (o instanceof Statement) {
            boolean bl;
            Statement st = (Statement)o;
            RepositoryResult result = this.rc.getStatements(st.getSubject(), st.getPredicate(), st.getObject(), false, new Resource[]{st.getContext()});
            try {
                bl = result.hasNext();
            }
            catch (Throwable throwable) {
                try {
                    result.close();
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RepositoryGraphRuntimeException((Throwable)e);
                }
            }
            result.close();
            return bl;
        }
        return false;
    }

    public Iterator<Statement> iterator() {
        return this.match(null, null, null, new Resource[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray() {
        int size = this.size();
        Object[] a = new Object[size];
        if (size > 0) {
            try {
                int i = 0;
                RepositoryResult result = this.rc.getStatements(null, null, null, false, new Resource[0]);
                try {
                    while (result.hasNext()) {
                        a[i] = result.next();
                        ++i;
                    }
                }
                finally {
                    result.close();
                }
            }
            catch (Exception e) {
                throw new RepositoryGraphRuntimeException((Throwable)e);
            }
        }
        return a;
    }

    public <T> T[] toArray(T[] ts) {
        return this.toArray();
    }

    public boolean add(Statement statement) {
        try {
            this.rc.add(statement, new Resource[0]);
        }
        catch (RepositoryException e) {
            throw new RepositoryGraphRuntimeException((Throwable)e);
        }
        return false;
    }

    public boolean remove(Object o) {
        if (o instanceof Statement) {
            Statement st = (Statement)o;
            try {
                this.rc.remove(st.getSubject(), st.getPredicate(), st.getObject(), new Resource[]{st.getContext()});
            }
            catch (RepositoryException e) {
                throw new RepositoryGraphRuntimeException((Throwable)e);
            }
        }
        return false;
    }

    public boolean containsAll(Collection<?> objects) {
        for (Object o : objects) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    public boolean addAll(Collection<? extends Statement> statements) {
        for (Statement statement : statements) {
            this.add(statement);
        }
        return false;
    }

    public boolean removeAll(Collection<?> objects) {
        for (Object o : objects) {
            this.remove(o);
        }
        return false;
    }

    public boolean retainAll(Collection<?> objects) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        try {
            this.rc.clear(new Resource[0]);
        }
        catch (RepositoryException e) {
            throw new RepositoryGraphRuntimeException((Throwable)e);
        }
    }

    public class RepositoryGraphRuntimeException
    extends RuntimeException {
        public RepositoryGraphRuntimeException(Throwable cause) {
            super(cause);
        }
    }

    private class RepositoryResultIterator
    implements Iterator<Statement> {
        private final RepositoryResult result;

        private RepositoryResultIterator(RepositoryResult result) {
            this.result = result;
        }

        @Override
        public boolean hasNext() {
            try {
                return this.result.hasNext();
            }
            catch (RepositoryException e) {
                throw new RepositoryGraphRuntimeException((Throwable)e);
            }
        }

        @Override
        public Statement next() {
            try {
                return (Statement)this.result.next();
            }
            catch (RepositoryException e) {
                throw new RepositoryGraphRuntimeException((Throwable)e);
            }
        }

        @Override
        public void remove() {
            try {
                this.result.remove();
            }
            catch (RepositoryException e) {
                throw new RepositoryGraphRuntimeException((Throwable)e);
            }
        }
    }
}

