/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.impl.addons;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.forge.furnace.addons.Addon;
import org.jboss.forge.furnace.addons.AddonFilter;
import org.jboss.forge.furnace.addons.AddonId;
import org.jboss.forge.furnace.addons.AddonRegistry;
import org.jboss.forge.furnace.addons.AddonStatus;
import org.jboss.forge.furnace.addons.AddonView;
import org.jboss.forge.furnace.impl.addons.AddonLifecycleManager;
import org.jboss.forge.furnace.impl.addons.ImportedImpl;
import org.jboss.forge.furnace.lock.LockManager;
import org.jboss.forge.furnace.lock.LockMode;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.forge.furnace.services.Imported;
import org.jboss.forge.furnace.spi.ServiceRegistry;
import org.jboss.forge.furnace.util.AddonFilters;
import org.jboss.forge.furnace.util.Assert;

public class AddonRegistryImpl
implements AddonRegistry {
    private static final Logger logger = Logger.getLogger(AddonRegistryImpl.class.getName());
    private final LockManager lock;
    private final Set<AddonRepository> repositories;
    private final AddonLifecycleManager manager;
    private final String name;
    private static Map<String, Imported<?>> importedCache = new ConcurrentHashMap();
    private long cacheVersion = -1L;

    public AddonRegistryImpl(LockManager lock, AddonLifecycleManager manager, List<AddonRepository> repositories, String name) {
        Assert.notNull((Object)lock, (String)"LockManager must not be null.");
        Assert.notNull((Object)manager, (String)"Addon lifecycle manager must not be null.");
        Assert.notNull(repositories, (String)"AddonRepository list must not be null.");
        Assert.isTrue((repositories.size() > 0 ? 1 : 0) != 0, (String)"AddonRepository list must not be empty.");
        this.lock = lock;
        this.manager = manager;
        this.repositories = new LinkedHashSet<AddonRepository>(repositories);
        this.name = name;
        logger.log(Level.FINE, "Instantiated AddonRegistryImpl: " + this);
    }

    public void dispose() {
        importedCache.clear();
        this.manager.removeView((AddonView)this);
        this.repositories.clear();
    }

    public Addon getAddon(final AddonId id) {
        Assert.notNull((Object)id, (String)"AddonId must not be null.");
        return (Addon)this.lock.performLocked(LockMode.READ, (Callable)new Callable<Addon>(){

            @Override
            public Addon call() throws Exception {
                return AddonRegistryImpl.this.manager.getAddon((AddonView)AddonRegistryImpl.this, id);
            }
        });
    }

    public Set<Addon> getAddons() {
        return this.getAddons(AddonFilters.all());
    }

    public Set<Addon> getAddons(final AddonFilter filter) {
        return (Set)this.lock.performLocked(LockMode.READ, (Callable)new Callable<Set<Addon>>(){

            @Override
            public Set<Addon> call() throws Exception {
                HashSet<Addon> result = new HashSet<Addon>();
                for (Addon addon : AddonRegistryImpl.this.manager.getAddons((AddonView)AddonRegistryImpl.this)) {
                    if (!filter.accept((Object)addon)) continue;
                    result.add(addon);
                }
                return result;
            }
        });
    }

    public Set<AddonRepository> getRepositories() {
        return Collections.unmodifiableSet(this.repositories);
    }

    public <T> Imported<T> getServices(Class<T> type) {
        String cacheKey;
        Imported<?> imported;
        if (this.getVersion() != this.cacheVersion) {
            this.cacheVersion = this.getVersion();
            importedCache.clear();
        }
        if ((imported = importedCache.get(cacheKey = type.getName() + (type.getClassLoader() == null ? "SystemCL" : type.getClassLoader().toString()))) == null) {
            imported = new ImportedImpl((AddonRegistry)this, this.lock, type);
            importedCache.put(cacheKey, imported);
        }
        return imported;
    }

    public <T> Imported<T> getServices(String typeName) {
        return new ImportedImpl(this, this.lock, typeName);
    }

    public Set<Class<?>> getExportedTypes() {
        return (Set)this.lock.performLocked(LockMode.READ, new Callable<Set<Class<?>>>(){

            @Override
            public Set<Class<?>> call() throws Exception {
                HashSet result = new HashSet();
                for (Addon addon : AddonRegistryImpl.this.getAddons()) {
                    if (!AddonStatus.STARTED.equals((Object)addon.getStatus())) continue;
                    ServiceRegistry serviceRegistry = addon.getServiceRegistry();
                    result.addAll(serviceRegistry.getExportedTypes());
                }
                return result;
            }
        });
    }

    public <T> Set<Class<T>> getExportedTypes(final Class<T> type) {
        return (Set)this.lock.performLocked(LockMode.READ, new Callable<Set<Class<T>>>(){

            @Override
            public Set<Class<T>> call() throws Exception {
                HashSet result = new HashSet();
                for (Addon addon : AddonRegistryImpl.this.getAddons()) {
                    if (!AddonStatus.STARTED.equals((Object)addon.getStatus())) continue;
                    ServiceRegistry serviceRegistry = addon.getServiceRegistry();
                    result.addAll(serviceRegistry.getExportedTypes(type));
                }
                return result;
            }
        });
    }

    public long getVersion() {
        return this.manager.getVersion((AddonView)this);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("REPOSITORIES:").append("\n");
        Iterator<AddonRepository> repositoryIterator = this.getRepositories().iterator();
        while (repositoryIterator.hasNext()) {
            AddonRepository addon = repositoryIterator.next();
            builder.append(addon.toString());
            if (!repositoryIterator.hasNext()) continue;
            builder.append("\n");
        }
        builder.append("\n");
        builder.append("\n");
        builder.append("ADDONS:").append("\n");
        Iterator<Addon> addonIterator = this.getAddons().iterator();
        while (addonIterator.hasNext()) {
            Addon addon = addonIterator.next();
            builder.append(addon.toString());
            if (!addonIterator.hasNext()) continue;
            builder.append("\n");
        }
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.repositories == null ? 0 : this.repositories.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AddonRegistryImpl other = (AddonRegistryImpl)obj;
        return !(this.repositories == null ? other.repositories != null : !this.repositories.equals(other.repositories));
    }

    public String getName() {
        return this.name;
    }
}

