/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.param;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.Constraint;
import org.ocpsoft.rewrite.param.Parameter;
import org.ocpsoft.rewrite.param.ParameterValueStore;
import org.ocpsoft.rewrite.param.Transposition;

public class DefaultParameterValueStore
implements ParameterValueStore,
Iterable<Map.Entry<Parameter<?>, List<String>>> {
    Map<Parameter<?>, List<String>> map = new LinkedHashMap();

    public DefaultParameterValueStore() {
    }

    public DefaultParameterValueStore(DefaultParameterValueStore instance) {
        for (Map.Entry<Parameter<?>, List<String>> entry : instance) {
            ArrayList values = new ArrayList();
            values.addAll(entry.getValue());
            this.map.put(entry.getKey(), values);
        }
    }

    @Override
    public String retrieve(Parameter<?> parameter) {
        List<String> strings = this.map.get(parameter);
        if (strings == null || strings.size() == 0) {
            return null;
        }
        if (strings.size() > 1) {
            throw new IllegalStateException("Parameter [" + parameter.getName() + "] is not a singleton: more than one value exists.");
        }
        return strings.get(0);
    }

    @Override
    public boolean submit(Rewrite event, EvaluationContext context, Parameter<?> param, String value) {
        boolean result = false;
        List<String> strings = this.map.get(param);
        String stored = null;
        if (strings != null) {
            if (strings.size() > 0) {
                stored = strings.get(0);
            }
            if (strings.size() > 1) {
                throw new IllegalStateException("Parameter [" + param.getName() + "] is not a singleton: more than one value exists.");
            }
        }
        if ("*".equals(param.getName())) {
            result = true;
        } else if (stored == value || stored != null && stored.equals(value)) {
            result = true;
        } else if (stored == null) {
            result = this._submit(event, context, param, value);
        }
        return result;
    }

    private boolean _submit(Rewrite event, EvaluationContext context, Parameter<?> param, String value) {
        boolean result = true;
        for (Constraint<String> constraint : param.getConstraints()) {
            if (constraint.isSatisfiedBy(event, context, value)) continue;
            result = false;
        }
        if (result) {
            for (Transposition transposition : param.getTranspositions()) {
                value = transposition.transpose(event, context, value);
            }
            List<String> values = this.map.get(param);
            if (values == null) {
                values = new ArrayList<String>();
                this.map.put(param, values);
            }
            values.add(value);
            result = true;
        }
        return result;
    }

    @Override
    public Iterator<Map.Entry<Parameter<?>, List<String>>> iterator() {
        return this.map.entrySet().iterator();
    }

    public String toString() {
        return this.map.keySet().toString();
    }

    public static ParameterValueStore getInstance(EvaluationContext context) throws IllegalStateException {
        ParameterValueStore valueStore = (ParameterValueStore)context.get(ParameterValueStore.class);
        if (valueStore == null) {
            throw new IllegalStateException("Could not retrieve " + ParameterValueStore.class.getName() + " from " + EvaluationContext.class.getName() + ". Has the " + EvaluationContext.class.getSimpleName() + " been set up properly?");
        }
        return valueStore;
    }
}

