/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster.protocol;

import com.tinkerpop.rexster.protocol.EngineConfiguration;
import com.tinkerpop.rexster.protocol.EngineHolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.log4j.Logger;

public class EngineController {
    private static final Logger logger = Logger.getLogger(EngineController.class);
    public static final int RESET_NEVER = -1;
    private final Map<String, EngineHolder> engines = new ConcurrentHashMap<String, EngineHolder>();
    private static final List<EngineConfiguration> engineConfigurations = new ArrayList<EngineConfiguration>();
    private static final Object lock = new Object();
    private static final AtomicBoolean initializing = new AtomicBoolean(false);
    private static final String ENGINE_NAME_PREFIX = "gremlin-";
    private static EngineController engineController;

    private EngineController() {
        System.setProperty("org.jruby.embed.localvariable.behavior", "persistent");
        this.loadEngines();
    }

    private void loadEngines() {
        initializing.set(true);
        this.engines.clear();
        ScriptEngineManager manager = new ScriptEngineManager();
        for (ScriptEngineFactory factory : manager.getEngineFactories()) {
            logger.info((Object)String.format("ScriptEngineManager has factory for: %s", factory.getLanguageName()));
            EngineConfiguration engineConfiguration = EngineController.findEngineConfiguration(factory.getLanguageName());
            if (engineConfiguration == null) continue;
            logger.info((Object)String.format("Registered ScriptEngine for: %s", factory.getLanguageName()));
            this.engines.put(factory.getLanguageName(), new EngineHolder(factory, engineConfiguration));
        }
        initializing.set(false);
    }

    public static void configure(int resetCount, String initScriptFile) {
        EngineController.configure(resetCount, initScriptFile, (Set<String>)new HashSet<String>(){
            {
                this.add("gremlin-groovy");
            }
        });
    }

    public static void configure(int resetCount, String initScriptFile, Set<String> configuredEngineNames) {
        EngineController.configure(resetCount, initScriptFile, configuredEngineNames, null, null);
    }

    public static void configure(int resetCount, String initScriptFile, Set<String> configuredEngineNames, Set<String> imports, Set<String> staticImports) {
        ArrayList<EngineConfiguration> confs = new ArrayList<EngineConfiguration>();
        for (String configuredEngineName : configuredEngineNames) {
            confs.add(new EngineConfiguration(configuredEngineName, resetCount, initScriptFile, imports, staticImports));
        }
        EngineController.configure(confs);
    }

    public static synchronized void configure(List<EngineConfiguration> configurations) {
        engineController = null;
        engineConfigurations.clear();
        engineConfigurations.addAll(configurations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EngineController getInstance() {
        if (engineController == null) {
            Object object = lock;
            synchronized (object) {
                if (engineController == null) {
                    engineController = new EngineController();
                }
            }
        }
        return engineController;
    }

    public List<String> getAvailableEngineLanguages() {
        ArrayList<String> languages = new ArrayList<String>();
        for (String fullLanguageName : this.engines.keySet()) {
            languages.add(fullLanguageName.substring(fullLanguageName.indexOf(ENGINE_NAME_PREFIX) + ENGINE_NAME_PREFIX.length()));
        }
        return Collections.unmodifiableList(languages);
    }

    public boolean isEngineAvailable(String languageName) {
        boolean available;
        try {
            this.getEngineByLanguageName(languageName);
            available = true;
        }
        catch (ScriptException se) {
            available = false;
        }
        return available;
    }

    public EngineHolder getEngineByLanguageName(String languageName) throws ScriptException {
        while (initializing.get()) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception ex) {
                logger.warn((Object)"An engine was requested while the ScriptEngine was initializing.", (Throwable)ex);
                throw new RuntimeException(ex);
            }
        }
        EngineHolder engine = this.engines.get(ENGINE_NAME_PREFIX + languageName);
        if (engine == null) {
            throw new ScriptException("No engine for the language: " + languageName);
        }
        return engine;
    }

    private static EngineConfiguration findEngineConfiguration(String engineName) {
        for (EngineConfiguration conf : engineConfigurations) {
            if (!conf.getScriptEngineName().equals(engineName)) continue;
            return conf;
        }
        return null;
    }
}

