/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster.protocol.serializer.json.templates.messages;

import com.tinkerpop.rexster.protocol.msg.RexProMessage;
import com.tinkerpop.rexster.protocol.serializer.json.templates.JsonConverter;
import com.tinkerpop.rexster.protocol.serializer.json.templates.JsonTemplate;
import com.tinkerpop.rexster.protocol.serializer.json.templates.MetaTemplate;
import java.util.UUID;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.JsonNodeFactory;

public abstract class RexProMessageTemplate<Message extends RexProMessage>
implements JsonTemplate<Message> {
    protected abstract Message instantiateMessage();

    protected void writeMessageArray(ArrayNode array, Message message) {
        array.add(JsonConverter.toJsonNode(((RexProMessage)message).Session == null ? null : ((RexProMessage)message).sessionAsUUID().toString()));
        array.add(JsonConverter.toJsonNode(((RexProMessage)message).Request == null ? null : ((RexProMessage)message).requestAsUUID().toString()));
        array.add(MetaTemplate.getInstance().serialize(((RexProMessage)message).Meta));
    }

    protected Message readMessageArray(ArrayNode array, Message msg) {
        if (!array.get(0).isNull()) {
            ((RexProMessage)msg).setSessionAsUUID(UUID.fromString(array.get(0).getTextValue()));
        }
        if (!array.get(1).isNull()) {
            ((RexProMessage)msg).setRequestAsUUID(UUID.fromString(array.get(1).getTextValue()));
        }
        ((RexProMessage)msg).Meta = MetaTemplate.getInstance().deserialize(array.get(2));
        return msg;
    }

    @Override
    public JsonNode serialize(Message message) {
        ArrayNode msgArray = new ArrayNode(JsonNodeFactory.instance);
        this.writeMessageArray(msgArray, message);
        return msgArray;
    }

    @Override
    public Message deserialize(JsonNode json) {
        ArrayNode msgArray = (ArrayNode)json;
        return this.readMessageArray(msgArray, this.instantiateMessage());
    }
}

