/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster.protocol.serializer.msgpack.templates.messages;

import com.tinkerpop.rexster.protocol.msg.RexProMessage;
import com.tinkerpop.rexster.protocol.serializer.msgpack.templates.MetaTemplate;
import java.io.IOException;
import org.msgpack.packer.Packer;
import org.msgpack.template.AbstractTemplate;
import org.msgpack.unpacker.Unpacker;

public abstract class RexProMessageTemplate<Message extends RexProMessage>
extends AbstractTemplate<Message> {
    public void write(Packer pk, Message v) throws IOException {
        this.write(pk, v, false);
    }

    protected int messageArraySize() {
        return 3;
    }

    protected abstract Message instantiateMessage();

    protected void writeMessageArray(Packer pk, Message msg) throws IOException {
        pk.write(((RexProMessage)msg).Session);
        pk.write(((RexProMessage)msg).Request);
        MetaTemplate.getInstance().write(pk, ((RexProMessage)msg).Meta);
    }

    public void write(Packer pk, Message v, boolean required) throws IOException {
        pk.writeArrayBegin(this.messageArraySize());
        this.writeMessageArray(pk, v);
        pk.writeArrayEnd();
    }

    public Message read(Unpacker u, Message to) throws IOException {
        return this.read(u, to, false);
    }

    protected Message readMessageArray(Unpacker un, Message msg) throws IOException {
        ((RexProMessage)msg).Session = un.trySkipNil() ? null : un.readByteArray();
        ((RexProMessage)msg).Request = un.trySkipNil() ? null : un.readByteArray();
        ((RexProMessage)msg).Meta = MetaTemplate.getInstance().read(un, null);
        return msg;
    }

    public Message read(Unpacker u, Message to, boolean required) throws IOException {
        u.readArrayBegin();
        Message msg = this.readMessageArray(u, to == null ? this.instantiateMessage() : to);
        u.readArrayEnd();
        return msg;
    }
}

