/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.freemarker;

import freemarker.ext.beans.StringModel;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateModelException;
import java.util.List;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.reporting.freemarker.WindupFreeMarkerMethod;
import org.jboss.windup.reporting.service.ClassificationService;
import org.jboss.windup.reporting.service.InlineHintService;
import org.jboss.windup.util.ExecutionStatistics;

public class GetEffortForProjectMethod
implements WindupFreeMarkerMethod {
    private static final String NAME = "getMigrationEffortPoints";
    private ClassificationService classificationService;
    private InlineHintService inlineHintService;

    public void setContext(GraphRewrite event) {
        this.classificationService = new ClassificationService(event.getGraphContext());
        this.inlineHintService = new InlineHintService(event.getGraphContext());
    }

    public String getMethodName() {
        return NAME;
    }

    public String getDescription() {
        return "Takes a " + ProjectModel.class.getSimpleName() + " as a parameter and returns an int containing the effort estimate for this project.";
    }

    public Object exec(List arguments) throws TemplateModelException {
        ExecutionStatistics.get().begin(NAME);
        if (arguments.size() != 2) {
            throw new TemplateModelException("Error, method expects two arguments (projectModel:ProjectModel, recursive:Boolean)");
        }
        StringModel projectModelArg = (StringModel)arguments.get(0);
        ProjectModel projectModel = (ProjectModel)projectModelArg.getWrappedObject();
        TemplateBooleanModel recursiveBooleanModel = (TemplateBooleanModel)arguments.get(1);
        boolean recursive = recursiveBooleanModel.getAsBoolean();
        Integer result = this.classificationService.getMigrationEffortPoints(projectModel, recursive) + this.inlineHintService.getMigrationEffortPoints(projectModel, recursive);
        ExecutionStatistics.get().end(NAME);
        return result;
    }
}

