/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.ruleexecution;

import freemarker.ext.beans.StringModel;
import freemarker.template.TemplateModelException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import org.apache.commons.lang.SystemUtils;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.reporting.freemarker.WindupFreeMarkerMethod;
import org.jboss.windup.util.ExecutionStatistics;
import org.jboss.windup.util.exception.WindupException;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.config.Rule;
import org.ocpsoft.rewrite.config.RuleBuilder;

public class FormatRule
implements WindupFreeMarkerMethod {
    private static final String NAME = "formatRule";
    private static final int MAX_WIDTH = 80;

    public String getMethodName() {
        return NAME;
    }

    public String getDescription() {
        return "Takes a " + Rule.class.getSimpleName() + " as a paremeter and formats it into multiple rows for display.";
    }

    public Object exec(List arguments) throws TemplateModelException {
        ExecutionStatistics.get().begin(NAME);
        if (arguments.size() != 1) {
            throw new TemplateModelException("Error, method expects one argument (Rule)");
        }
        StringModel stringModelArg = (StringModel)arguments.get(0);
        Rule rule = (Rule)stringModelArg.getWrappedObject();
        ExecutionStatistics.get().end(NAME);
        return "addRule()" + this.serializeRule(rule, 0);
    }

    private String serializeRule(Rule originalRule, int indentLevel) {
        if (!(originalRule instanceof RuleBuilder)) {
            return this.wrap(originalRule.toString(), 80, indentLevel);
        }
        RuleBuilder rule = (RuleBuilder)originalRule;
        StringBuilder result = new StringBuilder();
        for (Condition condition : rule.getConditions()) {
            String conditionToString = this.conditionToString(condition, indentLevel + 1);
            if (conditionToString.isEmpty()) continue;
            result.append("\n");
            this.insertPadding(result, indentLevel + 1);
            result.append(".when(" + this.wrap(conditionToString, 80, indentLevel + 2) + ")");
        }
        for (Operation operation : rule.getOperations()) {
            String operationToString = this.operationToString(operation, indentLevel + 1);
            if (operationToString.isEmpty()) continue;
            result.append("\n");
            this.insertPadding(result, indentLevel + 1);
            result.append(".perform(" + this.wrap(operationToString, 80, indentLevel + 2) + ")");
        }
        if (rule.getId() != null && !rule.getId().isEmpty()) {
            result.append("\n");
            this.insertPadding(result, indentLevel);
            result.append("withId(\"" + rule.getId() + "\")");
        }
        if (rule.priority() != 0) {
            result.append("\n");
            this.insertPadding(result, indentLevel);
            result.append(".withPriority(" + rule.priority() + ")");
        }
        return result.toString();
    }

    protected String conditionToString(Condition condition, int indentLevel) {
        if (condition instanceof RuleBuilder) {
            return this.serializeRule((Rule)((RuleBuilder)condition), indentLevel + 1);
        }
        return condition == null ? "" : this.wrap(condition.toString(), 80, indentLevel + 1);
    }

    protected String operationToString(Operation operation, int indentLevel) {
        if (operation instanceof RuleBuilder) {
            return this.serializeRule((Rule)((RuleBuilder)operation), indentLevel + 1);
        }
        return operation == null ? "" : this.wrap(operation.toString(), 80, indentLevel + 2);
    }

    private String wrap(String str, int wrapLength, int indentLevel) {
        StringBuilder result = new StringBuilder();
        try (StringReader sr = new StringReader(str);){
            BufferedReader br = new BufferedReader(sr);
            String line = null;
            try {
                while ((line = br.readLine()) != null) {
                    result.append(this.wrapLine(line, wrapLength, indentLevel)).append("\n");
                }
            }
            catch (IOException e) {
                throw new WindupException("Error... while reading a StringReader", (Throwable)e);
            }
        }
        return result.toString();
    }

    private String wrapLine(String str, int wrapLength, int indentLevel) {
        if (str == null) {
            return null;
        }
        if (wrapLength < 1) {
            wrapLength = 1;
        }
        int inputLineLength = str.length();
        int offset = 0;
        StringBuilder wrappedLine = new StringBuilder(inputLineLength + 32);
        StringBuilder filler = new StringBuilder();
        while (inputLineLength - offset > wrapLength) {
            if (str.charAt(offset) == '.') {
                ++offset;
                filler.append('.');
                continue;
            }
            int spaceToWrapAt = str.lastIndexOf(46, wrapLength + offset);
            if (spaceToWrapAt >= offset) {
                if (wrappedLine.length() > 0) {
                    this.insertPadding(wrappedLine, indentLevel);
                }
                wrappedLine.append((CharSequence)filler);
                wrappedLine.append(str.substring(offset, spaceToWrapAt));
                wrappedLine.append(SystemUtils.LINE_SEPARATOR);
                offset = spaceToWrapAt;
            } else {
                if (wrappedLine.length() > 0) {
                    this.insertPadding(wrappedLine, indentLevel);
                }
                wrappedLine.append((CharSequence)filler);
                wrappedLine.append(str.substring(offset, wrapLength + offset));
                wrappedLine.append(SystemUtils.LINE_SEPARATOR);
                offset += wrapLength;
            }
            filler.setLength(0);
        }
        if (wrappedLine.length() > 0) {
            this.insertPadding(wrappedLine, indentLevel);
        }
        wrappedLine.append((CharSequence)filler);
        wrappedLine.append(str.substring(offset));
        return wrappedLine.toString();
    }

    private void insertPadding(StringBuilder sb, int indentLevel) {
        for (int i = 0; i < indentLevel; ++i) {
            sb.append("\t");
        }
    }

    public void setContext(GraphRewrite event) {
    }
}

