/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.assembler.ir;

import com.strobel.assembler.ir.Error;
import com.strobel.assembler.ir.Frame;
import com.strobel.assembler.ir.FrameType;
import com.strobel.assembler.ir.FrameValue;
import com.strobel.assembler.ir.FrameValueType;
import com.strobel.assembler.ir.Instruction;
import com.strobel.assembler.ir.InstructionVisitor;
import com.strobel.assembler.ir.OpCode;
import com.strobel.assembler.ir.OpCodeHelpers;
import com.strobel.assembler.ir.attributes.SourceAttribute;
import com.strobel.assembler.metadata.ArrayType;
import com.strobel.assembler.metadata.CoreMetadataFactory;
import com.strobel.assembler.metadata.DynamicCallSite;
import com.strobel.assembler.metadata.FieldReference;
import com.strobel.assembler.metadata.GenericParameter;
import com.strobel.assembler.metadata.IGenericContext;
import com.strobel.assembler.metadata.IGenericInstance;
import com.strobel.assembler.metadata.IGenericParameterProvider;
import com.strobel.assembler.metadata.IMethodSignature;
import com.strobel.assembler.metadata.JvmType;
import com.strobel.assembler.metadata.Label;
import com.strobel.assembler.metadata.MemberReference;
import com.strobel.assembler.metadata.MetadataResolver;
import com.strobel.assembler.metadata.MethodBody;
import com.strobel.assembler.metadata.MethodReference;
import com.strobel.assembler.metadata.MethodVisitor;
import com.strobel.assembler.metadata.ParameterDefinition;
import com.strobel.assembler.metadata.SwitchInfo;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.assembler.metadata.VariableDefinition;
import com.strobel.assembler.metadata.VariableReference;
import com.strobel.assembler.metadata.annotations.CustomAnnotation;
import com.strobel.core.StringUtilities;
import com.strobel.core.VerifyArgument;
import com.strobel.decompiler.InstructionHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class StackMappingVisitor
implements MethodVisitor {
    private final MethodVisitor _innerVisitor;
    private int _maxLocals;
    private List<FrameValue> _stack = new ArrayList<FrameValue>();
    private List<FrameValue> _locals = new ArrayList<FrameValue>();
    private Map<Instruction, TypeReference> _initializations = new IdentityHashMap<Instruction, TypeReference>();

    public StackMappingVisitor() {
        this._innerVisitor = null;
    }

    public StackMappingVisitor(MethodVisitor innerVisitor) {
        this._innerVisitor = innerVisitor;
    }

    public final Frame buildFrame() {
        return new Frame(FrameType.New, this._locals.toArray(new FrameValue[this._locals.size()]), this._stack.toArray(new FrameValue[this._stack.size()]));
    }

    public final int getStackSize() {
        return this._stack == null ? 0 : this._stack.size();
    }

    public final int getLocalCount() {
        return this._locals == null ? 0 : this._locals.size();
    }

    public final FrameValue getStackValue(int offset) {
        VerifyArgument.inRange((int)0, (int)this.getStackSize(), (int)offset, (String)"offset");
        return this._stack.get(this._stack.size() - offset - 1);
    }

    public final FrameValue getLocalValue(int slot) {
        VerifyArgument.inRange((int)0, (int)this.getLocalCount(), (int)slot, (String)"slot");
        return this._locals.get(slot);
    }

    public final Map<Instruction, TypeReference> getInitializations() {
        return Collections.unmodifiableMap(this._initializations);
    }

    public final FrameValue[] getStackSnapshot() {
        if (this._stack == null || this._stack.isEmpty()) {
            return FrameValue.EMPTY_VALUES;
        }
        return this._stack.toArray(new FrameValue[this._stack.size()]);
    }

    public final FrameValue[] getLocalsSnapshot() {
        if (this._locals == null || this._locals.isEmpty()) {
            return FrameValue.EMPTY_VALUES;
        }
        return this._locals.toArray(new FrameValue[this._locals.size()]);
    }

    @Override
    public boolean canVisitBody() {
        return true;
    }

    @Override
    public InstructionVisitor visitBody(MethodBody body) {
        if (this._innerVisitor != null && this._innerVisitor.canVisitBody()) {
            return new InstructionAnalyzer(body, this._innerVisitor.visitBody(body));
        }
        return new InstructionAnalyzer(body);
    }

    @Override
    public void visitEnd() {
        if (this._innerVisitor != null) {
            this._innerVisitor.visitEnd();
        }
    }

    @Override
    public void visitFrame(Frame frame) {
        VerifyArgument.notNull((Object)frame, (String)"frame");
        if (frame.getFrameType() != FrameType.New) {
            throw Error.stackMapperCalledWithUnexpandedFrame(frame.getFrameType());
        }
        if (this._innerVisitor != null) {
            this._innerVisitor.visitFrame(frame);
        }
        if (this._locals != null) {
            this._locals.clear();
            this._stack.clear();
        } else {
            this._locals = new ArrayList<FrameValue>();
            this._stack = new ArrayList<FrameValue>();
            this._initializations = new IdentityHashMap<Instruction, TypeReference>();
        }
        for (FrameValue frameValue : frame.getLocalValues()) {
            this._locals.add(frameValue);
        }
        for (FrameValue frameValue : frame.getStackValues()) {
            this._stack.add(frameValue);
        }
    }

    @Override
    public void visitLineNumber(Instruction instruction, int lineNumber) {
        if (this._innerVisitor != null) {
            this._innerVisitor.visitLineNumber(instruction, lineNumber);
        }
    }

    @Override
    public void visitAttribute(SourceAttribute attribute) {
        if (this._innerVisitor != null) {
            this._innerVisitor.visitAttribute(attribute);
        }
    }

    @Override
    public void visitAnnotation(CustomAnnotation annotation, boolean visible) {
        if (this._innerVisitor != null) {
            this._innerVisitor.visitAnnotation(annotation, visible);
        }
    }

    @Override
    public void visitParameterAnnotation(int parameter, CustomAnnotation annotation, boolean visible) {
        if (this._innerVisitor != null) {
            this._innerVisitor.visitParameterAnnotation(parameter, annotation, visible);
        }
    }

    protected final FrameValue get(int local) {
        this._maxLocals = Math.max(this._maxLocals, local);
        return local < this._locals.size() ? this._locals.get(local) : FrameValue.TOP;
    }

    protected final void set(int local, FrameValue value) {
        this._maxLocals = Math.max(this._maxLocals, local);
        if (this._locals == null) {
            this._locals = new ArrayList<FrameValue>();
            this._stack = new ArrayList<FrameValue>();
            this._initializations = new IdentityHashMap<Instruction, TypeReference>();
        }
        while (local >= this._locals.size()) {
            this._locals.add(FrameValue.TOP);
        }
        this._locals.set(local, value);
        if (value.getType().isDoubleWord()) {
            this._locals.set(local + 1, FrameValue.TOP);
        }
    }

    protected final void set(int local, TypeReference type) {
        this._maxLocals = Math.max(this._maxLocals, local);
        if (this._locals == null) {
            this._locals = new ArrayList<FrameValue>();
            this._stack = new ArrayList<FrameValue>();
            this._initializations = new IdentityHashMap<Instruction, TypeReference>();
        }
        while (local >= this._locals.size()) {
            this._locals.add(FrameValue.TOP);
        }
        if (type == null) {
            this._locals.set(local, FrameValue.TOP);
            return;
        }
        switch (type.getSimpleType()) {
            case Boolean: 
            case Byte: 
            case Character: 
            case Short: 
            case Integer: {
                this._locals.set(local, FrameValue.INTEGER);
                break;
            }
            case Long: {
                this._locals.set(local, FrameValue.LONG);
                if (local + 1 >= this._locals.size()) {
                    this._locals.add(FrameValue.TOP);
                    break;
                }
                this._locals.set(local + 1, FrameValue.TOP);
                break;
            }
            case Float: {
                this._locals.set(local, FrameValue.FLOAT);
                break;
            }
            case Double: {
                this._locals.set(local, FrameValue.DOUBLE);
                if (local + 1 >= this._locals.size()) {
                    this._locals.add(FrameValue.TOP);
                    break;
                }
                this._locals.set(local + 1, FrameValue.TOP);
                break;
            }
            case Object: 
            case Array: 
            case TypeVariable: 
            case Wildcard: {
                this._locals.set(local, FrameValue.makeReference(type));
                break;
            }
            case Void: {
                throw new IllegalArgumentException("Cannot set local to type void.");
            }
        }
    }

    protected final FrameValue pop() {
        return this._stack.remove(this._stack.size() - 1);
    }

    protected final FrameValue peek() {
        return this._stack.get(this._stack.size() - 1);
    }

    protected final void pop(int count) {
        int size = this._stack.size();
        int end = size - count;
        for (int i = size - 1; i >= end; --i) {
            this._stack.remove(i);
        }
    }

    protected final void push(TypeReference type) {
        if (this._stack == null) {
            this._locals = new ArrayList<FrameValue>();
            this._stack = new ArrayList<FrameValue>();
            this._initializations = new IdentityHashMap<Instruction, TypeReference>();
        }
        switch (type.getSimpleType()) {
            case Boolean: 
            case Byte: 
            case Character: 
            case Short: 
            case Integer: {
                this._stack.add(FrameValue.INTEGER);
                break;
            }
            case Long: {
                this._stack.add(FrameValue.LONG);
                this._stack.add(FrameValue.TOP);
                break;
            }
            case Float: {
                this._stack.add(FrameValue.FLOAT);
                break;
            }
            case Double: {
                this._stack.add(FrameValue.DOUBLE);
                this._stack.add(FrameValue.TOP);
                break;
            }
            case Object: 
            case Array: 
            case TypeVariable: 
            case Wildcard: {
                this._stack.add(FrameValue.makeReference(type));
                break;
            }
        }
    }

    protected final void push(FrameValue value) {
        if (this._stack == null) {
            this._locals = new ArrayList<FrameValue>();
            this._stack = new ArrayList<FrameValue>();
            this._initializations = new IdentityHashMap<Instruction, TypeReference>();
        }
        this._stack.add(value);
    }

    protected void initialize(FrameValue value, TypeReference type) {
        int i;
        VerifyArgument.notNull((Object)type, (String)"type");
        Object parameter = value.getParameter();
        FrameValue initializedValue = FrameValue.makeReference(type);
        if (parameter instanceof Instruction) {
            this._initializations.put((Instruction)parameter, type);
        }
        for (i = 0; i < this._stack.size(); ++i) {
            if (this._stack.get(i) != value) continue;
            this._stack.set(i, initializedValue);
        }
        for (i = 0; i < this._locals.size(); ++i) {
            if (this._locals.get(i) != value) continue;
            this._locals.set(i, initializedValue);
        }
    }

    public void pruneLocals() {
        while (!this._locals.isEmpty() && this._locals.get(this._locals.size() - 1) == FrameValue.OUT_OF_SCOPE) {
            this._locals.remove(this._locals.size() - 1);
        }
        for (int i = 0; i < this._locals.size(); ++i) {
            if (this._locals.get(i) != FrameValue.OUT_OF_SCOPE) continue;
            this._locals.set(i, FrameValue.TOP);
        }
    }

    private final class InstructionAnalyzer
    implements InstructionVisitor {
        private final InstructionVisitor _innerVisitor;
        private final MethodBody _body;
        private final CoreMetadataFactory _factory;
        private boolean _afterExecute;
        private final Stack<FrameValue> _temp = new Stack();

        private InstructionAnalyzer(MethodBody body) {
            this(body, (InstructionVisitor)null);
        }

        private InstructionAnalyzer(MethodBody body, InstructionVisitor innerVisitor) {
            this._body = (MethodBody)((Object)VerifyArgument.notNull((Object)((Object)body), (String)"body"));
            this._innerVisitor = innerVisitor;
            if (body.getMethod().isConstructor()) {
                StackMappingVisitor.this.set(0, FrameValue.UNINITIALIZED_THIS);
            }
            this._factory = CoreMetadataFactory.make(this._body.getMethod().getDeclaringType(), (IGenericContext)this._body.getMethod());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visit(Instruction instruction) {
            if (this._innerVisitor != null) {
                this._innerVisitor.visit(instruction);
            }
            instruction.accept(this);
            this.execute(instruction);
            this._afterExecute = true;
            try {
                instruction.accept(this);
            }
            finally {
                this._afterExecute = false;
            }
        }

        @Override
        public void visit(OpCode code) {
            if (this._afterExecute) {
                if (code.isStore()) {
                    FrameValue value;
                    FrameValue frameValue = value = this._temp.isEmpty() ? StackMappingVisitor.this.pop() : this._temp.pop();
                    if (code.getStackChange() == -2) {
                        FrameValue doubleOrLong = this._temp.isEmpty() ? StackMappingVisitor.this.pop() : this._temp.pop();
                        StackMappingVisitor.this.set(OpCodeHelpers.getLoadStoreMacroArgumentIndex(code), doubleOrLong);
                        StackMappingVisitor.this.set(OpCodeHelpers.getLoadStoreMacroArgumentIndex(code) + 1, value);
                    } else {
                        StackMappingVisitor.this.set(OpCodeHelpers.getLoadStoreMacroArgumentIndex(code), value);
                    }
                }
            } else if (code.isLoad()) {
                FrameValue value = StackMappingVisitor.this.get(OpCodeHelpers.getLoadStoreMacroArgumentIndex(code));
                StackMappingVisitor.this.push(value);
                if (value.getType().isDoubleWord()) {
                    StackMappingVisitor.this.push(StackMappingVisitor.this.get(OpCodeHelpers.getLoadStoreMacroArgumentIndex(code) + 1));
                }
            }
        }

        @Override
        public void visitConstant(OpCode code, TypeReference value) {
        }

        @Override
        public void visitConstant(OpCode code, int value) {
        }

        @Override
        public void visitConstant(OpCode code, long value) {
        }

        @Override
        public void visitConstant(OpCode code, float value) {
        }

        @Override
        public void visitConstant(OpCode code, double value) {
        }

        @Override
        public void visitConstant(OpCode code, String value) {
        }

        @Override
        public void visitBranch(OpCode code, Instruction target) {
        }

        @Override
        public void visitVariable(OpCode code, VariableReference variable) {
            if (this._afterExecute) {
                if (code.isStore()) {
                    FrameValue value;
                    FrameValue frameValue = value = this._temp.isEmpty() ? StackMappingVisitor.this.pop() : this._temp.pop();
                    if (code.getStackChange() == -2) {
                        FrameValue doubleOrLong = this._temp.isEmpty() ? StackMappingVisitor.this.pop() : this._temp.pop();
                        StackMappingVisitor.this.set(variable.getSlot(), doubleOrLong);
                        StackMappingVisitor.this.set(variable.getSlot() + 1, value);
                    } else {
                        StackMappingVisitor.this.set(variable.getSlot(), value);
                    }
                }
            } else if (code.isLoad()) {
                FrameValue value = StackMappingVisitor.this.get(variable.getSlot());
                StackMappingVisitor.this.push(value);
                if (code.getStackChange() == 2) {
                    StackMappingVisitor.this.push(StackMappingVisitor.this.get(variable.getSlot() + 1));
                }
            }
        }

        @Override
        public void visitVariable(OpCode code, VariableReference variable, int operand) {
        }

        @Override
        public void visitType(OpCode code, TypeReference type) {
        }

        @Override
        public void visitMethod(OpCode code, MethodReference method) {
        }

        @Override
        public void visitDynamicCallSite(OpCode opCode, DynamicCallSite callSite) {
        }

        @Override
        public void visitField(OpCode code, FieldReference field) {
        }

        @Override
        public void visitLabel(Label label) {
        }

        @Override
        public void visitSwitch(OpCode code, SwitchInfo switchInfo) {
        }

        @Override
        public void visitEnd() {
        }

        private void execute(Instruction instruction) {
            OpCode code;
            block105: {
                code = instruction.getOpCode();
                this._temp.clear();
                if (code.isLoad() || code.isStore()) {
                    return;
                }
                block0 : switch (code.getStackBehaviorPop()) {
                    case Pop0: {
                        break;
                    }
                    case Pop1: {
                        this._temp.push(StackMappingVisitor.this.pop());
                        break;
                    }
                    case Pop2: 
                    case Pop1_Pop1: {
                        this._temp.push(StackMappingVisitor.this.pop());
                        this._temp.push(StackMappingVisitor.this.pop());
                        break;
                    }
                    case Pop1_Pop2: {
                        this._temp.push(StackMappingVisitor.this.pop());
                        this._temp.push(StackMappingVisitor.this.pop());
                        this._temp.push(StackMappingVisitor.this.pop());
                        break;
                    }
                    case Pop1_PopA: {
                        this._temp.push(StackMappingVisitor.this.pop());
                        this._temp.push(StackMappingVisitor.this.pop());
                        break;
                    }
                    case Pop2_Pop1: {
                        this._temp.push(StackMappingVisitor.this.pop());
                        this._temp.push(StackMappingVisitor.this.pop());
                        this._temp.push(StackMappingVisitor.this.pop());
                        break;
                    }
                    case Pop2_Pop2: {
                        this._temp.push(StackMappingVisitor.this.pop());
                        this._temp.push(StackMappingVisitor.this.pop());
                        this._temp.push(StackMappingVisitor.this.pop());
                        this._temp.push(StackMappingVisitor.this.pop());
                        break;
                    }
                    case PopI4: {
                        this._temp.push(StackMappingVisitor.this.pop());
                        break;
                    }
                    case PopI8: {
                        this._temp.push(StackMappingVisitor.this.pop());
                        this._temp.push(StackMappingVisitor.this.pop());
                        break;
                    }
                    case PopR4: {
                        this._temp.push(StackMappingVisitor.this.pop());
                        break;
                    }
                    case PopR8: {
                        this._temp.push(StackMappingVisitor.this.pop());
                        this._temp.push(StackMappingVisitor.this.pop());
                        break;
                    }
                    case PopA: {
                        this._temp.push(StackMappingVisitor.this.pop());
                        break;
                    }
                    case PopI4_PopI4: {
                        this._temp.push(StackMappingVisitor.this.pop());
                        this._temp.push(StackMappingVisitor.this.pop());
                        break;
                    }
                    case PopI4_PopI8: {
                        this._temp.push(StackMappingVisitor.this.pop());
                        this._temp.push(StackMappingVisitor.this.pop());
                        this._temp.push(StackMappingVisitor.this.pop());
                        break;
                    }
                    case PopI8_PopI8: {
                        this._temp.push(StackMappingVisitor.this.pop());
                        this._temp.push(StackMappingVisitor.this.pop());
                        this._temp.push(StackMappingVisitor.this.pop());
                        this._temp.push(StackMappingVisitor.this.pop());
                        break;
                    }
                    case PopR4_PopR4: {
                        this._temp.push(StackMappingVisitor.this.pop());
                        this._temp.push(StackMappingVisitor.this.pop());
                        break;
                    }
                    case PopR8_PopR8: {
                        this._temp.push(StackMappingVisitor.this.pop());
                        this._temp.push(StackMappingVisitor.this.pop());
                        this._temp.push(StackMappingVisitor.this.pop());
                        this._temp.push(StackMappingVisitor.this.pop());
                        break;
                    }
                    case PopI4_PopA: {
                        this._temp.push(StackMappingVisitor.this.pop());
                        this._temp.push(StackMappingVisitor.this.pop());
                        break;
                    }
                    case PopI4_PopI4_PopA: {
                        this._temp.push(StackMappingVisitor.this.pop());
                        this._temp.push(StackMappingVisitor.this.pop());
                        this._temp.push(StackMappingVisitor.this.pop());
                        break;
                    }
                    case PopI8_PopI4_PopA: {
                        this._temp.push(StackMappingVisitor.this.pop());
                        this._temp.push(StackMappingVisitor.this.pop());
                        this._temp.push(StackMappingVisitor.this.pop());
                        this._temp.push(StackMappingVisitor.this.pop());
                        break;
                    }
                    case PopR4_PopI4_PopA: {
                        this._temp.push(StackMappingVisitor.this.pop());
                        this._temp.push(StackMappingVisitor.this.pop());
                        this._temp.push(StackMappingVisitor.this.pop());
                        break;
                    }
                    case PopR8_PopI4_PopA: {
                        this._temp.push(StackMappingVisitor.this.pop());
                        this._temp.push(StackMappingVisitor.this.pop());
                        this._temp.push(StackMappingVisitor.this.pop());
                        this._temp.push(StackMappingVisitor.this.pop());
                        break;
                    }
                    case PopA_PopI4_PopA: {
                        this._temp.push(StackMappingVisitor.this.pop());
                        this._temp.push(StackMappingVisitor.this.pop());
                        this._temp.push(StackMappingVisitor.this.pop());
                        break;
                    }
                    case PopA_PopA: {
                        this._temp.push(StackMappingVisitor.this.pop());
                        this._temp.push(StackMappingVisitor.this.pop());
                        break;
                    }
                    case VarPop: {
                        switch (code) {
                            case INVOKEVIRTUAL: 
                            case INVOKESPECIAL: 
                            case INVOKESTATIC: 
                            case INVOKEINTERFACE: 
                            case INVOKEDYNAMIC: {
                                FrameValue firstParameter;
                                FrameValueType frameValueType;
                                IMethodSignature method = code == OpCode.INVOKEDYNAMIC ? ((DynamicCallSite)instruction.getOperand(0)).getMethodType() : (IMethodSignature)instruction.getOperand(0);
                                List<ParameterDefinition> parameters = method.getParameters();
                                if (code == OpCode.INVOKESPECIAL && ((MethodReference)method).isConstructor() && ((frameValueType = (firstParameter = StackMappingVisitor.this.getStackValue(this.computeSize(parameters))).getType()) == FrameValueType.UninitializedThis || frameValueType == FrameValueType.Uninitialized)) {
                                    Instruction next;
                                    TypeReference initializedType = frameValueType == FrameValueType.UninitializedThis ? this._body.getMethod().getDeclaringType() : ((MethodReference)method).getDeclaringType();
                                    if (initializedType.isGenericDefinition() && (next = instruction.getNext()) != null && next.getOpCode().isStore()) {
                                        int slot = InstructionHelper.getLoadOrStoreSlot(next);
                                        VariableDefinition variable = this._body.getVariables().tryFind(slot, next.getEndOffset());
                                        if (variable != null && variable.isFromMetadata() && variable.getVariableType() instanceof IGenericInstance && StringUtilities.equals((String)initializedType.getInternalName(), (String)variable.getVariableType().getInternalName())) {
                                            initializedType = variable.getVariableType();
                                        }
                                    }
                                    StackMappingVisitor.this.initialize(firstParameter, initializedType);
                                }
                                block81: for (ParameterDefinition parameterDefinition : parameters) {
                                    TypeReference parameterType = parameterDefinition.getParameterType();
                                    switch (parameterType.getSimpleType()) {
                                        case Long: 
                                        case Double: {
                                            this._temp.push(StackMappingVisitor.this.pop());
                                            this._temp.push(StackMappingVisitor.this.pop());
                                            continue block81;
                                        }
                                    }
                                    this._temp.push(StackMappingVisitor.this.pop());
                                }
                                if (code != OpCode.INVOKESTATIC && code != OpCode.INVOKEDYNAMIC) {
                                    this._temp.push(StackMappingVisitor.this.pop());
                                    break block0;
                                }
                                break block105;
                            }
                            case ATHROW: {
                                this._temp.push(StackMappingVisitor.this.pop());
                                while (!StackMappingVisitor.this._stack.isEmpty()) {
                                    StackMappingVisitor.this.pop();
                                }
                                break block105;
                            }
                            case MULTIANEWARRAY: {
                                int dimensions = ((Number)instruction.getOperand(1)).intValue();
                                for (int i = 0; i < dimensions; ++i) {
                                    this._temp.push(StackMappingVisitor.this.pop());
                                }
                            }
                        }
                    }
                }
            }
            if (code.isArrayLoad()) {
                FrameValue frameValue = this._temp.pop();
                Object parameter = frameValue.getParameter();
                switch (code) {
                    case BALOAD: 
                    case CALOAD: 
                    case SALOAD: 
                    case IALOAD: {
                        StackMappingVisitor.this.push(FrameValue.INTEGER);
                        break;
                    }
                    case LALOAD: {
                        StackMappingVisitor.this.push(FrameValue.LONG);
                        StackMappingVisitor.this.push(FrameValue.TOP);
                        break;
                    }
                    case FALOAD: {
                        StackMappingVisitor.this.push(FrameValue.FLOAT);
                        break;
                    }
                    case DALOAD: {
                        StackMappingVisitor.this.push(FrameValue.DOUBLE);
                        StackMappingVisitor.this.push(FrameValue.TOP);
                        break;
                    }
                    case AALOAD: {
                        if (parameter instanceof TypeReference) {
                            StackMappingVisitor.this.push(((TypeReference)parameter).getElementType());
                            break;
                        }
                        if (frameValue.getType() == FrameValueType.Null) {
                            StackMappingVisitor.this.push(FrameValue.NULL);
                            break;
                        }
                        StackMappingVisitor.this.push(FrameValue.TOP);
                    }
                }
                return;
            }
            if (code == OpCode.JSR || code == OpCode.JSR) {
                StackMappingVisitor.this.set(0, FrameValue.makeAddress(instruction.getNext()));
            }
            block42 : switch (code.getStackBehaviorPush()) {
                case Push0: {
                    break;
                }
                case Push1: {
                    switch (code) {
                        case LDC: 
                        case LDC_W: {
                            Object op = instruction.getOperand(0);
                            if (op instanceof String) {
                                StackMappingVisitor.this.push(this._factory.makeNamedType("java.lang.String"));
                                break;
                            }
                            if (op instanceof TypeReference) {
                                StackMappingVisitor.this.push(this._factory.makeNamedType("java.lang.Class"));
                                break;
                            }
                            if (op instanceof Long) {
                                StackMappingVisitor.this.push(FrameValue.LONG);
                                StackMappingVisitor.this.push(FrameValue.TOP);
                                break;
                            }
                            if (op instanceof Float) {
                                StackMappingVisitor.this.push(FrameValue.FLOAT);
                                break;
                            }
                            if (op instanceof Double) {
                                StackMappingVisitor.this.push(FrameValue.DOUBLE);
                                StackMappingVisitor.this.push(FrameValue.TOP);
                                break;
                            }
                            if (!(op instanceof Integer)) break;
                            StackMappingVisitor.this.push(FrameValue.INTEGER);
                            break;
                        }
                        case GETFIELD: 
                        case GETSTATIC: {
                            FieldReference field = (FieldReference)instruction.getOperand(0);
                            StackMappingVisitor.this.push(field.getFieldType());
                            break;
                        }
                    }
                    break;
                }
                case Push1_Push1: {
                    FrameValue t1;
                    switch (code) {
                        case DUP: {
                            FrameValue value = this._temp.pop();
                            StackMappingVisitor.this.push(value);
                            StackMappingVisitor.this.push(value);
                            break block42;
                        }
                        case SWAP: {
                            FrameValue t2 = this._temp.pop();
                            t1 = this._temp.pop();
                            StackMappingVisitor.this.push(t2);
                            StackMappingVisitor.this.push(t1);
                            break block42;
                        }
                    }
                    break;
                }
                case Push1_Push1_Push1: {
                    FrameValue t2 = this._temp.pop();
                    FrameValue t1 = this._temp.pop();
                    StackMappingVisitor.this.push(t1);
                    StackMappingVisitor.this.push(t2);
                    StackMappingVisitor.this.push(t1);
                    break;
                }
                case Push1_Push2_Push1: {
                    FrameValue t3 = this._temp.pop();
                    FrameValue t2 = this._temp.pop();
                    FrameValue t1 = this._temp.pop();
                    StackMappingVisitor.this.push(t1);
                    StackMappingVisitor.this.push(t3);
                    StackMappingVisitor.this.push(t2);
                    StackMappingVisitor.this.push(t1);
                    break;
                }
                case Push2: {
                    Number constant = (Number)instruction.getOperand(0);
                    if (constant instanceof Double) {
                        StackMappingVisitor.this.push(FrameValue.DOUBLE);
                        StackMappingVisitor.this.push(FrameValue.TOP);
                        break;
                    }
                    StackMappingVisitor.this.push(FrameValue.LONG);
                    StackMappingVisitor.this.push(FrameValue.TOP);
                    break;
                }
                case Push2_Push2: {
                    FrameValue t2 = this._temp.pop();
                    FrameValue t1 = this._temp.pop();
                    StackMappingVisitor.this.push(t2);
                    StackMappingVisitor.this.push(t1);
                    StackMappingVisitor.this.push(t2);
                    StackMappingVisitor.this.push(t1);
                    break;
                }
                case Push2_Push1_Push2: {
                    FrameValue t3 = this._temp.pop();
                    FrameValue t2 = this._temp.pop();
                    FrameValue t1 = this._temp.pop();
                    StackMappingVisitor.this.push(t2);
                    StackMappingVisitor.this.push(t1);
                    StackMappingVisitor.this.push(t3);
                    StackMappingVisitor.this.push(t2);
                    StackMappingVisitor.this.push(t1);
                    break;
                }
                case Push2_Push2_Push2: {
                    FrameValue t4 = this._temp.pop();
                    FrameValue t3 = this._temp.pop();
                    FrameValue t2 = this._temp.pop();
                    FrameValue frameValue = this._temp.pop();
                    StackMappingVisitor.this.push(t2);
                    StackMappingVisitor.this.push(frameValue);
                    StackMappingVisitor.this.push(t4);
                    StackMappingVisitor.this.push(t3);
                    StackMappingVisitor.this.push(t2);
                    StackMappingVisitor.this.push(frameValue);
                    break;
                }
                case PushI4: {
                    StackMappingVisitor.this.push(FrameValue.INTEGER);
                    break;
                }
                case PushI8: {
                    StackMappingVisitor.this.push(FrameValue.LONG);
                    StackMappingVisitor.this.push(FrameValue.TOP);
                    break;
                }
                case PushR4: {
                    StackMappingVisitor.this.push(FrameValue.FLOAT);
                    break;
                }
                case PushR8: {
                    StackMappingVisitor.this.push(FrameValue.DOUBLE);
                    StackMappingVisitor.this.push(FrameValue.TOP);
                    break;
                }
                case PushA: {
                    switch (code) {
                        case NEW: {
                            StackMappingVisitor.this.push(FrameValue.makeUninitializedReference(instruction));
                            break block42;
                        }
                        case NEWARRAY: 
                        case ANEWARRAY: {
                            StackMappingVisitor.this.push(((TypeReference)instruction.getOperand(0)).makeArrayType());
                            break block42;
                        }
                        case MULTIANEWARRAY: 
                        case CHECKCAST: {
                            StackMappingVisitor.this.push((TypeReference)instruction.getOperand(0));
                            break block42;
                        }
                        case ACONST_NULL: {
                            StackMappingVisitor.this.push(FrameValue.NULL);
                            break block42;
                        }
                    }
                    StackMappingVisitor.this.push(StackMappingVisitor.this.pop());
                    break;
                }
                case PushAddress: {
                    StackMappingVisitor.this.push(FrameValue.makeAddress(instruction.getNext()));
                    break;
                }
                case VarPush: {
                    IMethodSignature signature = code == OpCode.INVOKEDYNAMIC ? ((DynamicCallSite)instruction.getOperand(0)).getMethodType() : (IMethodSignature)instruction.getOperand(0);
                    TypeReference returnType = signature.getReturnType();
                    if (returnType.getSimpleType() != JvmType.Void) {
                        if (code != OpCode.INVOKESTATIC && code != OpCode.INVOKEDYNAMIC) {
                            Object object;
                            TypeReference typeReference = code == OpCode.INVOKESPECIAL ? ((MethodReference)signature).getDeclaringType() : ((object = this._temp.peek().getParameter()) instanceof Instruction ? (TypeReference)StackMappingVisitor.this._initializations.get(object) : (TypeReference)object);
                            TypeReference typeReference2 = this.substituteTypeArguments(typeReference, (MemberReference)((Object)signature));
                            returnType = this.substituteTypeArguments(this.substituteTypeArguments(signature.getReturnType(), (MemberReference)((Object)signature)), typeReference2);
                        } else if (instruction.getNext() != null && instruction.getNext().getOpCode().isStore()) {
                            Instruction next = instruction.getNext();
                            int n = InstructionHelper.getLoadOrStoreSlot(next);
                            VariableDefinition variable = this._body.getVariables().tryFind(n, next.getEndOffset());
                            if (variable != null && variable.isFromMetadata()) {
                                returnType = this.substituteTypeArguments(variable.getVariableType(), signature.getReturnType());
                            }
                        }
                    }
                    if (returnType.isWildcardType()) {
                        returnType = returnType.hasSuperBound() ? returnType.getSuperBound() : returnType.getExtendsBound();
                    }
                    switch (returnType.getSimpleType()) {
                        case Boolean: 
                        case Byte: 
                        case Character: 
                        case Short: 
                        case Integer: {
                            StackMappingVisitor.this.push(FrameValue.INTEGER);
                            break block42;
                        }
                        case Long: {
                            StackMappingVisitor.this.push(FrameValue.LONG);
                            StackMappingVisitor.this.push(FrameValue.TOP);
                            break block42;
                        }
                        case Float: {
                            StackMappingVisitor.this.push(FrameValue.FLOAT);
                            break block42;
                        }
                        case Double: {
                            StackMappingVisitor.this.push(FrameValue.DOUBLE);
                            StackMappingVisitor.this.push(FrameValue.TOP);
                            break block42;
                        }
                        case Object: 
                        case Array: 
                        case TypeVariable: 
                        case Wildcard: {
                            StackMappingVisitor.this.push(FrameValue.makeReference(returnType));
                            break block42;
                        }
                    }
                    break;
                }
            }
        }

        private int computeSize(List<ParameterDefinition> parameters) {
            int size = 0;
            for (ParameterDefinition parameter : parameters) {
                size += parameter.getSize();
            }
            return size;
        }

        private TypeReference substituteTypeArguments(TypeReference type, MemberReference member) {
            if (type instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)type;
                TypeReference elementType = this.substituteTypeArguments(arrayType.getElementType(), member);
                if (!MetadataResolver.areEquivalent(elementType, arrayType.getElementType())) {
                    return elementType.makeArrayType();
                }
                return type;
            }
            if (type instanceof IGenericInstance) {
                IGenericInstance genericInstance = (IGenericInstance)((Object)type);
                ArrayList<TypeReference> newTypeArguments = new ArrayList<TypeReference>();
                boolean isChanged = false;
                for (TypeReference typeArgument : genericInstance.getTypeArguments()) {
                    TypeReference newTypeArgument = this.substituteTypeArguments(typeArgument, member);
                    newTypeArguments.add(newTypeArgument);
                    isChanged |= newTypeArgument != typeArgument;
                }
                return isChanged ? type.makeGenericType(newTypeArguments) : type;
            }
            if (type instanceof GenericParameter) {
                TypeReference declaringType;
                GenericParameter genericParameter = (GenericParameter)type;
                IGenericParameterProvider owner = genericParameter.getOwner();
                if (member.getDeclaringType() instanceof ArrayType) {
                    return member.getDeclaringType().getElementType();
                }
                if (owner instanceof MethodReference && member instanceof MethodReference) {
                    MethodReference method = (MethodReference)member;
                    MethodReference ownerMethod = (MethodReference)owner;
                    if (method.isGenericMethod() && MetadataResolver.areEquivalent(ownerMethod.getDeclaringType(), method.getDeclaringType()) && StringUtilities.equals((String)ownerMethod.getName(), (String)method.getName()) && StringUtilities.equals((String)ownerMethod.getErasedSignature(), (String)method.getErasedSignature())) {
                        if (method instanceof IGenericInstance) {
                            List<TypeReference> typeArguments = ((IGenericInstance)((Object)member)).getTypeArguments();
                            return typeArguments.get(genericParameter.getPosition());
                        }
                        return method.getGenericParameters().get(genericParameter.getPosition());
                    }
                } else if (owner instanceof TypeReference && MetadataResolver.areEquivalent((TypeReference)owner, declaringType = member instanceof TypeReference ? (TypeReference)member : member.getDeclaringType())) {
                    if (declaringType instanceof IGenericInstance) {
                        List<TypeReference> typeArguments = ((IGenericInstance)((Object)declaringType)).getTypeArguments();
                        return typeArguments.get(genericParameter.getPosition());
                    }
                    if (!declaringType.isGenericDefinition()) {
                        declaringType = declaringType.resolve();
                    }
                    if (declaringType != null && declaringType.isGenericDefinition()) {
                        return declaringType.getGenericParameters().get(genericParameter.getPosition());
                    }
                }
            }
            return type;
        }
    }
}

