/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.ui.impl.command;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jboss.forge.addon.ui.annotation.Command;
import org.jboss.forge.addon.ui.command.CommandProvider;
import org.jboss.forge.addon.ui.command.UICommand;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.impl.annotation.AnnotationCommandAdapter;
import org.jboss.forge.addon.ui.impl.extension.AnnotatedCommandExtension;
import org.jboss.forge.addon.ui.impl.input.InputComponentProducer;
import org.jboss.forge.furnace.addons.AddonId;
import org.jboss.forge.furnace.addons.AddonRegistry;
import org.jboss.forge.furnace.event.PreShutdown;
import org.jboss.forge.furnace.services.Imported;
import org.jboss.forge.furnace.util.Predicate;

@Singleton
public class AnnotatedCommandProvider
implements CommandProvider {
    @Inject
    private AddonRegistry registry;
    @Inject
    private InputComponentProducer factory;
    @Inject
    private AnnotatedCommandExtension extension;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    public Iterable<UICommand> getCommands() {
        HashSet<UICommand> result = new HashSet<UICommand>();
        for (Method method : this.extension.getAnnotatedCommandMethods()) {
            try {
                UICommand cmd = this.createAnnotatedCommand(method);
                if (cmd == null) continue;
                result.add(cmd);
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Error while creating command for method " + method.getName(), e);
            }
        }
        return result;
    }

    private UICommand createAnnotatedCommand(Method method) {
        Imported service = this.registry.getServices(method.getDeclaringClass());
        if (service.isUnsatisfied()) {
            this.logger.log(Level.SEVERE, "Error while finding " + method.getDeclaringClass() + " as a service");
            return null;
        }
        Object instance = service.get();
        Command ann = method.getAnnotation(Command.class);
        ArrayList<Predicate<UIContext>> enabledPredicates = new ArrayList<Predicate<UIContext>>();
        for (Class type : ann.enabled()) {
            enabledPredicates.add((Predicate<UIContext>)this.registry.getServices(type).get());
        }
        return new AnnotationCommandAdapter(method, instance, this.factory, enabledPredicates);
    }

    public void addonDestroyed(@Observes PreShutdown shutdown) {
        AddonId id = shutdown.getAddon().getId();
        this.extension.addonDestroyed(id);
    }
}

