/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.maven.projects.archetype.ui;

import com.google.common.base.Strings;
import java.io.PrintStream;
import java.net.URL;
import java.util.Iterator;
import java.util.TreeSet;
import javax.inject.Inject;
import org.apache.maven.archetype.catalog.Archetype;
import org.apache.maven.archetype.catalog.ArchetypeCatalog;
import org.jboss.forge.addon.configuration.Configuration;
import org.jboss.forge.addon.configuration.Subset;
import org.jboss.forge.addon.maven.archetype.ArchetypeCatalogFactory;
import org.jboss.forge.addon.maven.archetype.ArchetypeCatalogFactoryRegistry;
import org.jboss.forge.addon.resource.URLResource;
import org.jboss.forge.addon.ui.annotation.Command;
import org.jboss.forge.addon.ui.annotation.Option;
import org.jboss.forge.addon.ui.annotation.predicate.NonGUIEnabledPredicate;
import org.jboss.forge.addon.ui.output.UIOutput;

public class ArchetypeCatalogCommands {
    @Inject
    @Subset(value="maven.archetypes")
    private Configuration configuration;
    @Inject
    private ArchetypeCatalogFactoryRegistry archetypeRegistry;

    @Command(value="Archetype: Add", categories={"Maven"})
    public void addArchetype(@Option(value="named", label="Archetype catalog Name", required=true) String name, @Option(value="url", label="Archetype catalog URL", required=true) URLResource url) {
        this.configuration.setProperty(name, (Object)url.getFullyQualifiedName());
        this.archetypeRegistry.addArchetypeCatalogFactory(name, (URL)url.getUnderlyingResourceObject());
    }

    @Command(value="Archetype: Remove", categories={"Maven"})
    public void removeArchetype(@Option(value="named", label="Archetype catalog name", required=true) String name) {
        this.configuration.clearProperty(name);
        this.archetypeRegistry.removeArchetypeCatalogFactory(name);
    }

    @Command(value="Archetype: List", categories={"Maven"}, enabled={NonGUIEnabledPredicate.class})
    public void listArchetypes(@Option(value="named", label="Archetype catalog name") String name, UIOutput output) {
        block5: {
            ArchetypeCatalog archetypeCatalog;
            PrintStream out;
            block4: {
                out = output.out();
                if (!Strings.isNullOrEmpty((String)name)) break block4;
                TreeSet<String> allKeys = new TreeSet<String>();
                Iterator keys = this.configuration.getKeys();
                while (keys.hasNext()) {
                    String key = keys.next().toString();
                    if (key.isEmpty()) continue;
                    allKeys.add(key);
                }
                for (ArchetypeCatalogFactory factory : this.archetypeRegistry.getArchetypeCatalogFactories()) {
                    allKeys.add(factory.getName());
                }
                for (String key : allKeys) {
                    String catalog = this.configuration.getString(key, "unknown");
                    out.println(key + " = " + catalog);
                }
                break block5;
            }
            ArchetypeCatalogFactory archetypeCatalogFactory = this.archetypeRegistry.getArchetypeCatalogFactory(name);
            if (archetypeCatalogFactory == null || (archetypeCatalog = archetypeCatalogFactory.getArchetypeCatalog()) == null) break block5;
            for (Archetype archetype : archetypeCatalog.getArchetypes()) {
                out.println(archetype);
            }
        }
    }
}

