/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.impl.addons;

import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.addons.AddonId;
import org.jboss.forge.furnace.impl.util.Files;
import org.jboss.forge.furnace.lock.LockManager;
import org.jboss.forge.furnace.lock.LockMode;
import org.jboss.forge.furnace.repositories.AddonDependencyEntry;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.forge.furnace.repositories.MutableAddonRepository;
import org.jboss.forge.furnace.util.Assert;
import org.jboss.forge.furnace.util.OperatingSystemUtils;
import org.jboss.forge.furnace.util.Streams;
import org.jboss.forge.furnace.versions.EmptyVersion;
import org.jboss.forge.furnace.versions.SingleVersion;
import org.jboss.forge.furnace.versions.Version;
import org.jboss.forge.furnace.versions.VersionRange;
import org.jboss.forge.furnace.versions.Versions;
import org.jboss.forge.parser.xml.Node;
import org.jboss.forge.parser.xml.XMLParser;
import org.jboss.forge.parser.xml.XMLParserException;

public final class AddonRepositoryImpl
implements MutableAddonRepository {
    private static final Logger logger = Logger.getLogger(AddonRepositoryImpl.class.getName());
    private static final String ATTR_API_VERSION = "api-version";
    private static final String ATTR_EXPORT = "export";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_OPTIONAL = "optional";
    private static final String ATTR_VERSION = "version";
    private static final String DEFAULT_ADDON_DIR = ".forge/addons";
    private static final String REGISTRY_DESCRIPTOR_NAME = "installed.xml";
    private static final String ADDON_DESCRIPTOR_FILENAME = "addon.xml";
    private static final String DEPENDENCY_TAG_NAME = "dependency";
    private static final String DEPENDENCIES_TAG_NAME = "dependencies";
    private final LockManager lock;
    private final File addonDir;
    private int version = 1;

    public static MutableAddonRepository forDirectory(Furnace furnace, File dir) {
        return new AddonRepositoryImpl(furnace.getLockManager(), dir);
    }

    public static MutableAddonRepository forDefaultDirectory(Furnace forge) {
        return new AddonRepositoryImpl(forge.getLockManager(), new File(OperatingSystemUtils.getUserHomePath(), DEFAULT_ADDON_DIR));
    }

    public static Version getRuntimeAPIVersion() {
        String version = AddonRepository.class.getPackage().getImplementationVersion();
        if (version != null) {
            return new SingleVersion(version);
        }
        return EmptyVersion.getInstance();
    }

    public static boolean hasRuntimeAPIVersion() {
        return AddonRepositoryImpl.getRuntimeAPIVersion() != null;
    }

    public static boolean isApiCompatible(Version runtimeVersion, AddonId entry) {
        Assert.notNull((Object)entry, (String)"Addon entry must not be null.");
        return Versions.isApiCompatible((Version)runtimeVersion, (Version)entry.getApiVersion());
    }

    private AddonRepositoryImpl(LockManager lock, File dir) {
        Assert.notNull((Object)lock, (String)"LockManager must not be null.");
        Assert.notNull((Object)dir, (String)"Addon directory must not be null.");
        this.addonDir = dir;
        this.lock = lock;
    }

    public boolean deploy(final AddonId addon, final Iterable<AddonDependencyEntry> dependencies, final Iterable<File> resources) {
        return (Boolean)this.lock.performLocked(LockMode.WRITE, (Callable)new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() throws Exception {
                File addonSlotDir = AddonRepositoryImpl.this.getAddonBaseDir(addon);
                File descriptor = AddonRepositoryImpl.this.getAddonDescriptor(addon);
                try {
                    if (resources != null) {
                        for (File resource : resources) {
                            if (resource.isDirectory()) {
                                String child = addon.getName() + resource.getParentFile().getParentFile().getName();
                                child = OperatingSystemUtils.getSafeFilename((String)child);
                                File target = new File(addonSlotDir, child);
                                logger.info("Copying " + resource + " to " + target);
                                Files.copyDirectory(resource, target);
                                continue;
                            }
                            logger.info("Copying " + resource + " to " + addonSlotDir);
                            Files.copyFileToDirectory(resource, addonSlotDir);
                        }
                    }
                    Node addonXml = AddonRepositoryImpl.this.getXmlRoot(descriptor);
                    Node dependenciesNode = addonXml.getOrCreate(AddonRepositoryImpl.DEPENDENCIES_TAG_NAME);
                    if (dependencies != null) {
                        for (AddonDependencyEntry dependency : dependencies) {
                            String name = dependency.getName();
                            Node dep = null;
                            for (Node node : dependenciesNode.get(AddonRepositoryImpl.DEPENDENCY_TAG_NAME)) {
                                if (!name.equals(node.getAttribute(AddonRepositoryImpl.ATTR_NAME))) continue;
                                dep = node;
                                break;
                            }
                            if (dep == null) {
                                dep = dependenciesNode.createChild(AddonRepositoryImpl.DEPENDENCY_TAG_NAME);
                                dep.attribute(AddonRepositoryImpl.ATTR_NAME, name);
                            }
                            dep.attribute(AddonRepositoryImpl.ATTR_VERSION, (Object)dependency.getVersionRange());
                            dep.attribute(AddonRepositoryImpl.ATTR_EXPORT, (Object)dependency.isExported());
                            dep.attribute(AddonRepositoryImpl.ATTR_OPTIONAL, (Object)dependency.isOptional());
                        }
                    }
                    FileOutputStream fos = null;
                    try {
                        fos = new FileOutputStream(descriptor);
                        Streams.write((InputStream)XMLParser.toXMLInputStream((Node)addonXml), (OutputStream)fos);
                    }
                    catch (Throwable throwable) {
                        Streams.closeQuietly(fos);
                        throw throwable;
                    }
                    Streams.closeQuietly((Closeable)fos);
                    return true;
                }
                catch (IOException io) {
                    io.printStackTrace();
                    return false;
                }
            }
        });
    }

    public boolean disable(final AddonId addon) {
        return (Boolean)this.lock.performLocked(LockMode.WRITE, (Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                if (addon == null) {
                    throw new RuntimeException("Addon must not be null");
                }
                File registryFile = AddonRepositoryImpl.this.getRepositoryRegistryFile();
                if (registryFile.exists()) {
                    try {
                        Node installed = AddonRepositoryImpl.this.getXmlRoot(registryFile);
                        Node child = installed.getSingle("addon@name=" + addon.getName() + "&" + AddonRepositoryImpl.ATTR_VERSION + "=" + addon.getVersion());
                        installed.removeChild(child);
                        AddonRepositoryImpl.this.saveRegistryFile(installed);
                        return true;
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Could not modify [" + registryFile.getAbsolutePath() + "] - ", e);
                    }
                }
                return false;
            }
        });
    }

    public boolean enable(final AddonId addon) {
        return (Boolean)this.lock.performLocked(LockMode.WRITE, (Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                if (addon == null) {
                    throw new RuntimeException("AddonId must not be null");
                }
                File registryFile = AddonRepositoryImpl.this.getRepositoryRegistryFile();
                try {
                    Node installed = AddonRepositoryImpl.this.getXmlRoot(registryFile);
                    installed.getOrCreate("addon@name=" + (addon.getName() == null ? "" : addon.getName()) + "&" + AddonRepositoryImpl.ATTR_VERSION + "=" + addon.getVersion()).attribute(AddonRepositoryImpl.ATTR_API_VERSION, (Object)(addon.getApiVersion() == null ? "" : addon.getApiVersion()));
                    AddonRepositoryImpl.this.saveRegistryFile(installed);
                    return true;
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException("Could not read [" + registryFile.getAbsolutePath() + "] - ", e);
                }
            }
        });
    }

    public File getAddonBaseDir(final AddonId found) {
        Assert.notNull((Object)found, (String)"Addon must be specified.");
        Assert.notNull((Object)found.getVersion(), (String)"Addon version must be specified.");
        Assert.notNull((Object)found.getName(), (String)"Addon name must be specified.");
        return (File)this.lock.performLocked(LockMode.READ, (Callable)new Callable<File>(){

            @Override
            public File call() throws Exception {
                File addonDir = new File(AddonRepositoryImpl.this.getRootDirectory(), OperatingSystemUtils.getSafeFilename((String)found.toCoordinates()));
                return addonDir;
            }
        });
    }

    public Set<AddonDependencyEntry> getAddonDependencies(final AddonId addon) {
        return (Set)this.lock.performLocked(LockMode.READ, (Callable)new Callable<Set<AddonDependencyEntry>>(){

            @Override
            public Set<AddonDependencyEntry> call() throws Exception {
                HashSet<AddonDependencyEntry> result = new HashSet<AddonDependencyEntry>();
                File descriptor = AddonRepositoryImpl.this.getAddonDescriptor(addon);
                try {
                    Node installed = AddonRepositoryImpl.this.getXmlRoot(descriptor);
                    List children = installed.get("dependencies/dependency");
                    for (Node child : children) {
                        if (child == null) continue;
                        result.add(AddonDependencyEntry.create((String)child.getAttribute(AddonRepositoryImpl.ATTR_NAME), (VersionRange)Versions.parseMultipleVersionRange((String)child.getAttribute(AddonRepositoryImpl.ATTR_VERSION)), (boolean)Boolean.valueOf(child.getAttribute(AddonRepositoryImpl.ATTR_EXPORT)), (boolean)Boolean.valueOf(child.getAttribute(AddonRepositoryImpl.ATTR_OPTIONAL))));
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
                return result;
            }
        });
    }

    public File getAddonDescriptor(final AddonId addon) {
        return (File)this.lock.performLocked(LockMode.READ, (Callable)new Callable<File>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public File call() throws Exception {
                File descriptorFile = AddonRepositoryImpl.this.getAddonDescriptorFile(addon);
                try {
                    if (!descriptorFile.exists()) {
                        descriptorFile.mkdirs();
                        descriptorFile.delete();
                        descriptorFile.createNewFile();
                        FileOutputStream stream = null;
                        try {
                            stream = new FileOutputStream(descriptorFile);
                            Streams.write((InputStream)XMLParser.toXMLInputStream((Node)XMLParser.parse((String)"<addon/>")), (OutputStream)stream);
                        }
                        catch (Throwable throwable) {
                            Streams.closeQuietly(stream);
                            throw throwable;
                        }
                        Streams.closeQuietly((Closeable)stream);
                    }
                    return descriptorFile;
                }
                catch (Exception e) {
                    throw new RuntimeException("Error initializing addon descriptor file.", e);
                }
            }
        });
    }

    private File getAddonDescriptorFile(final AddonId addon) {
        return (File)this.lock.performLocked(LockMode.READ, (Callable)new Callable<File>(){

            @Override
            public File call() throws Exception {
                return new File(AddonRepositoryImpl.this.getAddonBaseDir(addon), AddonRepositoryImpl.ADDON_DESCRIPTOR_FILENAME);
            }
        });
    }

    public List<File> getAddonResources(final AddonId found) {
        return (List)this.lock.performLocked(LockMode.READ, (Callable)new Callable<List<File>>(){

            @Override
            public List<File> call() throws Exception {
                File dir = AddonRepositoryImpl.this.getAddonBaseDir(found);
                if (dir.exists()) {
                    File[] files = dir.listFiles(new FileFilter(){

                        @Override
                        public boolean accept(File pathname) {
                            return pathname.isDirectory() || pathname.getName().endsWith(".jar");
                        }
                    });
                    return Arrays.asList(files);
                }
                return Collections.emptyList();
            }
        });
    }

    public File getRootDirectory() {
        if (!this.addonDir.exists() || !this.addonDir.isDirectory()) {
            this.lock.performLocked(LockMode.READ, (Callable)new Callable<File>(){

                @Override
                public File call() throws Exception {
                    AddonRepositoryImpl.this.addonDir.delete();
                    System.gc();
                    if (!AddonRepositoryImpl.this.addonDir.mkdirs()) {
                        throw new RuntimeException("Could not create Addon Directory [" + AddonRepositoryImpl.this.addonDir + "]");
                    }
                    return AddonRepositoryImpl.this.addonDir;
                }
            });
        }
        return this.addonDir;
    }

    private File getRepositoryRegistryFile() {
        return (File)this.lock.performLocked(LockMode.READ, (Callable)new Callable<File>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public File call() throws Exception {
                File registryFile = new File(AddonRepositoryImpl.this.getRootDirectory(), AddonRepositoryImpl.REGISTRY_DESCRIPTOR_NAME);
                try {
                    if (!registryFile.exists()) {
                        registryFile.createNewFile();
                        FileOutputStream out = null;
                        try {
                            out = new FileOutputStream(registryFile);
                            Streams.write((InputStream)XMLParser.toXMLInputStream((Node)XMLParser.parse((String)"<installed></installed>")), (OutputStream)out);
                        }
                        catch (Throwable throwable) {
                            Streams.closeQuietly(out);
                            throw throwable;
                        }
                        Streams.closeQuietly((Closeable)out);
                    }
                    return registryFile;
                }
                catch (Exception e) {
                    throw new RuntimeException("Error initializing addon registry file [" + registryFile + "]", e);
                }
            }
        });
    }

    public boolean isDeployed(final AddonId addon) {
        return (Boolean)this.lock.performLocked(LockMode.READ, (Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                File addonBaseDir = AddonRepositoryImpl.this.getAddonBaseDir(addon);
                File addonDescriptorFile = AddonRepositoryImpl.this.getAddonDescriptorFile(addon);
                return addonBaseDir.exists() && addonDescriptorFile.exists();
            }
        });
    }

    public boolean isEnabled(final AddonId addon) {
        return (Boolean)this.lock.performLocked(LockMode.READ, (Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                List<AddonId> enabled = AddonRepositoryImpl.this.listEnabledCompatibleWithVersion(AddonRepositoryImpl.getRuntimeAPIVersion());
                for (AddonId id : enabled) {
                    if (!id.equals((Object)addon)) continue;
                    return true;
                }
                return false;
            }
        });
    }

    public List<AddonId> listEnabled() {
        return (List)this.lock.performLocked(LockMode.READ, (Callable)new Callable<List<AddonId>>(){

            @Override
            public List<AddonId> call() throws Exception {
                ArrayList<AddonId> result = new ArrayList<AddonId>();
                File registryFile = AddonRepositoryImpl.this.getRepositoryRegistryFile();
                try {
                    Node installed = AddonRepositoryImpl.this.getXmlRoot(registryFile);
                    if (installed == null) {
                        return Collections.emptyList();
                    }
                    List list = installed.get("addon");
                    for (Node addon : list) {
                        AddonId entry = AddonId.from((String)addon.getAttribute(AddonRepositoryImpl.ATTR_NAME), (String)addon.getAttribute(AddonRepositoryImpl.ATTR_VERSION), (String)addon.getAttribute(AddonRepositoryImpl.ATTR_API_VERSION));
                        result.add(entry);
                    }
                }
                catch (XMLParserException e) {
                    throw new RuntimeException("Invalid syntax in [" + registryFile.getAbsolutePath() + "] - Please delete this file and restart Furnace", e);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
                return result;
            }
        });
    }

    public List<AddonId> listEnabledCompatibleWithVersion(final Version version) {
        return (List)this.lock.performLocked(LockMode.READ, (Callable)new Callable<List<AddonId>>(){

            @Override
            public List<AddonId> call() throws Exception {
                List<AddonId> list;
                List<AddonId> result = list = AddonRepositoryImpl.this.listEnabled();
                result = new ArrayList<AddonId>();
                for (AddonId entry : list) {
                    if (version != null && entry.getApiVersion() != null && !Versions.isApiCompatible((Version)version, (Version)entry.getApiVersion())) continue;
                    result.add(entry);
                }
                return result;
            }
        });
    }

    public boolean undeploy(final AddonId addon) {
        return (Boolean)this.lock.performLocked(LockMode.WRITE, (Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                File dir = AddonRepositoryImpl.this.getAddonBaseDir(addon);
                AddonRepositoryImpl.this.disable(addon);
                return Files.delete(dir, true);
            }
        });
    }

    private Node getXmlRoot(File registryFile) throws FileNotFoundException, InterruptedException {
        Node installed = null;
        while (installed == null) {
            try {
                installed = XMLParser.parse((File)registryFile);
            }
            catch (XMLParserException e) {
                logger.log(Level.WARNING, "Error occurred while parsing [" + registryFile + "]", e);
            }
        }
        return installed;
    }

    public Date getLastModified() {
        return (Date)this.lock.performLocked(LockMode.READ, (Callable)new Callable<Date>(){

            @Override
            public Date call() throws Exception {
                return new Date(AddonRepositoryImpl.this.getRepositoryRegistryFile().lastModified());
            }
        });
    }

    public int getVersion() {
        return this.version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveRegistryFile(Node installed) throws FileNotFoundException {
        FileOutputStream outStream = null;
        try {
            outStream = new FileOutputStream(this.getRepositoryRegistryFile());
            this.incrementVersion();
            Streams.write((InputStream)XMLParser.toXMLInputStream((Node)installed), (OutputStream)outStream);
        }
        catch (Throwable throwable) {
            Streams.closeQuietly(outStream);
            throw throwable;
        }
        Streams.closeQuietly((Closeable)outStream);
    }

    private void incrementVersion() {
        ++this.version;
    }

    public String toString() {
        return this.getRootDirectory().getAbsolutePath();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.addonDir == null ? 0 : this.addonDir.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AddonRepositoryImpl other = (AddonRepositoryImpl)obj;
        return !(this.addonDir == null ? other.addonDir != null : !this.addonDir.equals(other.addonDir));
    }
}

