/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.jersey;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.codahale.metrics.annotation.ExceptionMetered;
import com.codahale.metrics.annotation.Metered;
import com.codahale.metrics.annotation.Timed;
import com.sun.jersey.api.core.HttpContext;
import com.sun.jersey.api.model.AbstractResourceMethod;
import com.sun.jersey.spi.container.ResourceMethodDispatchProvider;
import com.sun.jersey.spi.dispatch.RequestDispatcher;

class InstrumentedResourceMethodDispatchProvider
implements ResourceMethodDispatchProvider {
    private final ResourceMethodDispatchProvider provider;
    private final MetricRegistry registry;

    private static <T extends Exception> void throwUnchecked(Throwable e) throws T {
        throw (Exception)e;
    }

    public InstrumentedResourceMethodDispatchProvider(ResourceMethodDispatchProvider provider, MetricRegistry registry) {
        this.provider = provider;
        this.registry = registry;
    }

    public RequestDispatcher create(AbstractResourceMethod method) {
        Meter meter;
        String name;
        Timed annotation;
        RequestDispatcher dispatcher = this.provider.create(method);
        if (dispatcher == null) {
            return null;
        }
        if (method.getMethod().isAnnotationPresent(Timed.class)) {
            annotation = method.getMethod().getAnnotation(Timed.class);
            name = this.chooseName(annotation.name(), annotation.absolute(), method, new String[0]);
            Timer timer = this.registry.timer(name);
            dispatcher = new TimedRequestDispatcher(dispatcher, timer);
        }
        if (method.getMethod().isAnnotationPresent(Metered.class)) {
            annotation = method.getMethod().getAnnotation(Metered.class);
            name = this.chooseName(annotation.name(), annotation.absolute(), method, new String[0]);
            meter = this.registry.meter(name);
            dispatcher = new MeteredRequestDispatcher(dispatcher, meter);
        }
        if (method.getMethod().isAnnotationPresent(ExceptionMetered.class)) {
            annotation = method.getMethod().getAnnotation(ExceptionMetered.class);
            name = this.chooseName(annotation.name(), annotation.absolute(), method, "exceptions");
            meter = this.registry.meter(name);
            dispatcher = new ExceptionMeteredRequestDispatcher(dispatcher, meter, annotation.cause());
        }
        return dispatcher;
    }

    private String chooseName(String explicitName, boolean absolute, AbstractResourceMethod method, String ... suffixes) {
        if (explicitName != null && !explicitName.isEmpty()) {
            if (absolute) {
                return explicitName;
            }
            return MetricRegistry.name((Class)method.getDeclaringResource().getResourceClass(), (String[])new String[]{explicitName});
        }
        return MetricRegistry.name((String)MetricRegistry.name((Class)method.getDeclaringResource().getResourceClass(), (String[])new String[]{method.getMethod().getName()}), (String[])suffixes);
    }

    private static class ExceptionMeteredRequestDispatcher
    implements RequestDispatcher {
        private final RequestDispatcher underlying;
        private final Meter meter;
        private final Class<? extends Throwable> exceptionClass;

        private ExceptionMeteredRequestDispatcher(RequestDispatcher underlying, Meter meter, Class<? extends Throwable> exceptionClass) {
            this.underlying = underlying;
            this.meter = meter;
            this.exceptionClass = exceptionClass;
        }

        public void dispatch(Object resource, HttpContext httpContext) {
            try {
                this.underlying.dispatch(resource, httpContext);
            }
            catch (Exception e) {
                if (this.exceptionClass.isAssignableFrom(e.getClass()) || e.getCause() != null && this.exceptionClass.isAssignableFrom(e.getCause().getClass())) {
                    this.meter.mark();
                }
                InstrumentedResourceMethodDispatchProvider.throwUnchecked(e);
            }
        }
    }

    private static class MeteredRequestDispatcher
    implements RequestDispatcher {
        private final RequestDispatcher underlying;
        private final Meter meter;

        private MeteredRequestDispatcher(RequestDispatcher underlying, Meter meter) {
            this.underlying = underlying;
            this.meter = meter;
        }

        public void dispatch(Object resource, HttpContext httpContext) {
            this.meter.mark();
            this.underlying.dispatch(resource, httpContext);
        }
    }

    private static class TimedRequestDispatcher
    implements RequestDispatcher {
        private final RequestDispatcher underlying;
        private final Timer timer;

        private TimedRequestDispatcher(RequestDispatcher underlying, Timer timer) {
            this.underlying = underlying;
            this.timer = timer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispatch(Object resource, HttpContext httpContext) {
            Timer.Context context = this.timer.time();
            try {
                this.underlying.dispatch(resource, httpContext);
            }
            finally {
                context.stop();
            }
        }
    }
}

