/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.scan.ast;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.forge.roaster.model.JavaType;
import org.jboss.forge.roaster.model.source.Import;
import org.jboss.forge.roaster.model.source.Importer;
import org.jboss.forge.roaster.spi.WildcardImportResolver;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.rules.apps.java.service.JavaClassService;

public class WindupRoasterWildcardImportResolver
implements WildcardImportResolver {
    private static ThreadLocal<GraphContext> graphContextTL = new ThreadLocal();
    private final Map<String, String> classNameToFQCN = new HashMap<String, String>();
    private final Set<String> classNameLookedUp = new HashSet<String>();

    public String resolve(JavaType<?> source, String type) {
        GraphContext graphContext = this.getGraphContext();
        if (graphContext == null) {
            return type;
        }
        if (this.classNameLookedUp.contains(type)) {
            String qualifiedName = this.classNameToFQCN.get(type);
            if (qualifiedName != null) {
                return qualifiedName;
            }
            return type;
        }
        this.classNameLookedUp.add(type);
        Importer importer = (Importer)source;
        for (Import importDeclaration : importer.getImports()) {
            String wildcardImport;
            String candidateQualifiedName;
            JavaClassService javaClassService;
            Iterable models;
            if (!importDeclaration.isWildcard() || !(models = (javaClassService = new JavaClassService(graphContext)).findAllByProperty("qualifiedName", candidateQualifiedName = (wildcardImport = importDeclaration.getQualifiedName()) + "." + type)).iterator().hasNext()) continue;
            this.classNameToFQCN.put(type, candidateQualifiedName);
            return candidateQualifiedName;
        }
        return type;
    }

    private GraphContext getGraphContext() {
        return graphContextTL.get();
    }

    public static void setGraphContext(GraphContext graphContext) {
        graphContextTL.set(graphContext);
    }
}

