/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.service;

import java.util.ArrayList;
import java.util.List;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.report.IgnoredFileRegexModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.rules.apps.java.model.PackageModel;
import org.jboss.windup.rules.apps.java.model.WindupJavaConfigurationModel;

public class WindupJavaConfigurationService
extends GraphService<WindupJavaConfigurationModel> {
    private List<String> ignoredRegexes;

    public WindupJavaConfigurationService(GraphContext context) {
        super(context, WindupJavaConfigurationModel.class);
    }

    public static synchronized WindupJavaConfigurationModel getJavaConfigurationModel(GraphContext context) {
        WindupJavaConfigurationService service = new WindupJavaConfigurationService(context);
        WindupJavaConfigurationModel config = (WindupJavaConfigurationModel)service.getUnique();
        if (config == null) {
            config = (WindupJavaConfigurationModel)service.create();
        }
        return config;
    }

    public List<String> getIgnoredFileRegexes() {
        if (this.ignoredRegexes == null) {
            this.ignoredRegexes = new ArrayList<String>();
            WindupJavaConfigurationModel cfg = WindupJavaConfigurationService.getJavaConfigurationModel(this.getGraphContext());
            for (IgnoredFileRegexModel ignored : cfg.getIgnoredFileRegexes()) {
                this.ignoredRegexes.add(ignored.getRegex());
            }
        }
        return this.ignoredRegexes;
    }

    public boolean shouldScanPackage(String pkg) {
        if (pkg == null) {
            pkg = "";
        }
        WindupJavaConfigurationModel cfg = WindupJavaConfigurationService.getJavaConfigurationModel(this.getGraphContext());
        for (PackageModel pkgModel : cfg.getExcludeJavaPackages()) {
            String excludePkg = pkgModel.getPackageName();
            if (!pkg.startsWith(excludePkg)) continue;
            return false;
        }
        if (!cfg.getScanJavaPackages().iterator().hasNext()) {
            return true;
        }
        for (PackageModel pkgModel : cfg.getScanJavaPackages()) {
            String includePkg = pkgModel.getPackageName();
            if (!pkg.startsWith(includePkg)) continue;
            return true;
        }
        return false;
    }
}

