/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.fulgora;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AbstractFuture;
import com.thinkaurelius.titan.core.TitanEdge;
import com.thinkaurelius.titan.core.TitanException;
import com.thinkaurelius.titan.core.TitanProperty;
import com.thinkaurelius.titan.core.olap.OLAPJob;
import com.thinkaurelius.titan.core.olap.OLAPResult;
import com.thinkaurelius.titan.core.olap.StateInitializer;
import com.thinkaurelius.titan.diskstorage.BackendTransaction;
import com.thinkaurelius.titan.diskstorage.Entry;
import com.thinkaurelius.titan.diskstorage.EntryList;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyIterator;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.SliceQuery;
import com.thinkaurelius.titan.diskstorage.util.BufferUtil;
import com.thinkaurelius.titan.diskstorage.util.RecordIterator;
import com.thinkaurelius.titan.diskstorage.util.StaticArrayEntry;
import com.thinkaurelius.titan.diskstorage.util.StaticArrayEntryList;
import com.thinkaurelius.titan.graphdb.database.EdgeSerializer;
import com.thinkaurelius.titan.graphdb.fulgora.FulgoraEdgeQuery;
import com.thinkaurelius.titan.graphdb.fulgora.FulgoraNeighborVertex;
import com.thinkaurelius.titan.graphdb.fulgora.FulgoraPropertyQuery;
import com.thinkaurelius.titan.graphdb.fulgora.FulgoraRelationQuery;
import com.thinkaurelius.titan.graphdb.fulgora.FulgoraResult;
import com.thinkaurelius.titan.graphdb.fulgora.FulgoraVertex;
import com.thinkaurelius.titan.graphdb.idmanagement.IDManager;
import com.thinkaurelius.titan.graphdb.internal.InternalRelation;
import com.thinkaurelius.titan.graphdb.internal.InternalVertex;
import com.thinkaurelius.titan.graphdb.transaction.RelationConstructor;
import com.thinkaurelius.titan.graphdb.transaction.StandardTitanTx;
import com.thinkaurelius.titan.graphdb.transaction.VertexFactory;
import com.thinkaurelius.titan.graphdb.types.TypeInspector;
import com.thinkaurelius.titan.graphdb.types.system.BaseKey;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FulgoraExecutor<S>
extends AbstractFuture<OLAPResult<S>>
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(FulgoraExecutor.class);
    private static final int QUEUE_SIZE = 1000;
    private static final int TIMEOUT_MS = 60000;
    private final Map<String, FulgoraRelationQuery> queryDefinitions;
    private final int numQueries;
    private final List<BlockingQueue<QueryResult>> dataQueues;
    private final DataPuller[] pullThreads;
    private final int numProcessors;
    private final StandardTitanTx tx;
    private final EdgeSerializer edgeSerializer;
    private final IDManager idManager;
    private final OLAPJob<S> job;
    private final ConcurrentMap<Long, MessageAccumulator> partitionedVertexMsgs;
    final FulgoraResult<S> vertexStates;
    final String stateKey;
    final StateInitializer<S> initializer;
    private boolean processingException = false;
    private final VertexFactory neighborVertices = new VertexFactory(){

        @Override
        public InternalVertex getInternalVertex(long id) {
            return new FulgoraNeighborVertex(id, FulgoraExecutor.this);
        }
    };

    FulgoraExecutor(Map<String, FulgoraRelationQuery> queryDefs, StandardTitanTx tx, IDManager idManager, int numProcessors, String stateKey, OLAPJob job, StateInitializer<S> initializer, FulgoraResult<S> initialState) {
        this.tx = tx;
        this.edgeSerializer = tx.getEdgeSerializer();
        this.stateKey = stateKey;
        this.job = job;
        this.initializer = initializer;
        BackendTransaction btx = tx.getTxHandle();
        this.idManager = idManager;
        this.queryDefinitions = queryDefs;
        this.numProcessors = numProcessors;
        int count = 0;
        for (FulgoraRelationQuery frq : queryDefs.values()) {
            count += frq.queries.size();
        }
        this.numQueries = count + 1;
        this.dataQueues = new ArrayList<BlockingQueue<QueryResult>>(this.numQueries);
        this.pullThreads = new DataPuller[this.numQueries];
        int pos = 0;
        this.pullThreads[pos++] = this.addDataPuller(BaseKey.VertexExists.getName(), new SliceQuery(BufferUtil.zeroBuffer(4), BufferUtil.oneBuffer(4)).setLimit(1), btx);
        for (Map.Entry<String, FulgoraRelationQuery> queryDef : queryDefs.entrySet()) {
            String queryName = queryDef.getKey();
            List<SliceQuery> sqs = queryDef.getValue().queries;
            for (SliceQuery sq : sqs) {
                this.pullThreads[pos++] = this.addDataPuller(queryName, sq, btx);
            }
        }
        this.partitionedVertexMsgs = new ConcurrentHashMap<Long, MessageAccumulator>();
        this.vertexStates = initialState;
    }

    StandardTitanTx tx() {
        return this.tx;
    }

    private final DataPuller addDataPuller(String queryName, SliceQuery sq, BackendTransaction btx) {
        LinkedBlockingQueue queue = new LinkedBlockingQueue(1000);
        this.dataQueues.add(queue);
        DataPuller dp = new DataPuller(this.idManager, queryName, queue, btx.edgeStoreKeys(sq));
        dp.start();
        return dp;
    }

    S getVertexState(long vertexId) {
        S state;
        if (IDManager.VertexIDType.Hidden.is(vertexId)) {
            return null;
        }
        if (this.idManager.isPartitionedVertex(vertexId)) {
            vertexId = this.idManager.getCanonicalVertexId(vertexId);
        }
        if ((state = this.vertexStates.get(vertexId)) == null) {
            state = this.initializer.initialState();
        }
        return state;
    }

    void setVertexState(long vertexId, S state) {
        this.vertexStates.set(vertexId, state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        processor = new ThreadPoolExecutor(this.numProcessors, this.numProcessors, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(1000));
        processor.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
        try {
            currentResults = new QueryResult[this.numQueries];
            while (true) {
                for (i = 0; i < this.numQueries; ++i) {
                    if (currentResults[i] != null) continue;
                    queue = this.dataQueues.get(i);
                    qr = queue.poll(10L, TimeUnit.MILLISECONDS);
                    if (qr == null) {
                        if (this.pullThreads[i].isFinished()) continue;
                        qr = queue.poll(60000L, TimeUnit.MILLISECONDS);
                        if (qr == null && !this.pullThreads[i].isFinished()) {
                            throw new TitanException("Timed out waiting for next vertex data - storage error likely");
                        }
                    }
                    currentResults[i] = qr;
                }
                conditionQuery = currentResults[0];
                currentResults[0] = null;
                if (conditionQuery == null) break;
                relCache = this.tx.getEdgeSerializer().parseRelation((Entry)conditionQuery.entries.get(0), true, this.tx);
                vertexid = conditionQuery.vertexId;
                if (relCache.typeId != BaseKey.VertexExists.getLongId() && (!this.idManager.isPartitionedVertex(vertexid) || this.idManager.isCanonicalVertexId(vertexid))) {
                    FulgoraExecutor.log.warn("Found deleted vertex with id: {}|{}|{}. Skipping", new Object[]{conditionQuery.vertexId, this.idManager.isPartitionedVertex(vertexid), relCache});
                    if (this.idManager.isPartitionedVertex(vertexid)) {
                        MessageAccumulator.access$100(this.getMessageAccumulator(vertexid));
                    }
                    i = 1;
                    while (true) {
                        if (i >= currentResults.length) ** continue;
                        if (currentResults[i] != null && currentResults[i].vertexId == conditionQuery.vertexId) {
                            currentResults[i] = null;
                        }
                        ++i;
                    }
                }
                queryResults = new ArrayList<QueryResult>(this.numQueries - 1);
                for (i = 1; i < currentResults.length; ++i) {
                    if (currentResults[i] == null || currentResults[i].vertexId != vertexid) continue;
                    queryResults.add(currentResults[i]);
                    currentResults[i] = null;
                }
                processor.submit(new VertexProcessor(vertexid, queryResults));
            }
            processor.shutdown();
            processor.awaitTermination(60000L, TimeUnit.MILLISECONDS);
            if (!processor.isTerminated()) {
                throw new TitanException("Timed out waiting for vertex processors");
            }
            for (i = 0; i < this.pullThreads.length; ++i) {
                this.pullThreads[i].join(10L);
                if (!this.pullThreads[i].isAlive()) continue;
                throw new TitanException("Could not join data pulling thread");
            }
            if (!this.partitionedVertexMsgs.isEmpty()) {
                processor = new ThreadPoolExecutor(this.numProcessors, this.numProcessors, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(1000));
                processor.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
                for (Map.Entry<K, V> partitionVertexMsg : this.partitionedVertexMsgs.entrySet()) {
                    mergedMsg = (MessageAccumulator)partitionVertexMsg.getValue();
                    if (MessageAccumulator.access$300(mergedMsg)) {
                        FulgoraExecutor.log.warn("Found deleted partitioned vertex with id: {}. Skipping", partitionVertexMsg.getKey());
                        continue;
                    }
                    vertex = new FulgoraVertex<S>(this.tx, (long)((Long)partitionVertexMsg.getKey()), this);
                    processor.submit(new Runnable(){

                        @Override
                        public void run() {
                            FulgoraExecutor.this.processVertex(vertex, mergedMsg);
                        }
                    });
                }
                processor.shutdown();
                processor.awaitTermination(60000L, TimeUnit.MILLISECONDS);
                if (!processor.isTerminated()) {
                    throw new TitanException("Timed out waiting for partitioned-vertex processors");
                }
            }
            this.tx.rollback();
            this.set(this.vertexStates);
        }
        catch (Throwable e) {
            FulgoraExecutor.log.error("Exception occured during job execution: {}", e);
            this.setException(e);
        }
        finally {
            processor.shutdownNow();
        }
    }

    private MessageAccumulator getMessageAccumulator(long partitionedVertexId) {
        Preconditions.checkArgument((boolean)this.idManager.isPartitionedVertex(partitionedVertexId));
        long canonicalId = this.idManager.getCanonicalVertexId(partitionedVertexId);
        MessageAccumulator accMsg = (MessageAccumulator)this.partitionedVertexMsgs.get(canonicalId);
        if (accMsg == null) {
            this.partitionedVertexMsgs.putIfAbsent(canonicalId, new MessageAccumulator());
            accMsg = (MessageAccumulator)this.partitionedVertexMsgs.get(canonicalId);
        }
        return accMsg;
    }

    private void processVertex(FulgoraVertex<S> vertex, Map<String, Object> pulledMessages) {
        long vertexId = vertex.getLongId();
        try {
            vertex.setProcessedProperties(pulledMessages);
            S newState = this.job.process(vertex);
            this.setVertexState(vertexId, newState);
        }
        catch (Throwable e) {
            log.error("Exception processing vertex [" + vertexId + "]: ", e);
            this.processingException = true;
            this.setVertexState(vertexId, null);
        }
    }

    private static class QueryResult {
        final EntryList entries;
        final long vertexId;
        final String queryName;

        private QueryResult(String queryName, long vertexId, EntryList entries) {
            this.entries = entries;
            this.vertexId = vertexId;
            this.queryName = queryName;
        }
    }

    private static class DataPuller
    extends Thread {
        private final BlockingQueue<QueryResult> queue;
        private final String queryName;
        private final KeyIterator keyIter;
        private final IDManager idManager;
        private volatile boolean finished;

        private DataPuller(IDManager idManager, String queryName, BlockingQueue<QueryResult> queue, KeyIterator keyIter) {
            this.queryName = queryName;
            this.queue = queue;
            this.keyIter = keyIter;
            this.idManager = idManager;
            this.finished = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (this.keyIter.hasNext()) {
                    StaticBuffer key = (StaticBuffer)this.keyIter.next();
                    RecordIterator<Entry> entries = this.keyIter.getEntries();
                    long vertexId = this.idManager.getKeyID(key);
                    if (IDManager.VertexIDType.Hidden.is(vertexId)) continue;
                    EntryList entryList = StaticArrayEntryList.ofStaticBuffer(entries, StaticArrayEntry.ENTRY_GETTER);
                    try {
                        this.queue.put(new QueryResult(this.queryName, vertexId, entryList));
                    }
                    catch (InterruptedException e) {
                        log.error("Data-pulling thread interrupted while waiting on queue", (Throwable)e);
                        break;
                    }
                }
                this.finished = true;
            }
            catch (Throwable e) {
                log.error("Could not load data from storage: {}", e);
            }
            finally {
                try {
                    this.keyIter.close();
                }
                catch (IOException e) {
                    log.warn("Could not close storage iterator ", (Throwable)e);
                }
            }
        }

        public boolean isFinished() {
            return this.finished;
        }
    }

    private class MessageAccumulator
    extends HashMap<String, Object> {
        private boolean isDeleted;

        private MessageAccumulator() {
            super(FulgoraExecutor.this.queryDefinitions.size());
            this.isDeleted = false;
        }

        private synchronized void add(Map<String, Object> pulledMessages) {
            for (Map.Entry<String, Object> add : pulledMessages.entrySet()) {
                if (add.getValue() == null) continue;
                String key = add.getKey();
                Object existing = super.get(key);
                if (existing == null) {
                    super.put(key, add.getValue());
                    continue;
                }
                super.put(key, ((FulgoraRelationQuery)((FulgoraExecutor)FulgoraExecutor.this).queryDefinitions.get((Object)key)).combiner.combine(existing, add.getValue()));
            }
        }

        private void markDeleted() {
            this.isDeleted = true;
        }

        private boolean isDeleted() {
            return this.isDeleted;
        }

        static /* synthetic */ void access$100(MessageAccumulator x0) {
            x0.markDeleted();
        }

        static /* synthetic */ boolean access$300(MessageAccumulator x0) {
            return x0.isDeleted();
        }
    }

    private class VertexProcessor
    implements Runnable {
        final long vertexId;
        final List<QueryResult> queryResults;

        private VertexProcessor(long vertexId, List<QueryResult> queryResults) {
            this.vertexId = vertexId;
            this.queryResults = queryResults;
        }

        @Override
        public void run() {
            try {
                FulgoraVertex vertex = new FulgoraVertex(FulgoraExecutor.this.tx, this.vertexId, FulgoraExecutor.this);
                HashMap pulledMessages = new HashMap(FulgoraExecutor.this.queryDefinitions.size());
                for (QueryResult qr : this.queryResults) {
                    String queryName = qr.queryName;
                    FulgoraRelationQuery frq = (FulgoraRelationQuery)FulgoraExecutor.this.queryDefinitions.get(queryName);
                    Preconditions.checkState((frq != null && qr.vertexId == this.vertexId ? 1 : 0) != 0);
                    Object combinedMsg = pulledMessages.get(queryName);
                    Iterator<Entry> iter = qr.entries.reuseIterator();
                    while (iter.hasNext()) {
                        Entry data = iter.next();
                        InternalRelation r = RelationConstructor.readRelation(vertex, data, FulgoraExecutor.this.edgeSerializer, (TypeInspector)FulgoraExecutor.this.tx, FulgoraExecutor.this.neighborVertices);
                        if (frq instanceof FulgoraPropertyQuery) {
                            Preconditions.checkArgument((boolean)(r instanceof TitanProperty));
                            combinedMsg = ((FulgoraPropertyQuery)frq).process((TitanProperty)((Object)r), combinedMsg);
                            continue;
                        }
                        assert (frq instanceof FulgoraEdgeQuery);
                        Preconditions.checkArgument((boolean)(r instanceof TitanEdge));
                        combinedMsg = ((FulgoraEdgeQuery)frq).process((TitanEdge)((Object)r), FulgoraExecutor.this.edgeSerializer.parseDirection(data), FulgoraExecutor.this.getVertexState(((TitanEdge)((Object)r)).getOtherVertex(vertex).getLongId()), combinedMsg);
                    }
                    if (combinedMsg == null) continue;
                    pulledMessages.put(queryName, combinedMsg);
                }
                if (FulgoraExecutor.this.idManager.isPartitionedVertex(this.vertexId)) {
                    FulgoraExecutor.this.getMessageAccumulator(this.vertexId).add(pulledMessages);
                } else {
                    FulgoraExecutor.this.processVertex(vertex, pulledMessages);
                }
            }
            catch (Throwable e) {
                log.error("Exception processing relations for [" + this.vertexId + "]: ", e);
                FulgoraExecutor.this.processingException = true;
            }
        }
    }
}

