/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.resource.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.resource.ResourceFilter;
import org.jboss.forge.furnace.util.Assert;

public class ResourceUtil {
    public static byte[] getDigest(Resource<?> resource) {
        try {
            return ResourceUtil.getDigest(resource, MessageDigest.getInstance("MD5"));
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Error calculating digest for resource [" + resource.getFullyQualifiedName() + "]", e);
        }
    }

    public static byte[] getDigest(Resource<?> resource, MessageDigest digest) {
        try (InputStream stream = resource.getResourceInputStream();
             DigestInputStream digestStream = new DigestInputStream(stream, digest);){
            byte[] buffer = new byte[16384];
            while (digestStream.read(buffer, 0, buffer.length) != -1) {
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Error calculating digest for resource [" + resource.getFullyQualifiedName() + "]", e);
        }
        return digest.digest();
    }

    public static File getContextFile(Resource<?> r) {
        do {
            Object o;
            if (!((o = r.getUnderlyingResourceObject()) instanceof File)) continue;
            return (File)r.getUnderlyingResourceObject();
        } while ((r = r.getParent()) != null);
        return null;
    }

    public static DirectoryResource getContextDirectory(Resource<?> r) {
        Resource<?> temp = r;
        do {
            if (!(temp instanceof DirectoryResource)) continue;
            return (DirectoryResource)temp;
        } while (temp != null && (temp = temp.getParent()) != null);
        return null;
    }

    public static boolean isChildOf(Resource<?> parent, Resource<?> isChild) {
        Resource<?> r = isChild;
        while ((r = r.getParent()) != null) {
            if (!r.equals(parent)) continue;
            return true;
        }
        return false;
    }

    public static <E extends Resource<?>, R extends Collection<E>> R filter(ResourceFilter filter, Collection<E> list) {
        ArrayList<Resource> result = new ArrayList<Resource>();
        for (Resource resource : list) {
            if (!filter.accept(resource)) continue;
            result.add(resource);
        }
        return (R)result;
    }

    public static <E extends Resource<?>, R extends Collection<E>, I extends Collection<Resource<?>>> R filterByType(final Class<E> type, I list) {
        ResourceFilter filter = new ResourceFilter(){

            public boolean accept(Resource<?> resource) {
                return type.isAssignableFrom(resource.getClass());
            }
        };
        return ResourceUtil.filter(filter, list);
    }

    public static boolean isParentOf(Resource<?> parent, Resource<?> child) {
        Assert.notNull(parent, (String)"Parent resource must not be null.");
        Assert.notNull(child, (String)"Child resource must not be null.");
        while (child.getParent() != null) {
            if (parent == child.getParent() || parent.equals(child.getParent())) {
                return true;
            }
            child = child.getParent();
        }
        return false;
    }
}

