/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster;

import com.codahale.metrics.annotation.Timed;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.KeyIndexableGraph;
import com.tinkerpop.blueprints.Parameter;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.rexster.AbstractSubResource;
import com.tinkerpop.rexster.EdgeResource;
import com.tinkerpop.rexster.RexsterApplicationGraph;
import com.tinkerpop.rexster.extension.HttpMethod;
import com.tinkerpop.rexster.server.RexsterApplication;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

@Path(value="/graphs/{graphname}/keyindices")
public class KeyIndexResource
extends AbstractSubResource {
    private static final Logger logger = Logger.getLogger(EdgeResource.class);

    public KeyIndexResource() {
        super(null);
    }

    public KeyIndexResource(UriInfo ui, HttpServletRequest req, RexsterApplication ra) {
        super(ra);
        this.httpServletRequest = req;
        this.uriInfo = ui;
    }

    @OPTIONS
    public Response optionsKeyIndices() {
        return this.buildOptionsResponse(HttpMethod.GET.toString());
    }

    @GET
    @Produces(value={"application/json", "application/vnd.rexster-v1+json", "application/vnd.rexster-typed-v1+json"})
    @Timed(name="http.rest.key-indices.collection.get", absolute=true)
    public Response getKeyIndices(@PathParam(value="graphname") String graphName) {
        KeyIndexableGraph graph = this.getKeyIndexableGraph(graphName);
        RexsterApplicationGraph rag = this.getRexsterApplicationGraph(graphName);
        try {
            final JSONArray keyVertexArray = new JSONArray();
            for (String key : graph.getIndexedKeys(Vertex.class)) {
                keyVertexArray.put((Object)key);
            }
            final JSONArray keyEdgeArray = new JSONArray();
            for (String key : graph.getIndexedKeys(Edge.class)) {
                keyEdgeArray.put((Object)key);
            }
            this.resultObject.put("results", (Object)new JSONObject((Map)new HashMap(){
                {
                    this.put("vertex", keyVertexArray);
                    this.put("edge", keyEdgeArray);
                }
            }));
            this.resultObject.put("queryTime", this.sh.stopWatch());
        }
        catch (JSONException ex) {
            logger.error((Object)ex);
            JSONObject error = this.generateErrorObjectJsonFail(ex);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error).build());
        }
        finally {
            rag.tryCommit();
        }
        return Response.ok((Object)this.resultObject).build();
    }

    @OPTIONS
    @Path(value="/{clazz}")
    public Response optionsIndexKeys() {
        return this.buildOptionsResponse(HttpMethod.GET.toString());
    }

    @GET
    @Path(value="/{clazz}")
    @Produces(value={"application/json", "application/vnd.rexster-v1+json", "application/vnd.rexster-typed-v1+json"})
    @Timed(name="http.rest.key-indices.class.collection.get", absolute=true)
    public Response getIndexKeys(@PathParam(value="graphname") String graphName, @PathParam(value="clazz") String clazz) {
        Class<Vertex> keyClass;
        if (clazz.equals("vertex")) {
            keyClass = Vertex.class;
        } else if (clazz.equals("edge")) {
            keyClass = Edge.class;
        } else {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).build());
        }
        KeyIndexableGraph graph = this.getKeyIndexableGraph(graphName);
        RexsterApplicationGraph rag = this.getRexsterApplicationGraph(graphName);
        try {
            JSONArray keyArray = new JSONArray();
            for (String key : graph.getIndexedKeys(keyClass)) {
                keyArray.put((Object)key);
            }
            this.resultObject.put("results", (Object)keyArray);
            this.resultObject.put("queryTime", this.sh.stopWatch());
        }
        catch (JSONException ex) {
            logger.error((Object)ex);
            JSONObject error = this.generateErrorObjectJsonFail(ex);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error).build());
        }
        finally {
            rag.tryCommit();
        }
        return Response.ok((Object)this.resultObject).build();
    }

    @OPTIONS
    @Path(value="/{clazz}/{keyName}")
    public Response optionsIndexKey() {
        return this.buildOptionsResponse(HttpMethod.DELETE.toString(), HttpMethod.POST.toString());
    }

    @DELETE
    @Path(value="{clazz}/{keyName}")
    @Produces(value={"application/json", "application/vnd.rexster-v1+json", "application/vnd.rexster-typed-v1+json"})
    @Timed(name="http.rest.key-indices.object.delete", absolute=true)
    public Response deleteIndexKey(@PathParam(value="graphname") String graphName, @PathParam(value="clazz") String clazz, @PathParam(value="keyName") String keyName) {
        Class<Vertex> keyClass;
        if (clazz.equals("vertex")) {
            keyClass = Vertex.class;
        } else if (clazz.equals("edge")) {
            keyClass = Edge.class;
        } else {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).build());
        }
        if (keyName == null || keyName.isEmpty()) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).build());
        }
        RexsterApplicationGraph rag = this.getRexsterApplicationGraph(graphName);
        KeyIndexableGraph graph = this.getKeyIndexableGraph(graphName);
        try {
            graph.dropKeyIndex(keyName, keyClass);
            rag.tryCommit();
            this.resultObject.put("queryTime", this.sh.stopWatch());
        }
        catch (JSONException ex) {
            logger.error((Object)ex);
            rag.tryRollback();
            JSONObject error = this.generateErrorObjectJsonFail(ex);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error).build());
        }
        return Response.ok((Object)this.resultObject).build();
    }

    @POST
    @Path(value="/{clazz}/{keyName}")
    @Produces(value={"application/json", "application/vnd.rexster-v1+json", "application/vnd.rexster-typed-v1+json"})
    @Timed(name="http.rest.key-indices.class.object.post", absolute=true)
    public Response postIndexKey(@PathParam(value="graphname") String graphName, @PathParam(value="clazz") String clazz, @PathParam(value="keyName") String keyName) {
        Class<Vertex> keyClass;
        if (clazz.equals("vertex")) {
            keyClass = Vertex.class;
        } else if (clazz.equals("edge")) {
            keyClass = Edge.class;
        } else {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).build());
        }
        if (keyName == null || keyName.isEmpty()) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).build());
        }
        RexsterApplicationGraph rag = this.getRexsterApplicationGraph(graphName);
        KeyIndexableGraph graph = this.getKeyIndexableGraph(graphName);
        try {
            graph.createKeyIndex(keyName, keyClass, new Parameter[0]);
            rag.tryCommit();
            this.resultObject.put("queryTime", this.sh.stopWatch());
        }
        catch (JSONException ex) {
            logger.error((Object)ex);
            rag.tryRollback();
            JSONObject error = this.generateErrorObjectJsonFail(ex);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error).build());
        }
        return Response.ok((Object)this.resultObject).build();
    }

    private KeyIndexableGraph getKeyIndexableGraph(String graphName) {
        KeyIndexableGraph idxGraph;
        Graph graph = this.getRexsterApplicationGraph(graphName).getUnwrappedGraph();
        KeyIndexableGraph keyIndexableGraph = idxGraph = graph instanceof KeyIndexableGraph ? (KeyIndexableGraph)graph : null;
        if (idxGraph == null) {
            JSONObject error = this.generateErrorObject("The requested graph is not of type IndexableGraph.");
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error).build());
        }
        return idxGraph;
    }
}

