/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster.util;

import com.sun.jersey.server.impl.cdi.CDIComponentProviderFactoryInitializer;
import com.sun.jersey.server.impl.ejb.EJBComponentProviderFactoryInitilizer;
import com.sun.jersey.server.impl.managedbeans.ManagedBeanComponentProviderFactoryInitilizer;
import com.tinkerpop.rexster.util.LogLevel;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class JuliToLog4jHandler
extends Handler {
    private Set<String> loggersRexsterSuppresses = new HashSet<String>(){
        {
            this.add(CDIComponentProviderFactoryInitializer.class.getCanonicalName());
            this.add(EJBComponentProviderFactoryInitilizer.class.getCanonicalName());
            this.add(ManagedBeanComponentProviderFactoryInitilizer.class.getCanonicalName());
        }
    };

    @Override
    public void publish(LogRecord record) {
        if (!this.loggersRexsterSuppresses.contains(record.getLoggerName())) {
            Logger log4j = JuliToLog4jHandler.getTargetLogger(record.getLoggerName());
            org.apache.log4j.Level priority = this.toLog4j(record.getLevel());
            log4j.log((Priority)priority, (Object)this.toLog4jMessage(record), record.getThrown());
        }
    }

    static Logger getTargetLogger(String loggerName) {
        return Logger.getLogger((String)loggerName);
    }

    public static Logger getTargetLogger(Class clazz) {
        return JuliToLog4jHandler.getTargetLogger(clazz.getName());
    }

    private String toLog4jMessage(LogRecord record) {
        String message = record.getMessage();
        try {
            Object[] parameters = record.getParameters();
            if (parameters != null && parameters.length != 0 && (message.indexOf("{0}") >= 0 || message.indexOf("{1}") >= 0 || message.indexOf("{2}") >= 0 || message.indexOf("{3}") >= 0)) {
                message = MessageFormat.format(message, parameters);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return message;
    }

    private org.apache.log4j.Level toLog4j(Level level) {
        LogLevel logLevel = LogLevel.toLogLevel(level);
        switch (logLevel) {
            case ERROR: {
                return org.apache.log4j.Level.ERROR;
            }
            case WARN: {
                return org.apache.log4j.Level.WARN;
            }
            case INFO: {
                return org.apache.log4j.Level.INFO;
            }
            case DEBUG: {
                return org.apache.log4j.Level.DEBUG;
            }
            case TRACE: {
                return org.apache.log4j.Level.TRACE;
            }
        }
        return org.apache.log4j.Level.OFF;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }
}

