/*
 * Decompiled with CFR 0.152.
 */
package org.xadisk.filesystem.pools;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Set;
import org.xadisk.filesystem.pools.PooledResource;

public class PooledSelector
implements PooledResource {
    private volatile long lastFreed = -1L;
    private Selector selector = Selector.open();

    public long getLastFreed() {
        return this.lastFreed;
    }

    public Selector getSelector() {
        return this.selector;
    }

    public void markFree() {
        Set<SelectionKey> keys = this.selector.keys();
        for (SelectionKey key : keys) {
            key.cancel();
        }
        try {
            this.selector.selectNow();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.lastFreed = System.currentTimeMillis() / 1000L;
    }
}

