/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.cl.parser;

import java.util.List;
import org.jboss.aesh.cl.CommandLine;
import org.jboss.aesh.cl.exception.ArgumentParserException;
import org.jboss.aesh.cl.exception.CommandLineParserException;
import org.jboss.aesh.cl.exception.OptionParserException;
import org.jboss.aesh.cl.exception.RequiredOptionException;
import org.jboss.aesh.cl.internal.OptionType;
import org.jboss.aesh.cl.internal.ProcessedCommand;
import org.jboss.aesh.cl.internal.ProcessedOption;
import org.jboss.aesh.cl.parser.AeshCommandLineCompletionParser;
import org.jboss.aesh.cl.parser.AeshCommandPopulator;
import org.jboss.aesh.cl.parser.CommandLineCompletionParser;
import org.jboss.aesh.cl.parser.CommandLineParser;
import org.jboss.aesh.cl.parser.CommandPopulator;
import org.jboss.aesh.parser.AeshLine;
import org.jboss.aesh.parser.Parser;
import org.jboss.aesh.parser.ParserStatus;

public class AeshCommandLineParser
implements CommandLineParser {
    private final ProcessedCommand command;
    private static final String EQUALS = "=";

    public AeshCommandLineParser(ProcessedCommand command) {
        this.command = command;
    }

    @Override
    public ProcessedCommand getCommand() {
        return this.command;
    }

    @Override
    public CommandLineCompletionParser getCompletionParser() {
        return new AeshCommandLineCompletionParser(this);
    }

    @Override
    public CommandPopulator getCommandPopulator() {
        return new AeshCommandPopulator(this);
    }

    @Override
    public String printHelp() {
        return this.command.printHelp();
    }

    @Override
    public CommandLine parse(String line) {
        return this.parse(line, false);
    }

    @Override
    public CommandLine parse(String line, boolean ignoreRequirements) {
        AeshLine aeshLine = Parser.findAllWords(line);
        if (aeshLine.getWords().size() > 0) {
            if (this.command.getName().equals(aeshLine.getWords().get(0))) {
                return this.parse(aeshLine.getWords(), ignoreRequirements);
            }
        } else if (aeshLine.getStatus() != ParserStatus.OK) {
            return new CommandLine(new CommandLineParserException(aeshLine.getErrorMessage()));
        }
        return new CommandLine(new CommandLineParserException("Command:" + this.command + ", not found in: " + line));
    }

    @Override
    public CommandLine parse(List<String> lines, boolean ignoreRequirements) {
        RequiredOptionException re;
        this.command.clear();
        CommandLine commandLine = new CommandLine();
        if (this.command.hasArgument()) {
            commandLine.setArgument(this.command.getArgument());
        }
        ProcessedOption active = null;
        boolean addedArgument = false;
        for (int i = 1; i < lines.size(); ++i) {
            int i$;
            String parseLine = lines.get(i);
            if (parseLine.startsWith("--")) {
                if (active != null) {
                    if (active.getOptionType() == OptionType.LIST || active.getOptionType() == OptionType.GROUP) {
                        commandLine.addOption(active);
                        active = null;
                    } else {
                        commandLine.setParserException(new OptionParserException("Option: " + active.getDisplayName() + " must be given a value"));
                        break;
                    }
                }
                if ((active = this.findLongOption(this.command, parseLine.substring(2))) != null) {
                    active.setLongNameUsed(true);
                }
                if (active != null && active.isProperty()) {
                    if (parseLine.length() <= 2 + active.getName().length() || !parseLine.contains(EQUALS)) {
                        commandLine.setParserException(new OptionParserException("Option " + active.getDisplayName() + ", must be part of a property"));
                        continue;
                    }
                    String string = parseLine.substring(2 + active.getName().length(), parseLine.indexOf(EQUALS));
                    String value = parseLine.substring(parseLine.indexOf(EQUALS) + 1);
                    if (value.length() < 1) {
                        commandLine.setParserException(new OptionParserException("Option " + active.getDisplayName() + ", must have a value"));
                        continue;
                    }
                    active.addProperty(string, value);
                    commandLine.addOption(active);
                    active = null;
                    if (!addedArgument) continue;
                    commandLine.setParserException(new ArgumentParserException("An argument was given to an option that do not support it."));
                    continue;
                }
                if (active != null && active.getValue() != null) {
                    if (active.getEndsWithSeparator()) continue;
                    commandLine.addOption(active);
                    active = null;
                    continue;
                }
                if (active != null && active.getOptionType().equals((Object)OptionType.BOOLEAN) && (!active.hasValue() || active.getValue() != null)) {
                    active.addValue("true");
                    commandLine.addOption(active);
                    active = null;
                    if (!addedArgument) continue;
                    commandLine.setParserException(new ArgumentParserException("An argument was given to an option that do not support it."));
                    continue;
                }
                if (active != null) continue;
                commandLine.setParserException(new OptionParserException("Option: " + parseLine + " is not a valid option for this command"));
                continue;
            }
            if (parseLine.startsWith("-")) {
                if (active != null) {
                    if (active.getOptionType() == OptionType.LIST || active.getOptionType() == OptionType.GROUP) {
                        commandLine.addOption(active);
                        active = null;
                        continue;
                    }
                    commandLine.setParserException(new OptionParserException("Option: " + active.getDisplayName() + " must be given a value"));
                    break;
                }
                if (parseLine.length() != 2 && !parseLine.contains(EQUALS)) {
                    if (parseLine.length() > 2) {
                        char[] cArray = parseLine.substring(1).toCharArray();
                        int len$ = cArray.length;
                        for (i$ = 0; i$ < len$; ++i$) {
                            char shortName = cArray[i$];
                            active = this.findOption(this.command, String.valueOf(shortName));
                            if (active != null) {
                                if (!active.hasValue()) {
                                    active.setLongNameUsed(false);
                                    active.addValue("true");
                                    commandLine.addOption(active);
                                    continue;
                                }
                                commandLine.setParserException(new OptionParserException("Option: -" + shortName + " can not be grouped with other options since it need to be given a value"));
                                continue;
                            }
                            commandLine.setParserException(new OptionParserException("Option: -" + shortName + " was not found."));
                        }
                        active = null;
                        continue;
                    }
                    commandLine.setParserException(new OptionParserException("Option: - must be followed by a valid operator"));
                    continue;
                }
                active = this.findOption(this.command, parseLine.substring(1));
                if (active != null) {
                    active.setLongNameUsed(false);
                }
                if (active != null && active.isProperty()) {
                    if (parseLine.length() <= 2 || !parseLine.contains(EQUALS)) {
                        commandLine.setParserException(new OptionParserException("Option " + active.getDisplayName() + ", must be part of a property"));
                        continue;
                    }
                    String string = parseLine.substring(2, parseLine.indexOf(EQUALS));
                    String value = parseLine.substring(parseLine.indexOf(EQUALS) + 1);
                    if (value.length() < 1) {
                        commandLine.setParserException(new OptionParserException("Option " + active.getDisplayName() + ", must have a value"));
                        continue;
                    }
                    active.addProperty(string, value);
                    commandLine.addOption(active);
                    active = null;
                    if (!addedArgument) continue;
                    commandLine.setParserException(new OptionParserException("An argument was given to an option that do not support it."));
                    continue;
                }
                if (active != null && active.getValue() != null) {
                    if (active.getEndsWithSeparator()) continue;
                    commandLine.addOption(active);
                    active = null;
                    continue;
                }
                if (active != null && active.getOptionType().equals((Object)OptionType.BOOLEAN) && (!active.hasValue() || active.getValue() != null)) {
                    active.addValue("true");
                    commandLine.addOption(active);
                    active = null;
                    if (!addedArgument) continue;
                    commandLine.setParserException(new OptionParserException("An argument was given to an option that do not support it."));
                    continue;
                }
                if (active != null) continue;
                commandLine.setParserException(new OptionParserException("Option: " + parseLine + " is not a valid option for this command"));
                continue;
            }
            if (active != null) {
                if (active.hasMultipleValues()) {
                    if (parseLine.contains(String.valueOf(active.getValueSeparator()))) {
                        String[] stringArray = parseLine.split(String.valueOf(active.getValueSeparator()));
                        int len$ = stringArray.length;
                        for (i$ = 0; i$ < len$; ++i$) {
                            String value = stringArray[i$];
                            active.addValue(value.trim());
                        }
                        if (parseLine.endsWith(String.valueOf(active.getValueSeparator()))) {
                            active.setEndsWithSeparator(true);
                        }
                        commandLine.addOption(active);
                        active = null;
                    } else {
                        active.addValue(parseLine);
                    }
                } else {
                    active.addValue(parseLine);
                }
                if (active != null && (active.getOptionType() == OptionType.NORMAL || active.getOptionType() == OptionType.BOOLEAN)) {
                    commandLine.addOption(active);
                    active = null;
                }
                if (!addedArgument) continue;
                commandLine.setParserException(new OptionParserException("An argument was given to an option that do not support it."));
                continue;
            }
            if (this.command.getArgument() == null) {
                commandLine.setParserException(new OptionParserException("An argument was given to a command that do not support it."));
                continue;
            }
            commandLine.addArgumentValue(parseLine);
            addedArgument = true;
        }
        if (active != null && (ignoreRequirements || active.getOptionType() == OptionType.LIST || active.getOptionType() == OptionType.GROUP)) {
            commandLine.addOption(active);
        }
        if (!ignoreRequirements && (re = this.checkForMissingRequiredOptions(this.command, commandLine)) != null) {
            commandLine.setParserException(re);
        }
        return commandLine;
    }

    private RequiredOptionException checkForMissingRequiredOptions(ProcessedCommand command, CommandLine commandLine) {
        for (ProcessedOption o : command.getOptions()) {
            if (!o.isRequired()) continue;
            boolean found = false;
            for (ProcessedOption po : commandLine.getOptions()) {
                if (po.getShortName() != null && o.getShortName() != null && po.getShortName().equals(o.getShortName()) || po.getName() != null && po.getName().equals(o.getName())) {
                    found = true;
                    break;
                }
                if (!po.doOverrideRequired()) continue;
                found = true;
                break;
            }
            if (found) continue;
            return new RequiredOptionException("Option: " + o.getDisplayName() + " is required for this command.");
        }
        return null;
    }

    private ProcessedOption findOption(ProcessedCommand command, String line) {
        String rest;
        ProcessedOption option = command.findOption(line);
        if (option != null) {
            return option;
        }
        option = command.startWithOption(line);
        if (option != null && option.isProperty()) {
            return option;
        }
        if (option != null && (rest = line.substring(option.getShortName().length())).length() > 1 && rest.startsWith(EQUALS)) {
            if (option.getOptionType().equals((Object)OptionType.LIST) && rest.indexOf(option.getValueSeparator()) > -1) {
                for (String value : rest.substring(1).split(String.valueOf(option.getValueSeparator()))) {
                    option.addValue(value.trim());
                }
                if (rest.endsWith(String.valueOf(option.getValueSeparator()))) {
                    option.setEndsWithSeparator(true);
                }
            } else {
                option.addValue(rest.substring(1));
            }
            return option;
        }
        return null;
    }

    private ProcessedOption findLongOption(ProcessedCommand command, String line) {
        String rest;
        ProcessedOption option = command.findLongOptionNoActivatorCheck(line);
        if (option != null) {
            return option;
        }
        option = command.startWithLongOption(line);
        if (option != null && option.isProperty()) {
            return option;
        }
        if (option != null && (rest = line.substring(option.getName().length())).length() > 1 && rest.startsWith(EQUALS)) {
            if (option.getOptionType().equals((Object)OptionType.LIST) && rest.indexOf(option.getValueSeparator()) > -1) {
                for (String value : rest.substring(1).split(String.valueOf(option.getValueSeparator()))) {
                    option.addValue(value.trim());
                }
                if (rest.endsWith(String.valueOf(option.getValueSeparator()))) {
                    option.setEndsWithSeparator(true);
                }
            } else {
                option.addValue(rest.substring(1));
            }
            return option;
        }
        return null;
    }

    public String toString() {
        return "CommandLineParser{command=" + this.command + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AeshCommandLineParser)) {
            return false;
        }
        AeshCommandLineParser that = (AeshCommandLineParser)o;
        return this.command.equals(that.command);
    }

    public int hashCode() {
        return this.command.hashCode();
    }
}

