/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.gmbal.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.management.Descriptor;
import org.glassfish.gmbal.DescriptorFields;
import org.glassfish.gmbal.DescriptorKey;
import org.glassfish.gmbal.impl.DescriptorUtility;
import org.glassfish.gmbal.impl.Exceptions;
import org.glassfish.gmbal.impl.ManagedObjectManagerInternal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescriptorIntrospector {
    private DescriptorIntrospector() {
    }

    public static Descriptor descriptorForElement(ManagedObjectManagerInternal mom, AnnotatedElement elmt) {
        if (elmt == null) {
            return DescriptorUtility.EMPTY_DESCRIPTOR;
        }
        Collection<Annotation> annots = null;
        annots = mom == null ? Arrays.asList(elmt.getAnnotations()) : mom.getAnnotations(elmt);
        return DescriptorIntrospector.descriptorForAnnotations(annots);
    }

    private static Descriptor descriptorForAnnotations(Collection<Annotation> annots) {
        if (annots.isEmpty()) {
            return DescriptorUtility.EMPTY_DESCRIPTOR;
        }
        HashMap<String, Object> descriptorMap = new HashMap<String, Object>();
        for (Annotation a : annots) {
            if (a instanceof DescriptorFields) {
                DescriptorIntrospector.addDescriptorFieldsToMap(descriptorMap, (DescriptorFields)a);
            }
            DescriptorIntrospector.addAnnotationFieldsToMap(descriptorMap, a);
        }
        if (descriptorMap.isEmpty()) {
            return DescriptorUtility.EMPTY_DESCRIPTOR;
        }
        return DescriptorUtility.makeDescriptor(descriptorMap);
    }

    private static void addDescriptorFieldsToMap(Map<String, Object> descriptorMap, DescriptorFields df) {
        for (String field : df.value()) {
            int eq = field.indexOf(61);
            if (eq < 0) {
                throw Exceptions.self.excForAddDescriptorFieldsToMap(field);
            }
            String name = field.substring(0, eq);
            String value = field.substring(eq + 1);
            DescriptorIntrospector.addToMap(descriptorMap, name, value);
        }
    }

    private static void addAnnotationFieldsToMap(Map<String, Object> descriptorMap, Annotation a) {
        Method[] elements;
        Class<? extends Annotation> c = a.annotationType();
        for (Method element : elements = c.getMethods()) {
            Object value;
            DescriptorKey key = element.getAnnotation(DescriptorKey.class);
            if (key == null) continue;
            String name = key.value();
            try {
                value = element.invoke((Object)a, new Object[0]);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw Exceptions.self.excForAddAnnotationFieldsToMap(e);
            }
            if (key.omitIfDefault() && DescriptorIntrospector.equals(value, element.getDefaultValue())) continue;
            value = DescriptorIntrospector.annotationToField(value);
            DescriptorIntrospector.addToMap(descriptorMap, name, value);
        }
    }

    private static void addToMap(Map<String, Object> descriptorMap, String name, Object value) {
        Object oldValue = descriptorMap.put(name, value);
        if (oldValue != null && !DescriptorIntrospector.equals(oldValue, value)) {
            throw Exceptions.self.excForAddToMap(name, value, oldValue);
        }
    }

    private static Object annotationToField(Object x) {
        if (x == null) {
            return null;
        }
        if (x instanceof Number || x instanceof String || x instanceof Character || x instanceof Boolean || x instanceof String[]) {
            return x;
        }
        Class<?> c = x.getClass();
        if (c.isArray()) {
            if (c.getComponentType().isPrimitive()) {
                return x;
            }
            Object[] xx = (Object[])x;
            String[] ss = new String[xx.length];
            for (int i = 0; i < xx.length; ++i) {
                ss[i] = (String)DescriptorIntrospector.annotationToField(xx[i]);
            }
            return ss;
        }
        if (x instanceof Class) {
            return ((Class)x).getName();
        }
        if (x instanceof Enum) {
            return ((Enum)x).name();
        }
        if (Proxy.isProxyClass(c)) {
            c = c.getInterfaces()[0];
        }
        throw Exceptions.self.excForAnnotationToField(c.getName());
    }

    private static boolean equals(Object x, Object y) {
        return Arrays.deepEquals(new Object[]{x}, new Object[]{y});
    }
}

