/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster.protocol.msg;

import com.tinkerpop.rexster.client.RexProException;
import com.tinkerpop.rexster.protocol.BitWorks;
import com.tinkerpop.rexster.protocol.msg.ErrorResponseMessage;
import com.tinkerpop.rexster.protocol.msg.RexProBindings;
import com.tinkerpop.rexster.protocol.msg.RexProMessageMeta;
import com.tinkerpop.rexster.protocol.msg.RexProMessageMetaField;
import com.tinkerpop.rexster.protocol.msg.RexProScriptResult;
import com.tinkerpop.rexster.protocol.msg.ScriptRequestMessage;
import com.tinkerpop.rexster.protocol.msg.ScriptResponseMessage;
import com.tinkerpop.rexster.protocol.msg.SessionRequestMessage;
import com.tinkerpop.rexster.protocol.msg.SessionResponseMessage;
import com.tinkerpop.rexster.protocol.serializer.msgpack.templates.MetaTemplate;
import com.tinkerpop.rexster.protocol.serializer.msgpack.templates.ResultsTemplate;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.UUID;
import org.msgpack.MessagePack;
import org.msgpack.template.Template;

public abstract class RexProMessage {
    public static final int MESSAGE_HEADER_SIZE = 6;
    private static final MessagePack msgpack = new MessagePack();
    public static final UUID EMPTY_SESSION;
    public static final byte[] EMPTY_SESSION_AS_BYTES;
    public static final UUID EMPTY_REQUEST;
    public static final byte[] EMPTY_REQUEST_AS_BYTES;
    public byte[] Session;
    public byte[] Request;
    public RexProMessageMeta Meta = new RexProMessageMeta();

    protected RexProMessageMetaField[] getMetaFields() {
        RexProMessageMetaField[] fields = new RexProMessageMetaField[]{};
        return fields;
    }

    public boolean hasSession() {
        return this.Session != null && !this.sessionAsUUID().equals(EMPTY_SESSION);
    }

    public UUID sessionAsUUID() {
        return BitWorks.convertByteArrayToUUID(this.Session);
    }

    public void setSessionAsUUID(UUID session) {
        this.Session = BitWorks.convertUUIDToByteArray(session);
    }

    public UUID requestAsUUID() {
        return BitWorks.convertByteArrayToUUID(this.Request);
    }

    public void setRequestAsUUID(UUID request) {
        this.Request = BitWorks.convertUUIDToByteArray(request);
    }

    public void validateMetaData() throws RexProException {
        for (RexProMessageMetaField f : this.getMetaFields()) {
            f.validateMeta(this.Meta);
        }
    }

    public static byte[] serialize(RexProMessage msg) throws IOException {
        byte[] message = msgpack.write((Object)msg);
        ByteBuffer bb = ByteBuffer.allocate(6 + message.length);
        bb.put((byte)0);
        if (msg instanceof SessionResponseMessage) {
            bb.put((byte)2);
        } else if (msg instanceof ErrorResponseMessage) {
            bb.put((byte)0);
        } else if (msg instanceof ScriptRequestMessage) {
            bb.put((byte)3);
        } else if (msg instanceof SessionRequestMessage) {
            bb.put((byte)1);
        } else if (msg instanceof ScriptResponseMessage) {
            bb.put((byte)5);
        }
        bb.putInt(message.length);
        bb.put(message);
        return bb.array();
    }

    static {
        msgpack.register(RexProMessageMeta.class, (Template)MetaTemplate.getInstance());
        msgpack.register(RexProBindings.class, (Template)RexProBindings.SerializationTemplate.getInstance());
        msgpack.register(RexProScriptResult.class, (Template)ResultsTemplate.getInstance());
        EMPTY_SESSION = new UUID(0L, 0L);
        EMPTY_SESSION_AS_BYTES = BitWorks.convertUUIDToByteArray(EMPTY_SESSION);
        EMPTY_REQUEST = new UUID(0L, 0L);
        EMPTY_REQUEST_AS_BYTES = BitWorks.convertUUIDToByteArray(EMPTY_REQUEST);
    }
}

